/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.chatcommands;

import com.google.inject.Provides;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.Experience;
import net.runelite.api.IconID;
import net.runelite.api.ItemComposition;
import net.runelite.api.MessageNode;
import net.runelite.api.VarPlayer;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.VarbitChanged;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.vars.AccountType;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatCommandManager;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ChatInput;
import net.runelite.client.game.ItemManager;
import net.runelite.client.input.KeyManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.chatcommands.ChatCommandsConfig;
import net.runelite.client.plugins.chatcommands.ChatKeyboardListener;
import net.runelite.client.plugins.chatcommands.SkillAbbreviations;
import net.runelite.client.util.StackFormatter;
import net.runelite.client.util.Text;
import net.runelite.http.api.chat.ChatClient;
import net.runelite.http.api.hiscore.HiscoreClient;
import net.runelite.http.api.hiscore.HiscoreEndpoint;
import net.runelite.http.api.hiscore.HiscoreResult;
import net.runelite.http.api.hiscore.HiscoreSkill;
import net.runelite.http.api.hiscore.SingleHiscoreSkillResult;
import net.runelite.http.api.hiscore.Skill;
import net.runelite.http.api.item.ItemPrice;
import org.apache.commons.text.WordUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Chat Commands", description="Enable chat commands", tags={"grand", "exchange", "level", "prices"})
public class ChatCommandsPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(ChatCommandsPlugin.class);
    private static final float HIGH_ALCHEMY_CONSTANT = 0.6f;
    private static final Pattern KILLCOUNT_PATTERN = Pattern.compile("Your (.+) (?:kill|harvest) count is: <col=ff0000>(\\d+)</col>");
    private static final Pattern RAIDS_PATTERN = Pattern.compile("Your completed (.+) count is: <col=ff0000>(\\d+)</col>");
    private static final Pattern WINTERTODT_PATTERN = Pattern.compile("Your subdued Wintertodt count is: <col=ff0000>(\\d+)</col>");
    private static final Pattern BARROWS_PATTERN = Pattern.compile("Your Barrows chest count is: <col=ff0000>(\\d+)</col>");
    private static final Pattern KILL_DURATION_PATTERN = Pattern.compile("Fight duration: <col=ff0000>[0-9:]+</col>. Personal best: ([0-9:]+)");
    private static final Pattern NEW_PB_PATTERN = Pattern.compile("Fight duration: <col=ff0000>([0-9:]+)</col> \\(new personal best\\)");
    private static final String TOTAL_LEVEL_COMMAND_STRING = "!total";
    private static final String PRICE_COMMAND_STRING = "!price";
    private static final String LEVEL_COMMAND_STRING = "!lvl";
    private static final String CLUES_COMMAND_STRING = "!clues";
    private static final String KILLCOUNT_COMMAND_STRING = "!kc";
    private static final String CMB_COMMAND_STRING = "!cmb";
    private static final String QP_COMMAND_STRING = "!qp";
    private static final String PB_COMMAND = "!pb";
    private final HiscoreClient hiscoreClient = new HiscoreClient();
    private final ChatClient chatClient = new ChatClient();
    private boolean logKills;
    private HiscoreEndpoint hiscoreEndpoint;
    private String lastBossKill;
    @Inject
    private Client client;
    @Inject
    private ChatCommandsConfig config;
    @Inject
    private ConfigManager configManager;
    @Inject
    private ItemManager itemManager;
    @Inject
    private ChatMessageManager chatMessageManager;
    @Inject
    private ChatCommandManager chatCommandManager;
    @Inject
    private ScheduledExecutorService executor;
    @Inject
    private KeyManager keyManager;
    @Inject
    private ChatKeyboardListener chatKeyboardListener;

    @Override
    public void startUp() {
        this.keyManager.registerKeyListener(this.chatKeyboardListener);
        this.chatCommandManager.registerCommandAsync(TOTAL_LEVEL_COMMAND_STRING, this::playerSkillLookup);
        this.chatCommandManager.registerCommandAsync(CMB_COMMAND_STRING, this::combatLevelLookup);
        this.chatCommandManager.registerCommand(PRICE_COMMAND_STRING, this::itemPriceLookup);
        this.chatCommandManager.registerCommandAsync(LEVEL_COMMAND_STRING, this::playerSkillLookup);
        this.chatCommandManager.registerCommandAsync(CLUES_COMMAND_STRING, this::clueLookup);
        this.chatCommandManager.registerCommandAsync(KILLCOUNT_COMMAND_STRING, this::killCountLookup, this::killCountSubmit);
        this.chatCommandManager.registerCommandAsync(QP_COMMAND_STRING, this::questPointsLookup, this::questPointsSubmit);
        this.chatCommandManager.registerCommandAsync(PB_COMMAND, this::personalBestLookup, this::personalBestSubmit);
    }

    @Override
    public void shutDown() {
        this.lastBossKill = null;
        this.keyManager.unregisterKeyListener(this.chatKeyboardListener);
        this.chatCommandManager.unregisterCommand(TOTAL_LEVEL_COMMAND_STRING);
        this.chatCommandManager.unregisterCommand(CMB_COMMAND_STRING);
        this.chatCommandManager.unregisterCommand(PRICE_COMMAND_STRING);
        this.chatCommandManager.unregisterCommand(LEVEL_COMMAND_STRING);
        this.chatCommandManager.unregisterCommand(CLUES_COMMAND_STRING);
        this.chatCommandManager.unregisterCommand(KILLCOUNT_COMMAND_STRING);
        this.chatCommandManager.unregisterCommand(QP_COMMAND_STRING);
        this.chatCommandManager.unregisterCommand(PB_COMMAND);
    }

    @Provides
    ChatCommandsConfig provideConfig(ConfigManager configManager) {
        return configManager.getConfig(ChatCommandsConfig.class);
    }

    private void setKc(String boss, int killcount) {
        this.configManager.setConfiguration("killcount." + this.client.getUsername().toLowerCase(), boss.toLowerCase(), killcount);
    }

    private int getKc(String boss) {
        Integer killCount = this.configManager.getConfiguration("killcount." + this.client.getUsername().toLowerCase(), boss.toLowerCase(), Integer.TYPE);
        return killCount == null ? 0 : killCount;
    }

    private void setPb(String boss, int seconds) {
        this.configManager.setConfiguration("personalbest." + this.client.getUsername().toLowerCase(), boss.toLowerCase(), seconds);
    }

    private int getPb(String boss) {
        Integer personalBest = this.configManager.getConfiguration("personalbest." + this.client.getUsername().toLowerCase(), boss.toLowerCase(), Integer.TYPE);
        return personalBest == null ? 0 : personalBest;
    }

    @Subscribe
    public void onChatMessage(ChatMessage chatMessage) {
        int kc;
        if (chatMessage.getType() != ChatMessageType.GAMEMESSAGE && chatMessage.getType() != ChatMessageType.SPAM) {
            return;
        }
        String message = chatMessage.getMessage();
        Matcher matcher = KILLCOUNT_PATTERN.matcher(message);
        if (matcher.find()) {
            String boss = matcher.group(1);
            int kc2 = Integer.parseInt(matcher.group(2));
            this.setKc(boss, kc2);
            this.lastBossKill = boss;
            return;
        }
        matcher = WINTERTODT_PATTERN.matcher(message);
        if (matcher.find()) {
            kc = Integer.parseInt(matcher.group(1));
            this.setKc("Wintertodt", kc);
        }
        if ((matcher = RAIDS_PATTERN.matcher(message)).find()) {
            String boss = matcher.group(1);
            int kc3 = Integer.parseInt(matcher.group(2));
            this.setKc(boss, kc3);
            this.lastBossKill = boss;
            return;
        }
        matcher = BARROWS_PATTERN.matcher(message);
        if (matcher.find()) {
            kc = Integer.parseInt(matcher.group(1));
            this.setKc("Barrows Chests", kc);
        }
        if (this.lastBossKill != null) {
            matcher = KILL_DURATION_PATTERN.matcher(message);
            if (matcher.find()) {
                this.matchPb(matcher);
            }
            if ((matcher = NEW_PB_PATTERN.matcher(message)).find()) {
                this.matchPb(matcher);
            }
        }
        this.lastBossKill = null;
    }

    private void matchPb(Matcher matcher) {
        String personalBest = matcher.group(1);
        String[] s = personalBest.split(":");
        if (s.length == 2) {
            int seconds = Integer.parseInt(s[0]) * 60 + Integer.parseInt(s[1]);
            log.debug("Got personal best for {}: {}", (Object)this.lastBossKill, (Object)seconds);
            this.setPb(this.lastBossKill, seconds);
        }
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        if (!this.logKills) {
            return;
        }
        this.logKills = false;
        Widget title = this.client.getWidget(WidgetInfo.KILL_LOG_TITLE);
        Widget bossMonster = this.client.getWidget(WidgetInfo.KILL_LOG_MONSTER);
        Widget bossKills = this.client.getWidget(WidgetInfo.KILL_LOG_KILLS);
        if (title == null || bossMonster == null || bossKills == null || !"Boss Kill Log".equals(title.getText())) {
            return;
        }
        Widget[] bossChildren = bossMonster.getChildren();
        Widget[] killsChildren = bossKills.getChildren();
        for (int i = 0; i < bossChildren.length; ++i) {
            Widget boss = bossChildren[i];
            Widget kill = killsChildren[i];
            String bossName = boss.getText().replace(":", "");
            int kc = Integer.parseInt(kill.getText().replace(",", ""));
            if (kc == this.getKc(bossName)) continue;
            this.setKc(bossName, kc);
        }
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded widget) {
        if (widget.getGroupId() != 549 || this.client.isInInstancedRegion()) {
            return;
        }
        this.logKills = true;
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged varbitChanged) {
        this.hiscoreEndpoint = this.getLocalHiscoreEndpointType();
    }

    private boolean killCountSubmit(ChatInput chatInput, String value) {
        int idx = value.indexOf(32);
        String boss = ChatCommandsPlugin.longBossName(value.substring(idx + 1));
        int kc = this.getKc(boss);
        if (kc <= 0) {
            return false;
        }
        String playerName = this.client.getLocalPlayer().getName();
        this.executor.execute(() -> {
            try {
                this.chatClient.submitKc(playerName, boss, kc);
            }
            catch (Exception ex) {
                log.warn("unable to submit killcount", ex);
            }
            finally {
                chatInput.resume();
            }
        });
        return true;
    }

    private void killCountLookup(ChatMessage chatMessage, String message) {
        int kc;
        if (!this.config.killcount()) {
            return;
        }
        if (message.length() <= KILLCOUNT_COMMAND_STRING.length()) {
            return;
        }
        ChatMessageType type = chatMessage.getType();
        String search = message.substring(KILLCOUNT_COMMAND_STRING.length() + 1);
        String player = type.equals((Object)ChatMessageType.PRIVATECHATOUT) ? this.client.getLocalPlayer().getName() : Text.sanitize(chatMessage.getName());
        search = ChatCommandsPlugin.longBossName(search);
        try {
            kc = this.chatClient.getKc(player, search);
        }
        catch (IOException ex) {
            log.debug("unable to lookup killcount", ex);
            return;
        }
        String response = new ChatMessageBuilder().append(ChatColorType.HIGHLIGHT).append(search).append(ChatColorType.NORMAL).append(" kill count: ").append(ChatColorType.HIGHLIGHT).append(Integer.toString(kc)).build();
        log.debug("Setting response {}", (Object)response);
        MessageNode messageNode = chatMessage.getMessageNode();
        messageNode.setRuneLiteFormatMessage(response);
        this.chatMessageManager.update(messageNode);
        this.client.refreshChat();
    }

    private void questPointsLookup(ChatMessage chatMessage, String message) {
        int qp;
        if (!this.config.qp()) {
            return;
        }
        ChatMessageType type = chatMessage.getType();
        String player = type.equals((Object)ChatMessageType.PRIVATECHATOUT) ? this.client.getLocalPlayer().getName() : Text.sanitize(chatMessage.getName());
        try {
            qp = this.chatClient.getQp(player);
        }
        catch (IOException ex) {
            log.debug("unable to lookup quest points", ex);
            return;
        }
        String response = new ChatMessageBuilder().append(ChatColorType.NORMAL).append("Quest points: ").append(ChatColorType.HIGHLIGHT).append(Integer.toString(qp)).build();
        log.debug("Setting response {}", (Object)response);
        MessageNode messageNode = chatMessage.getMessageNode();
        messageNode.setRuneLiteFormatMessage(response);
        this.chatMessageManager.update(messageNode);
        this.client.refreshChat();
    }

    private boolean questPointsSubmit(ChatInput chatInput, String value) {
        int qp = this.client.getVar(VarPlayer.QUEST_POINTS);
        String playerName = this.client.getLocalPlayer().getName();
        this.executor.execute(() -> {
            try {
                this.chatClient.submitQp(playerName, qp);
            }
            catch (Exception ex) {
                log.warn("unable to submit quest points", ex);
            }
            finally {
                chatInput.resume();
            }
        });
        return true;
    }

    private void personalBestLookup(ChatMessage chatMessage, String message) {
        int pb;
        if (!this.config.pb()) {
            return;
        }
        if (message.length() <= PB_COMMAND.length()) {
            return;
        }
        ChatMessageType type = chatMessage.getType();
        String search = message.substring(PB_COMMAND.length() + 1);
        String player = type.equals((Object)ChatMessageType.PRIVATECHATOUT) ? this.client.getLocalPlayer().getName() : Text.sanitize(chatMessage.getName());
        search = ChatCommandsPlugin.longBossName(search);
        try {
            pb = this.chatClient.getPb(player, search);
        }
        catch (IOException ex) {
            log.debug("unable to lookup personal best", ex);
            return;
        }
        int minutes = pb / 60;
        int seconds = pb % 60;
        String response = new ChatMessageBuilder().append(ChatColorType.HIGHLIGHT).append(search).append(ChatColorType.NORMAL).append(" personal best: ").append(ChatColorType.HIGHLIGHT).append(String.format("%d:%02d", minutes, seconds)).build();
        log.debug("Setting response {}", (Object)response);
        MessageNode messageNode = chatMessage.getMessageNode();
        messageNode.setRuneLiteFormatMessage(response);
        this.chatMessageManager.update(messageNode);
        this.client.refreshChat();
    }

    private boolean personalBestSubmit(ChatInput chatInput, String value) {
        int idx = value.indexOf(32);
        String boss = ChatCommandsPlugin.longBossName(value.substring(idx + 1));
        int pb = this.getPb(boss);
        if (pb <= 0) {
            return false;
        }
        String playerName = this.client.getLocalPlayer().getName();
        this.executor.execute(() -> {
            try {
                this.chatClient.submitPb(playerName, boss, pb);
            }
            catch (Exception ex) {
                log.warn("unable to submit personal best", ex);
            }
            finally {
                chatInput.resume();
            }
        });
        return true;
    }

    private void itemPriceLookup(ChatMessage chatMessage, String message) {
        if (!this.config.price()) {
            return;
        }
        if (message.length() <= PRICE_COMMAND_STRING.length()) {
            return;
        }
        MessageNode messageNode = chatMessage.getMessageNode();
        String search = message.substring(PRICE_COMMAND_STRING.length() + 1);
        List<ItemPrice> results = this.itemManager.search(search);
        if (!results.isEmpty()) {
            ItemPrice item = this.retrieveFromList(results, search);
            int itemId = item.getId();
            int itemPrice = item.getPrice();
            ChatMessageBuilder builder = new ChatMessageBuilder().append(ChatColorType.NORMAL).append("Price of ").append(ChatColorType.HIGHLIGHT).append(item.getName()).append(ChatColorType.NORMAL).append(": GE average ").append(ChatColorType.HIGHLIGHT).append(StackFormatter.formatNumber(itemPrice));
            ItemComposition itemComposition = this.itemManager.getItemComposition(itemId);
            if (itemComposition != null) {
                int alchPrice = Math.round((float)itemComposition.getPrice() * 0.6f);
                builder.append(ChatColorType.NORMAL).append(" HA value ").append(ChatColorType.HIGHLIGHT).append(StackFormatter.formatNumber(alchPrice));
            }
            String response = builder.build();
            log.debug("Setting response {}", (Object)response);
            messageNode.setRuneLiteFormatMessage(response);
            this.chatMessageManager.update(messageNode);
            this.client.refreshChat();
        }
    }

    private void playerSkillLookup(ChatMessage chatMessage, String message) {
        HiscoreSkill skill;
        String search;
        if (!this.config.lvl()) {
            return;
        }
        if (message.equalsIgnoreCase(TOTAL_LEVEL_COMMAND_STRING)) {
            search = "total";
        } else {
            if (message.length() <= LEVEL_COMMAND_STRING.length()) {
                return;
            }
            search = message.substring(LEVEL_COMMAND_STRING.length() + 1);
        }
        search = SkillAbbreviations.getFullName(search);
        try {
            skill = HiscoreSkill.valueOf(search.toUpperCase());
        }
        catch (IllegalArgumentException i) {
            return;
        }
        HiscoreLookup lookup = this.getCorrectLookupFor(chatMessage);
        try {
            SingleHiscoreSkillResult result = this.hiscoreClient.lookup(lookup.getName(), skill, lookup.getEndpoint());
            if (result == null) {
                log.warn("unable to look up skill {} for {}: not found", (Object)skill, (Object)search);
                return;
            }
            Skill hiscoreSkill = result.getSkill();
            String response = new ChatMessageBuilder().append(ChatColorType.NORMAL).append("Level ").append(ChatColorType.HIGHLIGHT).append(skill.getName()).append(": ").append(String.valueOf(hiscoreSkill.getLevel())).append(ChatColorType.NORMAL).append(" Experience: ").append(ChatColorType.HIGHLIGHT).append(String.format("%,d", hiscoreSkill.getExperience())).append(ChatColorType.NORMAL).append(" Rank: ").append(ChatColorType.HIGHLIGHT).append(String.format("%,d", hiscoreSkill.getRank())).build();
            log.debug("Setting response {}", (Object)response);
            MessageNode messageNode = chatMessage.getMessageNode();
            messageNode.setRuneLiteFormatMessage(response);
            this.chatMessageManager.update(messageNode);
            this.client.refreshChat();
        }
        catch (IOException ex) {
            log.warn("unable to look up skill {} for {}", new Object[]{skill, search, ex});
        }
    }

    private void combatLevelLookup(ChatMessage chatMessage, String message) {
        if (!this.config.lvl()) {
            return;
        }
        ChatMessageType type = chatMessage.getType();
        String player = type == ChatMessageType.PRIVATECHATOUT ? this.client.getLocalPlayer().getName() : Text.sanitize(chatMessage.getName());
        try {
            HiscoreResult playerStats = this.hiscoreClient.lookup(player);
            if (playerStats == null) {
                log.warn("Error fetching hiscore data: not found");
                return;
            }
            int attack = playerStats.getAttack().getLevel();
            int strength = playerStats.getStrength().getLevel();
            int defence = playerStats.getDefence().getLevel();
            int hitpoints = playerStats.getHitpoints().getLevel();
            int ranged = playerStats.getRanged().getLevel();
            int prayer = playerStats.getPrayer().getLevel();
            int magic = playerStats.getMagic().getLevel();
            int combatLevel = Experience.getCombatLevel(attack, strength, defence, hitpoints, magic, ranged, prayer);
            String response = new ChatMessageBuilder().append(ChatColorType.NORMAL).append("Combat Level: ").append(ChatColorType.HIGHLIGHT).append(String.valueOf(combatLevel)).append(ChatColorType.NORMAL).append(" A: ").append(ChatColorType.HIGHLIGHT).append(String.valueOf(attack)).append(ChatColorType.NORMAL).append(" S: ").append(ChatColorType.HIGHLIGHT).append(String.valueOf(strength)).append(ChatColorType.NORMAL).append(" D: ").append(ChatColorType.HIGHLIGHT).append(String.valueOf(defence)).append(ChatColorType.NORMAL).append(" H: ").append(ChatColorType.HIGHLIGHT).append(String.valueOf(hitpoints)).append(ChatColorType.NORMAL).append(" R: ").append(ChatColorType.HIGHLIGHT).append(String.valueOf(ranged)).append(ChatColorType.NORMAL).append(" P: ").append(ChatColorType.HIGHLIGHT).append(String.valueOf(prayer)).append(ChatColorType.NORMAL).append(" M: ").append(ChatColorType.HIGHLIGHT).append(String.valueOf(magic)).build();
            log.debug("Setting response {}", (Object)response);
            MessageNode messageNode = chatMessage.getMessageNode();
            messageNode.setRuneLiteFormatMessage(response);
            this.chatMessageManager.update(messageNode);
            this.client.refreshChat();
        }
        catch (IOException ex) {
            log.warn("Error fetching hiscore data", ex);
        }
    }

    private void clueLookup(ChatMessage chatMessage, String message) {
        if (!this.config.clue()) {
            return;
        }
        String search = message.equalsIgnoreCase(CLUES_COMMAND_STRING) ? "total" : message.substring(CLUES_COMMAND_STRING.length() + 1);
        try {
            Skill hiscoreSkill;
            String level;
            HiscoreLookup lookup = this.getCorrectLookupFor(chatMessage);
            HiscoreResult result = this.hiscoreClient.lookup(lookup.getName(), lookup.getEndpoint());
            if (result == null) {
                log.warn("error looking up clues: not found");
                return;
            }
            switch (level = search.toLowerCase()) {
                case "beginner": {
                    hiscoreSkill = result.getClueScrollBeginner();
                    break;
                }
                case "easy": {
                    hiscoreSkill = result.getClueScrollEasy();
                    break;
                }
                case "medium": {
                    hiscoreSkill = result.getClueScrollMedium();
                    break;
                }
                case "hard": {
                    hiscoreSkill = result.getClueScrollHard();
                    break;
                }
                case "elite": {
                    hiscoreSkill = result.getClueScrollElite();
                    break;
                }
                case "master": {
                    hiscoreSkill = result.getClueScrollMaster();
                    break;
                }
                case "total": {
                    hiscoreSkill = result.getClueScrollAll();
                    break;
                }
                default: {
                    return;
                }
            }
            int quantity = hiscoreSkill.getLevel();
            int rank = hiscoreSkill.getRank();
            if (quantity == -1) {
                return;
            }
            ChatMessageBuilder chatMessageBuilder = new ChatMessageBuilder().append(ChatColorType.NORMAL).append("Clue scroll (" + level + ")").append(": ").append(ChatColorType.HIGHLIGHT).append(Integer.toString(quantity));
            if (rank != -1) {
                chatMessageBuilder.append(ChatColorType.NORMAL).append(" Rank: ").append(ChatColorType.HIGHLIGHT).append(String.format("%,d", rank));
            }
            String response = chatMessageBuilder.build();
            log.debug("Setting response {}", (Object)response);
            MessageNode messageNode = chatMessage.getMessageNode();
            messageNode.setRuneLiteFormatMessage(response);
            this.chatMessageManager.update(messageNode);
            this.client.refreshChat();
        }
        catch (IOException ex) {
            log.warn("error looking up clues", ex);
        }
    }

    private HiscoreLookup getCorrectLookupFor(ChatMessage chatMessage) {
        HiscoreEndpoint ironmanStatus;
        String player;
        if (chatMessage.getType().equals((Object)ChatMessageType.PRIVATECHATOUT)) {
            player = this.client.getLocalPlayer().getName();
            ironmanStatus = this.hiscoreEndpoint;
        } else {
            player = Text.sanitize(chatMessage.getName());
            ironmanStatus = player.equals(this.client.getLocalPlayer().getName()) ? this.hiscoreEndpoint : ChatCommandsPlugin.getHiscoreEndpointByName(chatMessage.getName());
        }
        return new HiscoreLookup(player, ironmanStatus);
    }

    private ItemPrice retrieveFromList(List<ItemPrice> items, String originalInput) {
        ItemPrice shortest = null;
        for (ItemPrice item : items) {
            if (item.getName().toLowerCase().equals(originalInput.toLowerCase())) {
                return item;
            }
            if (shortest != null && item.getName().length() >= shortest.getName().length()) continue;
            shortest = item;
        }
        return shortest;
    }

    private HiscoreEndpoint getLocalHiscoreEndpointType() {
        return ChatCommandsPlugin.toEndPoint(this.client.getAccountType());
    }

    private static HiscoreEndpoint getHiscoreEndpointByName(String name) {
        if (name.contains(IconID.IRONMAN.toString())) {
            return ChatCommandsPlugin.toEndPoint(AccountType.IRONMAN);
        }
        if (name.contains(IconID.ULTIMATE_IRONMAN.toString())) {
            return ChatCommandsPlugin.toEndPoint(AccountType.ULTIMATE_IRONMAN);
        }
        if (name.contains(IconID.HARDCORE_IRONMAN.toString())) {
            return ChatCommandsPlugin.toEndPoint(AccountType.HARDCORE_IRONMAN);
        }
        return ChatCommandsPlugin.toEndPoint(AccountType.NORMAL);
    }

    private static HiscoreEndpoint toEndPoint(AccountType accountType) {
        switch (accountType) {
            case IRONMAN: {
                return HiscoreEndpoint.IRONMAN;
            }
            case ULTIMATE_IRONMAN: {
                return HiscoreEndpoint.ULTIMATE_IRONMAN;
            }
            case HARDCORE_IRONMAN: {
                return HiscoreEndpoint.HARDCORE_IRONMAN;
            }
        }
        return HiscoreEndpoint.NORMAL;
    }

    private static String longBossName(String boss) {
        switch (boss.toLowerCase()) {
            case "corp": {
                return "Corporeal Beast";
            }
            case "jad": {
                return "TzTok-Jad";
            }
            case "kq": {
                return "Kalphite Queen";
            }
            case "chaos ele": {
                return "Chaos Elemental";
            }
            case "dusk": 
            case "dawn": 
            case "gargs": {
                return "Grotesque Guardians";
            }
            case "crazy arch": {
                return "Crazy Archaeologist";
            }
            case "deranged arch": {
                return "Deranged Archaeologist";
            }
            case "mole": {
                return "Giant Mole";
            }
            case "vetion": {
                return "Vet'ion";
            }
            case "vene": {
                return "Venenatis";
            }
            case "kbd": {
                return "King Black Dragon";
            }
            case "vork": {
                return "Vorkath";
            }
            case "sire": {
                return "Abyssal Sire";
            }
            case "smoke devil": 
            case "thermy": {
                return "Thermonuclear Smoke Devil";
            }
            case "cerb": {
                return "Cerberus";
            }
            case "zuk": 
            case "inferno": {
                return "TzKal-Zuk";
            }
            case "hydra": {
                return "Alchemical Hydra";
            }
            case "sara": 
            case "saradomin": 
            case "zilyana": 
            case "zily": {
                return "Commander Zilyana";
            }
            case "zammy": 
            case "zamorak": 
            case "kril": 
            case "kril trutsaroth": {
                return "K'ril Tsutsaroth";
            }
            case "arma": 
            case "kree": 
            case "kreearra": 
            case "armadyl": {
                return "Kree'arra";
            }
            case "bando": 
            case "bandos": 
            case "graardor": {
                return "General Graardor";
            }
            case "supreme": {
                return "Dagannoth Supreme";
            }
            case "rex": {
                return "Dagannoth Rex";
            }
            case "prime": {
                return "Dagannoth Prime";
            }
            case "wt": {
                return "Wintertodt";
            }
            case "barrows": {
                return "Barrows Chests";
            }
            case "herbi": {
                return "Herbiboar";
            }
            case "cox": 
            case "xeric": 
            case "chambers": 
            case "olm": 
            case "raids": {
                return "Chambers of Xeric";
            }
            case "cox cm": 
            case "xeric cm": 
            case "chambers cm": 
            case "olm cm": 
            case "raids cm": {
                return "Chambers of Xeric Challenge Mode";
            }
            case "tob": 
            case "theatre": 
            case "verzik": 
            case "verzik vitur": 
            case "raids 2": {
                return "Theatre of Blood";
            }
        }
        return WordUtils.capitalize(boss);
    }

    private static final class HiscoreLookup {
        private final String name;
        private final HiscoreEndpoint endpoint;

        public HiscoreLookup(String name, HiscoreEndpoint endpoint) {
            this.name = name;
            this.endpoint = endpoint;
        }

        public String getName() {
            return this.name;
        }

        public HiscoreEndpoint getEndpoint() {
            return this.endpoint;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof HiscoreLookup)) {
                return false;
            }
            HiscoreLookup other = (HiscoreLookup)o;
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            HiscoreEndpoint this$endpoint = this.getEndpoint();
            HiscoreEndpoint other$endpoint = other.getEndpoint();
            return !(this$endpoint == null ? other$endpoint != null : !((Object)((Object)this$endpoint)).equals((Object)other$endpoint));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            HiscoreEndpoint $endpoint = this.getEndpoint();
            result = result * 59 + ($endpoint == null ? 43 : ((Object)((Object)$endpoint)).hashCode());
            return result;
        }

        public String toString() {
            return "ChatCommandsPlugin.HiscoreLookup(name=" + this.getName() + ", endpoint=" + this.getEndpoint() + ")";
        }
    }
}

