/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.chatboxperformance;

import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.events.WidgetPositioned;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;

@PluginDescriptor(name="Chatbox performance", hidden=true)
public class ChatboxPerformancePlugin
extends Plugin {
    @Inject
    private Client client;

    @Subscribe
    public void onWidgetPositioned(WidgetPositioned event) {
        if (!this.areWidgetsFixed()) {
            this.fixChatbox();
        }
    }

    private boolean areWidgetsFixed() {
        Widget widget = this.client.getWidget(WidgetInfo.CHATBOX_TRANSPARENT_BACKGROUND);
        if (widget == null) {
            return true;
        }
        Widget[] widgets = widget.getChildren();
        if (widgets != null && widgets.length > 0) {
            Widget last = widgets[widgets.length - 1];
            return last != null && last.getOpacity() < 254;
        }
        return false;
    }

    private void fixChatbox() {
        this.fixDarkBackground();
        this.fixWhiteLines(true);
        this.fixWhiteLines(false);
    }

    private void fixDarkBackground() {
        int currOpacity = 256;
        int prevY = 0;
        Widget[] children = this.client.getWidget(WidgetInfo.CHATBOX_TRANSPARENT_BACKGROUND).getDynamicChildren();
        Widget prev = null;
        for (Widget w : children) {
            if (w.getType() != 3) continue;
            if (prev != null) {
                int relY = w.getRelativeY();
                prev.setHeightMode(0);
                prev.setYPositionMode(0);
                prev.setRelativeY(prevY);
                prev.setOriginalY(prev.getRelativeY());
                prev.setHeight(relY - prevY);
                prev.setOriginalHeight(prev.getHeight());
                prev.setOpacity(currOpacity);
            }
            prevY = w.getRelativeY();
            currOpacity -= 3;
            prev = w;
        }
        if (prev != null) {
            prev.setOpacity(currOpacity);
        }
    }

    private void fixWhiteLines(boolean upperLine) {
        int currOpacity = 256;
        int prevWidth = 0;
        Widget[] children = this.client.getWidget(WidgetInfo.CHATBOX_TRANSPARENT_LINES).getDynamicChildren();
        Widget prev = null;
        for (Widget w : children) {
            if (w.getType() != 3 || w.getRelativeY() == 0 && !upperLine || w.getRelativeY() != 0 && upperLine) continue;
            if (prev != null) {
                int width = w.getWidth();
                prev.setWidthMode(0);
                prev.setRelativeX(width);
                prev.setOriginalX(width);
                prev.setWidth(prevWidth - width);
                prev.setOriginalWidth(prev.getWidth());
                prev.setOpacity(currOpacity);
            }
            prevWidth = w.getWidth();
            currOpacity -= upperLine ? 3 : 4;
            prev = w;
        }
        if (prev != null) {
            prev.setOpacity(currOpacity);
        }
    }
}

