/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.cerberus;

import com.google.common.collect.ComparisonChain;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.GameState;
import net.runelite.api.NPC;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.NpcDespawned;
import net.runelite.api.events.NpcSpawned;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.cerberus.CerberusGhost;
import net.runelite.client.plugins.cerberus.CerberusOverlay;
import net.runelite.client.ui.overlay.OverlayManager;

@PluginDescriptor(name="Cerberus", description="Show what to pray against the summoned souls", tags={"bosses", "combat", "ghosts", "prayer", "pve", "overlay", "souls"})
@Singleton
public class CerberusPlugin
extends Plugin {
    private final List<NPC> ghosts = new ArrayList<NPC>();
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private CerberusOverlay overlay;

    @Override
    protected void startUp() throws Exception {
        this.overlayManager.add(this.overlay);
    }

    @Override
    protected void shutDown() throws Exception {
        this.overlayManager.remove(this.overlay);
        this.ghosts.clear();
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        GameState gameState = event.getGameState();
        if (gameState == GameState.LOGIN_SCREEN || gameState == GameState.HOPPING || gameState == GameState.CONNECTION_LOST) {
            this.ghosts.clear();
        }
    }

    @Subscribe
    public void onNpcSpawned(NpcSpawned event) {
        NPC npc = event.getNpc();
        CerberusGhost.fromNPC(npc).ifPresent(ghost -> this.ghosts.add(npc));
    }

    @Subscribe
    public void onNpcDespawned(NpcDespawned event) {
        this.ghosts.remove(event.getNpc());
    }

    @Subscribe
    public void onGameTick(GameTick gameTick) {
        if (this.ghosts.isEmpty()) {
            return;
        }
        this.ghosts.sort((a, b) -> ComparisonChain.start().compare(a.getLocalLocation().getY(), b.getLocalLocation().getY()).compare(a.getLocalLocation().getX(), b.getLocalLocation().getX()).result());
    }

    public List<NPC> getGhosts() {
        return this.ghosts;
    }
}

