/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.cerberus;

import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.client.game.SkillIconManager;
import net.runelite.client.plugins.cerberus.CerberusGhost;
import net.runelite.client.plugins.cerberus.CerberusPlugin;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.ImageComponent;
import net.runelite.client.ui.overlay.components.PanelComponent;

@Singleton
public class CerberusOverlay
extends Overlay {
    private final CerberusPlugin plugin;
    private final SkillIconManager iconManager;
    private final PanelComponent panelComponent = new PanelComponent();

    @Inject
    CerberusOverlay(CerberusPlugin plugin, SkillIconManager iconManager) {
        this.plugin = plugin;
        this.iconManager = iconManager;
        this.setPosition(OverlayPosition.BOTTOM_RIGHT);
        this.panelComponent.setOrientation(PanelComponent.Orientation.HORIZONTAL);
    }

    @Override
    public Dimension render(Graphics2D graphics) {
        if (this.plugin.getGhosts().isEmpty()) {
            return null;
        }
        this.panelComponent.getChildren().clear();
        this.plugin.getGhosts().stream().limit(CerberusGhost.values().length).forEach(npc -> CerberusGhost.fromNPC(npc).ifPresent(ghost -> this.panelComponent.getChildren().add(new ImageComponent(this.iconManager.getSkillImage(ghost.getType())))));
        return this.panelComponent.render(graphics);
    }
}

