/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.cannon;

import com.google.inject.Provides;
import java.awt.Color;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameObject;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.Player;
import net.runelite.api.Projectile;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.ConfigChanged;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.api.events.ProjectileMoved;
import net.runelite.client.Notifier;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.cannon.CannonConfig;
import net.runelite.client.plugins.cannon.CannonCounter;
import net.runelite.client.plugins.cannon.CannonOverlay;
import net.runelite.client.plugins.cannon.CannonSpotOverlay;
import net.runelite.client.plugins.cannon.CannonSpots;
import net.runelite.client.task.Schedule;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.ui.overlay.infobox.InfoBoxManager;

@PluginDescriptor(name="Cannon", description="Show information about cannon placement and/or amount of cannonballs", tags={"combat", "notifications", "ranged", "overlay"})
public class CannonPlugin
extends Plugin {
    private static final Pattern NUMBER_PATTERN = Pattern.compile("([0-9]+)");
    private static final int MAX_CBALLS = 30;
    private CannonCounter counter;
    private boolean skipProjectileCheckThisTick;
    private int cballsLeft;
    private boolean cannonPlaced;
    private WorldPoint cannonPosition;
    private GameObject cannon;
    private List<WorldPoint> spotPoints = new ArrayList<WorldPoint>();
    @Inject
    private ItemManager itemManager;
    @Inject
    private InfoBoxManager infoBoxManager;
    @Inject
    private Notifier notifier;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private CannonOverlay cannonOverlay;
    @Inject
    private CannonSpotOverlay cannonSpotOverlay;
    @Inject
    private CannonConfig config;
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;

    @Provides
    CannonConfig provideConfig(ConfigManager configManager) {
        return configManager.getConfig(CannonConfig.class);
    }

    @Override
    protected void startUp() throws Exception {
        this.overlayManager.add(this.cannonOverlay);
        this.overlayManager.add(this.cannonSpotOverlay);
    }

    @Override
    protected void shutDown() throws Exception {
        this.cannonSpotOverlay.setHidden(true);
        this.overlayManager.remove(this.cannonOverlay);
        this.overlayManager.remove(this.cannonSpotOverlay);
        this.cannonPlaced = false;
        this.cannonPosition = null;
        this.cballsLeft = 0;
        this.removeCounter();
        this.skipProjectileCheckThisTick = false;
        this.spotPoints.clear();
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged event) {
        if (event.getItemContainer() != this.client.getItemContainer(InventoryID.INVENTORY)) {
            return;
        }
        boolean hasBase = false;
        boolean hasStand = false;
        boolean hasBarrels = false;
        boolean hasFurnace = false;
        boolean hasAll = false;
        if (!this.cannonPlaced) {
            for (Item item : event.getItemContainer().getItems()) {
                if (item == null) continue;
                switch (item.getId()) {
                    case 6: {
                        hasBase = true;
                        break;
                    }
                    case 8: {
                        hasStand = true;
                        break;
                    }
                    case 10: {
                        hasBarrels = true;
                        break;
                    }
                    case 12: {
                        hasFurnace = true;
                    }
                }
                if (!hasBase || !hasStand || !hasBarrels || !hasFurnace) continue;
                hasAll = true;
                break;
            }
        }
        this.cannonSpotOverlay.setHidden(!hasAll);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals("cannon")) {
            if (!this.config.showInfobox()) {
                this.removeCounter();
            } else if (this.cannonPlaced) {
                this.clientThread.invoke(this::addCounter);
            }
        }
    }

    @Schedule(period=1L, unit=ChronoUnit.SECONDS)
    public void checkSpots() {
        if (!this.config.showCannonSpots()) {
            return;
        }
        this.spotPoints.clear();
        for (WorldPoint spot : CannonSpots.getCannonSpots()) {
            if (spot.getPlane() != this.client.getPlane() || !spot.isInScene(this.client)) continue;
            this.spotPoints.add(spot);
        }
    }

    @Subscribe
    public void onGameObjectSpawned(GameObjectSpawned event) {
        GameObject gameObject = event.getGameObject();
        Player localPlayer = this.client.getLocalPlayer();
        if (gameObject.getId() == 7 && !this.cannonPlaced && localPlayer.getWorldLocation().distanceTo(gameObject.getWorldLocation()) <= 2 && localPlayer.getAnimation() == 827) {
            this.cannonPosition = gameObject.getWorldLocation();
            this.cannon = gameObject;
        }
    }

    @Subscribe
    public void onProjectileMoved(ProjectileMoved event) {
        WorldPoint projectileLoc;
        Projectile projectile = event.getProjectile();
        if ((projectile.getId() == 53 || projectile.getId() == 1443) && this.cannonPosition != null && (projectileLoc = WorldPoint.fromLocal(this.client, projectile.getX1(), projectile.getY1(), this.client.getPlane())).equals(this.cannonPosition) && projectile.getX() == 0.0 && projectile.getY() == 0.0 && !this.skipProjectileCheckThisTick) {
            --this.cballsLeft;
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        if (event.getType() != ChatMessageType.SPAM && event.getType() != ChatMessageType.GAMEMESSAGE) {
            return;
        }
        if (event.getMessage().equals("You add the furnace.")) {
            this.cannonPlaced = true;
            this.addCounter();
            this.cballsLeft = 0;
        }
        if (event.getMessage().contains("You pick up the cannon")) {
            this.cannonPlaced = false;
            this.cballsLeft = 0;
            this.removeCounter();
        }
        if (event.getMessage().startsWith("You load the cannon with")) {
            Matcher m = NUMBER_PATTERN.matcher(event.getMessage());
            if (m.find()) {
                int amt = Integer.valueOf(m.group());
                if (this.cballsLeft + amt >= 30) {
                    this.skipProjectileCheckThisTick = true;
                    this.cballsLeft = 30;
                } else {
                    this.cballsLeft += amt;
                }
            } else if (event.getMessage().equals("You load the cannon with one cannonball.")) {
                if (this.cballsLeft + 1 >= 30) {
                    this.skipProjectileCheckThisTick = true;
                    this.cballsLeft = 30;
                } else {
                    ++this.cballsLeft;
                }
            }
        }
        if (event.getMessage().contains("Your cannon is out of ammo!")) {
            this.skipProjectileCheckThisTick = true;
            this.cballsLeft = 0;
            if (this.config.showEmptyCannonNotification()) {
                this.notifier.notify("Your cannon is out of ammo!");
            }
        }
        if (event.getMessage().startsWith("You unload your cannon and receive Cannonball") || event.getMessage().startsWith("You unload your cannon and receive Granite cannonball")) {
            this.skipProjectileCheckThisTick = true;
            this.cballsLeft = 0;
        }
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        this.skipProjectileCheckThisTick = false;
    }

    Color getStateColor() {
        if (this.cballsLeft > 15) {
            return Color.green;
        }
        if (this.cballsLeft > 5) {
            return Color.orange;
        }
        return Color.red;
    }

    private void addCounter() {
        if (!this.config.showInfobox() || this.counter != null) {
            return;
        }
        this.counter = new CannonCounter(this.itemManager.getImage(2), this);
        this.counter.setTooltip("Cannonballs");
        this.infoBoxManager.addInfoBox(this.counter);
    }

    private void removeCounter() {
        if (this.counter == null) {
            return;
        }
        this.infoBoxManager.removeInfoBox(this.counter);
        this.counter = null;
    }

    public int getCballsLeft() {
        return this.cballsLeft;
    }

    public boolean isCannonPlaced() {
        return this.cannonPlaced;
    }

    public WorldPoint getCannonPosition() {
        return this.cannonPosition;
    }

    public GameObject getCannon() {
        return this.cannon;
    }

    public List<WorldPoint> getSpotPoints() {
        return this.spotPoints;
    }
}

