/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.boosts;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.api.Skill;
import net.runelite.client.plugins.boosts.BoostsConfig;
import net.runelite.client.plugins.boosts.BoostsPlugin;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayMenuEntry;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.PanelComponent;
import net.runelite.client.util.ColorUtil;

class BoostsOverlay
extends Overlay {
    private final Client client;
    private final BoostsConfig config;
    private final PanelComponent panelComponent = new PanelComponent();
    private final BoostsPlugin plugin;

    @Inject
    private BoostsOverlay(Client client2, BoostsConfig config, BoostsPlugin plugin) {
        super(plugin);
        this.plugin = plugin;
        this.client = client2;
        this.config = config;
        this.setPosition(OverlayPosition.TOP_LEFT);
        this.setPriority(OverlayPriority.MED);
        this.getMenuEntries().add(new OverlayMenuEntry(MenuAction.RUNELITE_OVERLAY_CONFIG, "Configure", "Boosts overlay"));
    }

    @Override
    public Dimension render(Graphics2D graphics) {
        if (this.config.displayInfoboxes()) {
            return null;
        }
        this.panelComponent.getChildren().clear();
        int nextChange = this.plugin.getChangeDownTicks();
        if (nextChange != -1) {
            this.panelComponent.getChildren().add(LineComponent.builder().left("Next + restore in").right(String.valueOf(this.plugin.getChangeTime(nextChange))).build());
        }
        if ((nextChange = this.plugin.getChangeUpTicks()) != -1) {
            this.panelComponent.getChildren().add(LineComponent.builder().left("Next - restore in").right(String.valueOf(this.plugin.getChangeTime(nextChange))).build());
        }
        if (this.plugin.canShowBoosts()) {
            for (Skill skill : this.plugin.getShownSkills()) {
                Object str;
                int base;
                int boosted = this.client.getBoostedSkillLevel(skill);
                if (boosted == (base = this.client.getRealSkillLevel(skill))) continue;
                int boost = boosted - base;
                Color strColor = this.getTextColor(boost);
                if (this.config.useRelativeBoost()) {
                    str = String.valueOf(boost);
                    if (boost > 0) {
                        str = "+" + (String)str;
                    }
                } else {
                    str = ColorUtil.prependColorTag(Integer.toString(boosted), strColor) + ColorUtil.prependColorTag("/" + base, Color.WHITE);
                }
                this.panelComponent.getChildren().add(LineComponent.builder().left(skill.getName()).right((String)str).rightColor(strColor).build());
            }
        }
        return this.panelComponent.render(graphics);
    }

    private Color getTextColor(int boost) {
        if (boost < 0) {
            return new Color(238, 51, 51);
        }
        return boost <= this.config.boostThreshold() ? Color.YELLOW : Color.GREEN;
    }
}

