/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.blastmine;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.api.Varbits;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.blastmine.BlastMinePlugin;
import net.runelite.client.plugins.blastmine.BlastMinePluginConfig;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayMenuEntry;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.ImageComponent;
import net.runelite.client.ui.overlay.components.PanelComponent;

class BlastMineOreCountOverlay
extends Overlay {
    private final Client client;
    private final BlastMinePluginConfig config;
    private final ItemManager itemManager;
    private final PanelComponent panelComponent = new PanelComponent();

    @Inject
    private BlastMineOreCountOverlay(BlastMinePlugin plugin, Client client2, BlastMinePluginConfig config, ItemManager itemManager) {
        super(plugin);
        this.setPosition(OverlayPosition.TOP_LEFT);
        this.client = client2;
        this.config = config;
        this.itemManager = itemManager;
        this.panelComponent.setOrientation(PanelComponent.Orientation.HORIZONTAL);
        this.getMenuEntries().add(new OverlayMenuEntry(MenuAction.RUNELITE_OVERLAY_CONFIG, "Configure", "Blast mine overlay"));
    }

    @Override
    public Dimension render(Graphics2D graphics) {
        Widget blastMineWidget = this.client.getWidget(WidgetInfo.BLAST_MINE);
        if (blastMineWidget == null) {
            return null;
        }
        this.panelComponent.getChildren().clear();
        if (this.config.showOreOverlay()) {
            blastMineWidget.setHidden(true);
            this.panelComponent.getChildren().add(new ImageComponent(this.getImage(453, this.client.getVar(Varbits.BLAST_MINE_COAL))));
            this.panelComponent.getChildren().add(new ImageComponent(this.getImage(444, this.client.getVar(Varbits.BLAST_MINE_GOLD))));
            this.panelComponent.getChildren().add(new ImageComponent(this.getImage(447, this.client.getVar(Varbits.BLAST_MINE_MITHRIL))));
            this.panelComponent.getChildren().add(new ImageComponent(this.getImage(449, this.client.getVar(Varbits.BLAST_MINE_ADAMANTITE))));
            this.panelComponent.getChildren().add(new ImageComponent(this.getImage(451, this.client.getVar(Varbits.BLAST_MINE_RUNITE))));
        } else {
            blastMineWidget.setHidden(false);
        }
        return this.panelComponent.render(graphics);
    }

    private BufferedImage getImage(int itemID, int amount) {
        return this.itemManager.getImage(itemID, amount, true);
    }
}

