/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.blastfurnace;

import com.google.inject.Provides;
import javax.inject.Inject;
import net.runelite.api.GameObject;
import net.runelite.api.GameState;
import net.runelite.api.events.GameObjectDespawned;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.api.events.GameStateChanged;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.blastfurnace.BlastFurnaceClickBoxOverlay;
import net.runelite.client.plugins.blastfurnace.BlastFurnaceCofferOverlay;
import net.runelite.client.plugins.blastfurnace.BlastFurnaceConfig;
import net.runelite.client.plugins.blastfurnace.BlastFurnaceOverlay;
import net.runelite.client.ui.overlay.OverlayManager;

@PluginDescriptor(name="Blast Furnace", description="Show helpful information for the Blast Furnace minigame", tags={"minigame", "overlay", "skilling", "smithing"})
public class BlastFurnacePlugin
extends Plugin {
    private static final int BAR_DISPENSER = 9092;
    private GameObject conveyorBelt;
    private GameObject barDispenser;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private BlastFurnaceOverlay overlay;
    @Inject
    private BlastFurnaceCofferOverlay cofferOverlay;
    @Inject
    private BlastFurnaceClickBoxOverlay clickBoxOverlay;

    @Override
    protected void startUp() throws Exception {
        this.overlayManager.add(this.overlay);
        this.overlayManager.add(this.cofferOverlay);
        this.overlayManager.add(this.clickBoxOverlay);
    }

    @Override
    protected void shutDown() {
        this.overlayManager.remove(this.overlay);
        this.overlayManager.remove(this.cofferOverlay);
        this.overlayManager.remove(this.clickBoxOverlay);
        this.conveyorBelt = null;
        this.barDispenser = null;
    }

    @Provides
    BlastFurnaceConfig provideConfig(ConfigManager configManager) {
        return configManager.getConfig(BlastFurnaceConfig.class);
    }

    @Subscribe
    public void onGameObjectSpawned(GameObjectSpawned event) {
        GameObject gameObject = event.getGameObject();
        switch (gameObject.getId()) {
            case 9100: {
                this.conveyorBelt = gameObject;
                break;
            }
            case 9092: {
                this.barDispenser = gameObject;
            }
        }
    }

    @Subscribe
    public void onGameObjectDespawned(GameObjectDespawned event) {
        GameObject gameObject = event.getGameObject();
        switch (gameObject.getId()) {
            case 9100: {
                this.conveyorBelt = null;
                break;
            }
            case 9092: {
                this.barDispenser = null;
            }
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() == GameState.LOADING) {
            this.conveyorBelt = null;
            this.barDispenser = null;
        }
    }

    GameObject getConveyorBelt() {
        return this.conveyorBelt;
    }

    GameObject getBarDispenser() {
        return this.barDispenser;
    }
}

