/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.blastfurnace;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.client.game.AsyncBufferedImage;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.blastfurnace.BarsOres;
import net.runelite.client.plugins.blastfurnace.BlastFurnacePlugin;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayMenuEntry;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.ImageComponent;
import net.runelite.client.ui.overlay.components.PanelComponent;

class BlastFurnaceOverlay
extends Overlay {
    private final Client client;
    private final BlastFurnacePlugin plugin;
    private final PanelComponent imagePanelComponent = new PanelComponent();
    @Inject
    private ItemManager itemManager;

    @Inject
    BlastFurnaceOverlay(Client client2, BlastFurnacePlugin plugin) {
        super(plugin);
        this.plugin = plugin;
        this.client = client2;
        this.setPosition(OverlayPosition.TOP_LEFT);
        this.imagePanelComponent.setOrientation(PanelComponent.Orientation.HORIZONTAL);
        this.getMenuEntries().add(new OverlayMenuEntry(MenuAction.RUNELITE_OVERLAY_CONFIG, "Configure", "Blast furnace overlay"));
    }

    @Override
    public Dimension render(Graphics2D graphics) {
        if (this.plugin.getConveyorBelt() == null) {
            return null;
        }
        this.imagePanelComponent.getChildren().clear();
        for (BarsOres varbit : BarsOres.values()) {
            int amount = this.client.getVar(varbit.getVarbit());
            if (amount == 0) continue;
            this.imagePanelComponent.getChildren().add(new ImageComponent(this.getImage(varbit.getItemID(), amount)));
        }
        return this.imagePanelComponent.render(graphics);
    }

    private BufferedImage getImage(int itemID, int amount) {
        AsyncBufferedImage image = this.itemManager.getImage(itemID, amount, true);
        return image;
    }
}

