/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.blastfurnace;

import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.api.Varbits;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.plugins.blastfurnace.BlastFurnacePlugin;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayMenuEntry;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.PanelComponent;
import net.runelite.client.util.StackFormatter;

class BlastFurnaceCofferOverlay
extends Overlay {
    private final Client client;
    private final BlastFurnacePlugin plugin;
    private final PanelComponent panelComponent = new PanelComponent();

    @Inject
    private BlastFurnaceCofferOverlay(Client client2, BlastFurnacePlugin plugin) {
        super(plugin);
        this.setPosition(OverlayPosition.TOP_LEFT);
        this.client = client2;
        this.plugin = plugin;
        this.getMenuEntries().add(new OverlayMenuEntry(MenuAction.RUNELITE_OVERLAY_CONFIG, "Configure", "Coffer overlay"));
    }

    @Override
    public Dimension render(Graphics2D graphics) {
        if (this.plugin.getConveyorBelt() == null) {
            return null;
        }
        Widget sack = this.client.getWidget(WidgetInfo.BLAST_FURNACE_COFFER);
        this.panelComponent.getChildren().clear();
        if (sack != null) {
            sack.setHidden(true);
            this.panelComponent.getChildren().add(LineComponent.builder().left("Coffer:").right(StackFormatter.quantityToStackSize(this.client.getVar(Varbits.BLAST_FURNACE_COFFER)) + " gp").build());
        }
        return this.panelComponent.render(graphics);
    }
}

