/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.blastfurnace;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Area;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.EquipmentInventorySlot;
import net.runelite.api.GameObject;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.api.Point;
import net.runelite.api.Varbits;
import net.runelite.api.coords.LocalPoint;
import net.runelite.client.plugins.blastfurnace.BlastFurnaceConfig;
import net.runelite.client.plugins.blastfurnace.BlastFurnacePlugin;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayPosition;

class BlastFurnaceClickBoxOverlay
extends Overlay {
    private static final int MAX_DISTANCE = 2350;
    private final Client client;
    private final BlastFurnacePlugin plugin;
    private final BlastFurnaceConfig config;

    @Inject
    private BlastFurnaceClickBoxOverlay(Client client2, BlastFurnacePlugin plugin, BlastFurnaceConfig config) {
        this.setPosition(OverlayPosition.DYNAMIC);
        this.client = client2;
        this.plugin = plugin;
        this.config = config;
    }

    @Override
    public Dimension render(Graphics2D graphics) {
        int dispenserState = this.client.getVar(Varbits.BAR_DISPENSER);
        if (this.config.showConveyorBelt() && this.plugin.getConveyorBelt() != null) {
            Color color = dispenserState == 1 ? Color.RED : Color.GREEN;
            this.renderObject(this.plugin.getConveyorBelt(), graphics, color);
        }
        if (this.config.showBarDispenser() && this.plugin.getBarDispenser() != null) {
            boolean hasIceGloves = this.hasIceGloves();
            Color color = dispenserState == 2 && hasIceGloves ? Color.GREEN : (dispenserState == 3 ? Color.GREEN : Color.RED);
            this.renderObject(this.plugin.getBarDispenser(), graphics, color);
        }
        return null;
    }

    private boolean hasIceGloves() {
        ItemContainer equipmentContainer = this.client.getItemContainer(InventoryID.EQUIPMENT);
        if (equipmentContainer == null) {
            return false;
        }
        Item[] items = equipmentContainer.getItems();
        int idx = EquipmentInventorySlot.GLOVES.getSlotIdx();
        if (items == null || idx >= items.length) {
            return false;
        }
        Item glove = items[idx];
        return glove != null && glove.getId() == 1580;
    }

    private void renderObject(GameObject object, Graphics2D graphics, Color color) {
        Area objectClickbox;
        LocalPoint localLocation = this.client.getLocalPlayer().getLocalLocation();
        Point mousePosition = this.client.getMouseCanvasPosition();
        LocalPoint location = object.getLocalLocation();
        if (localLocation.distanceTo(location) <= 2350 && (objectClickbox = object.getClickbox()) != null) {
            if (objectClickbox.contains(mousePosition.getX(), mousePosition.getY())) {
                graphics.setColor(color.darker());
            } else {
                graphics.setColor(color);
            }
            graphics.draw(objectClickbox);
            graphics.setColor(new Color(255, 0, 0, 20));
            graphics.fill(objectClickbox);
        }
    }
}

