/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.barrows;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.inject.Provides;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameObject;
import net.runelite.api.GameState;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.api.WallObject;
import net.runelite.api.events.GameObjectChanged;
import net.runelite.api.events.GameObjectDespawned;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.WallObjectChanged;
import net.runelite.api.events.WallObjectDespawned;
import net.runelite.api.events.WallObjectSpawned;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.barrows.BarrowsBrotherSlainOverlay;
import net.runelite.client.plugins.barrows.BarrowsConfig;
import net.runelite.client.plugins.barrows.BarrowsOverlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.StackFormatter;

@PluginDescriptor(name="Barrows Brothers", description="Show helpful information for the Barrows minigame", tags={"combat", "minigame", "minimap", "bosses", "pve", "pvm"})
public class BarrowsPlugin
extends Plugin {
    private static final Set<Integer> BARROWS_WALLS = Sets.newHashSet(20678, 20681, 20682, 20683, 20684, 20685, 20686, 20687, 20688, 20689, 20690, 20691, 20692, 20693, 20694, 20695, 20696, 20697, 20700, 20701, 20702, 20703, 20704, 20705, 20706, 20707, 20708, 20709, 20710, 20711, 20712, 20713, 20714, 20715, 20728, 20730);
    private static final Set<Integer> BARROWS_LADDERS = Sets.newHashSet(20675, 20676, 20677);
    private static final ImmutableList<WidgetInfo> POSSIBLE_SOLUTIONS = ImmutableList.of(WidgetInfo.BARROWS_PUZZLE_ANSWER1, WidgetInfo.BARROWS_PUZZLE_ANSWER2, WidgetInfo.BARROWS_PUZZLE_ANSWER3);
    private final Set<WallObject> walls = new HashSet<WallObject>();
    private final Set<GameObject> ladders = new HashSet<GameObject>();
    private Widget puzzleAnswer;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private BarrowsOverlay barrowsOverlay;
    @Inject
    private BarrowsBrotherSlainOverlay brotherOverlay;
    @Inject
    private Client client;
    @Inject
    private ItemManager itemManager;
    @Inject
    private ChatMessageManager chatMessageManager;
    @Inject
    private BarrowsConfig config;

    @Provides
    BarrowsConfig provideConfig(ConfigManager configManager) {
        return configManager.getConfig(BarrowsConfig.class);
    }

    @Override
    protected void startUp() throws Exception {
        this.overlayManager.add(this.barrowsOverlay);
        this.overlayManager.add(this.brotherOverlay);
    }

    @Override
    protected void shutDown() {
        Widget barrowsBrothers;
        this.overlayManager.remove(this.barrowsOverlay);
        this.overlayManager.remove(this.brotherOverlay);
        this.walls.clear();
        this.ladders.clear();
        this.puzzleAnswer = null;
        Widget potential = this.client.getWidget(WidgetInfo.BARROWS_POTENTIAL);
        if (potential != null) {
            potential.setHidden(false);
        }
        if ((barrowsBrothers = this.client.getWidget(WidgetInfo.BARROWS_BROTHERS)) != null) {
            barrowsBrothers.setHidden(false);
        }
    }

    @Subscribe
    public void onWallObjectSpawned(WallObjectSpawned event) {
        WallObject wallObject = event.getWallObject();
        if (BARROWS_WALLS.contains(wallObject.getId())) {
            this.walls.add(wallObject);
        }
    }

    @Subscribe
    public void onWallObjectChanged(WallObjectChanged event) {
        WallObject previous = event.getPrevious();
        WallObject wallObject = event.getWallObject();
        this.walls.remove(previous);
        if (BARROWS_WALLS.contains(wallObject.getId())) {
            this.walls.add(wallObject);
        }
    }

    @Subscribe
    public void onWallObjectDespawned(WallObjectDespawned event) {
        WallObject wallObject = event.getWallObject();
        this.walls.remove(wallObject);
    }

    @Subscribe
    public void onGameObjectSpawned(GameObjectSpawned event) {
        GameObject gameObject = event.getGameObject();
        if (BARROWS_LADDERS.contains(gameObject.getId())) {
            this.ladders.add(gameObject);
        }
    }

    @Subscribe
    public void onGameObjectChanged(GameObjectChanged event) {
        GameObject previous = event.getPrevious();
        GameObject gameObject = event.getGameObject();
        this.ladders.remove(previous);
        if (BARROWS_LADDERS.contains(gameObject.getId())) {
            this.ladders.add(gameObject);
        }
    }

    @Subscribe
    public void onGameObjectDespawned(GameObjectDespawned event) {
        GameObject gameObject = event.getGameObject();
        this.ladders.remove(gameObject);
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() == GameState.LOADING) {
            this.walls.clear();
            this.ladders.clear();
            this.puzzleAnswer = null;
        }
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded event) {
        if (event.getGroupId() == 155 && this.config.showChestValue()) {
            ItemContainer barrowsRewardContainer = this.client.getItemContainer(InventoryID.BARROWS_REWARD);
            Item[] items = barrowsRewardContainer.getItems();
            long chestPrice = 0L;
            for (Item item : items) {
                long itemStack = (long)this.itemManager.getItemPrice(item.getId()) * (long)item.getQuantity();
                chestPrice += itemStack;
            }
            ChatMessageBuilder message = new ChatMessageBuilder().append(ChatColorType.HIGHLIGHT).append("Your chest is worth around ").append(StackFormatter.formatNumber(chestPrice)).append(" coins.").append(ChatColorType.NORMAL);
            this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.ITEM_EXAMINE).runeLiteFormattedMessage(message.build()).build());
        } else if (event.getGroupId() == 25) {
            int answer = this.client.getWidget(WidgetInfo.BARROWS_FIRST_PUZZLE).getModelId() - 3;
            this.puzzleAnswer = null;
            for (WidgetInfo puzzleNode : POSSIBLE_SOLUTIONS) {
                Widget widgetToCheck = this.client.getWidget(puzzleNode);
                if (widgetToCheck == null || widgetToCheck.getModelId() != answer) continue;
                this.puzzleAnswer = this.client.getWidget(puzzleNode);
                break;
            }
        }
    }

    static Set<Integer> getBARROWS_WALLS() {
        return BARROWS_WALLS;
    }

    Set<WallObject> getWalls() {
        return this.walls;
    }

    Set<GameObject> getLadders() {
        return this.ladders;
    }

    public Widget getPuzzleAnswer() {
        return this.puzzleAnswer;
    }
}

