/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.barrows;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.List;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameObject;
import net.runelite.api.NPC;
import net.runelite.api.NPCComposition;
import net.runelite.api.ObjectComposition;
import net.runelite.api.Perspective;
import net.runelite.api.Player;
import net.runelite.api.Point;
import net.runelite.api.WallObject;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.widgets.Widget;
import net.runelite.client.plugins.barrows.BarrowsBrothers;
import net.runelite.client.plugins.barrows.BarrowsConfig;
import net.runelite.client.plugins.barrows.BarrowsPlugin;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;

class BarrowsOverlay
extends Overlay {
    private static final int MAX_DISTANCE = 2350;
    private final Client client;
    private final BarrowsPlugin plugin;
    private final BarrowsConfig config;

    @Inject
    private BarrowsOverlay(Client client2, BarrowsPlugin plugin, BarrowsConfig config) {
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_WIDGETS);
        this.client = client2;
        this.plugin = plugin;
        this.config = config;
    }

    @Override
    public Dimension render(Graphics2D graphics) {
        Player local = this.client.getLocalPlayer();
        Color npcColor = this.getMinimapDotColor(1);
        Color playerColor = this.getMinimapDotColor(2);
        Widget puzzleAnswer = this.plugin.getPuzzleAnswer();
        if (!this.plugin.getWalls().isEmpty() && this.client.getPlane() == 0 && this.config.showMinimap()) {
            Point minimapLocation;
            graphics.setColor(npcColor);
            List<NPC> npcs = this.client.getNpcs();
            for (NPC npc : npcs) {
                NPCComposition composition = npc.getComposition();
                if (composition != null && !composition.isMinimapVisible() || (minimapLocation = npc.getMinimapLocation()) == null) continue;
                graphics.fillOval(minimapLocation.getX(), minimapLocation.getY(), 4, 4);
            }
            graphics.setColor(playerColor);
            List<Player> players = this.client.getPlayers();
            for (Player player : players) {
                if (player == local || (minimapLocation = player.getMinimapLocation()) == null) continue;
                graphics.fillOval(minimapLocation.getX(), minimapLocation.getY(), 4, 4);
            }
            this.renderObjects(graphics, local);
            graphics.setColor(playerColor);
            graphics.fillRect(local.getMinimapLocation().getX(), local.getMinimapLocation().getY(), 3, 3);
        } else if (this.config.showBrotherLoc()) {
            this.renderBarrowsBrothers(graphics);
        }
        if (puzzleAnswer != null && this.config.showPuzzleAnswer() && !puzzleAnswer.isHidden()) {
            Rectangle answerRect = puzzleAnswer.getBounds();
            graphics.setColor(Color.GREEN);
            graphics.draw(answerRect);
        }
        return null;
    }

    private void renderObjects(Graphics2D graphics, Player localPlayer) {
        LocalPoint location;
        LocalPoint localLocation = localPlayer.getLocalLocation();
        for (WallObject wall : this.plugin.getWalls()) {
            location = wall.getLocalLocation();
            if (localLocation.distanceTo(location) > 2350) continue;
            this.renderWalls(graphics, wall);
        }
        for (GameObject ladder : this.plugin.getLadders()) {
            location = ladder.getLocalLocation();
            if (localLocation.distanceTo(location) > 2350) continue;
            this.renderLadders(graphics, ladder);
        }
    }

    private void renderWalls(Graphics2D graphics, WallObject wall) {
        ObjectComposition impostor;
        Point minimapLocation = wall.getMinimapLocation();
        if (minimapLocation == null) {
            return;
        }
        ObjectComposition objectComp = this.client.getObjectDefinition(wall.getId());
        ObjectComposition objectComposition = impostor = objectComp.getImpostorIds() != null ? objectComp.getImpostor() : null;
        if (impostor != null && impostor.getActions()[0] != null) {
            graphics.setColor(Color.green);
        } else {
            graphics.setColor(Color.gray);
        }
        graphics.fillRect(minimapLocation.getX(), minimapLocation.getY(), 3, 3);
    }

    private Color getMinimapDotColor(int typeIndex) {
        int pixel = this.client.getMapDots()[typeIndex].getPixels()[1];
        return new Color(pixel);
    }

    private void renderLadders(Graphics2D graphics, GameObject ladder) {
        Point minimapLocation = ladder.getMinimapLocation();
        if (minimapLocation == null) {
            return;
        }
        ObjectComposition objectComp = this.client.getObjectDefinition(ladder.getId());
        if (objectComp.getImpostorIds() != null && objectComp.getImpostor() != null) {
            graphics.setColor(Color.orange);
            graphics.fillRect(minimapLocation.getX(), minimapLocation.getY(), 6, 6);
        }
    }

    private void renderBarrowsBrothers(Graphics2D graphics) {
        for (BarrowsBrothers brother : BarrowsBrothers.values()) {
            String brotherLetter;
            Point minimapText;
            LocalPoint localLocation = LocalPoint.fromWorld(this.client, brother.getLocation());
            if (localLocation == null || (minimapText = Perspective.getCanvasTextMiniMapLocation(this.client, graphics, localLocation, brotherLetter = Character.toString(brother.getName().charAt(0)))) == null) continue;
            graphics.setColor(Color.black);
            graphics.drawString(brotherLetter, minimapText.getX() + 1, minimapText.getY() + 1);
            if (this.client.getVar(brother.getKilledVarbit()) > 0) {
                graphics.setColor(this.config.deadBrotherLocColor());
            } else {
                graphics.setColor(this.config.brotherLocColor());
            }
            graphics.drawString(brotherLetter, minimapText.getX(), minimapText.getY());
        }
    }
}

