/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.barrows;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.api.Varbits;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.plugins.barrows.BarrowsBrothers;
import net.runelite.client.plugins.barrows.BarrowsPlugin;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayMenuEntry;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.PanelComponent;

public class BarrowsBrotherSlainOverlay
extends Overlay {
    private final Client client;
    private final PanelComponent panelComponent = new PanelComponent();

    @Inject
    private BarrowsBrotherSlainOverlay(BarrowsPlugin plugin, Client client2) {
        super(plugin);
        this.setPosition(OverlayPosition.TOP_LEFT);
        this.setPriority(OverlayPriority.LOW);
        this.client = client2;
        this.getMenuEntries().add(new OverlayMenuEntry(MenuAction.RUNELITE_OVERLAY_CONFIG, "Configure", "Barrows overlay"));
    }

    @Override
    public Dimension render(Graphics2D graphics) {
        Widget potential = this.client.getWidget(WidgetInfo.BARROWS_POTENTIAL);
        if (potential == null || potential.isHidden()) {
            return null;
        }
        Widget barrowsBrothers = this.client.getWidget(WidgetInfo.BARROWS_BROTHERS);
        if (barrowsBrothers != null) {
            barrowsBrothers.setHidden(true);
            potential.setHidden(true);
        }
        this.panelComponent.getChildren().clear();
        for (BarrowsBrothers brother : BarrowsBrothers.values()) {
            boolean brotherSlain = this.client.getVar(brother.getKilledVarbit()) > 0;
            String slain = brotherSlain ? "\u2713" : "\u2717";
            this.panelComponent.getChildren().add(LineComponent.builder().left(brother.getName()).right(slain).rightColor(brotherSlain ? Color.GREEN : Color.RED).build());
        }
        float rewardPercent = (float)this.client.getVar(Varbits.BARROWS_REWARD_POTENTIAL) / 10.0f;
        this.panelComponent.getChildren().add(LineComponent.builder().left("Potential").right((String)(rewardPercent != 0.0f ? rewardPercent + "%" : "0%")).rightColor(rewardPercent >= 73.0f && rewardPercent <= 88.0f ? Color.GREEN : (rewardPercent < 65.6f ? Color.WHITE : Color.YELLOW)).build());
        return this.panelComponent.render(graphics);
    }
}

