/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.barbarianassault;

import com.google.inject.Provides;
import java.awt.Font;
import java.awt.Image;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.Varbits;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.VarbitChanged;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.kit.KitType;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.barbarianassault.BarbarianAssaultConfig;
import net.runelite.client.plugins.barbarianassault.BarbarianAssaultOverlay;
import net.runelite.client.plugins.barbarianassault.GameTimer;
import net.runelite.client.plugins.barbarianassault.Role;
import net.runelite.client.plugins.barbarianassault.Round;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.ImageUtil;

@PluginDescriptor(name="Barbarian Assault", description="Show a timer to the next call change and game/wave duration in chat.", tags={"minigame", "overlay", "timer"})
public class BarbarianAssaultPlugin
extends Plugin {
    private static final int BA_WAVE_NUM_INDEX = 2;
    private static final String START_WAVE = "1";
    private static final String ENDGAME_REWARD_NEEDLE_TEXT = "<br>5";
    private Font font;
    private Image clockImage;
    private int inGameBit = 0;
    private String currentWave = "1";
    private GameTimer gameTime;
    @Inject
    private Client client;
    @Inject
    private ChatMessageManager chatMessageManager;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private BarbarianAssaultConfig config;
    @Inject
    private BarbarianAssaultOverlay overlay;

    @Provides
    BarbarianAssaultConfig provideConfig(ConfigManager configManager) {
        return configManager.getConfig(BarbarianAssaultConfig.class);
    }

    @Override
    protected void startUp() throws Exception {
        this.overlayManager.add(this.overlay);
        this.font = FontManager.getRunescapeFont().deriveFont(1, 24.0f);
        this.clockImage = ImageUtil.getResourceStreamFromClass(this.getClass(), "clock.png");
    }

    @Override
    protected void shutDown() throws Exception {
        this.overlayManager.remove(this.overlay);
        this.gameTime = null;
        this.currentWave = START_WAVE;
        this.inGameBit = 0;
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded event) {
        if (event.getGroupId() == 497) {
            Widget rewardWidget = this.client.getWidget(WidgetInfo.BA_REWARD_TEXT);
            if (this.config.waveTimes() && rewardWidget != null && rewardWidget.getText().contains(ENDGAME_REWARD_NEEDLE_TEXT) && this.gameTime != null) {
                this.announceTime("Game finished, duration: ", this.gameTime.getTime(false));
            }
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        if (event.getType() == ChatMessageType.GAMEMESSAGE && event.getMessage().startsWith("---- Wave:")) {
            String[] message = event.getMessage().split(" ");
            this.currentWave = message[2];
            if (this.currentWave.equals(START_WAVE)) {
                this.gameTime = new GameTimer();
            } else if (this.gameTime != null) {
                this.gameTime.setWaveStartTime();
            }
        }
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        if (this.client.getVar(Varbits.IN_GAME_BA) == 0 || this.client.getLocalPlayer() == null || this.overlay.getCurrentRound() != null) {
            return;
        }
        switch (this.client.getLocalPlayer().getPlayerComposition().getEquipmentId(KitType.CAPE)) {
            case 10556: {
                this.overlay.setCurrentRound(new Round(Role.ATTACKER));
                break;
            }
            case 10557: {
                this.overlay.setCurrentRound(new Round(Role.COLLECTOR));
                break;
            }
            case 10558: {
                this.overlay.setCurrentRound(new Round(Role.DEFENDER));
                break;
            }
            case 10559: {
                this.overlay.setCurrentRound(new Round(Role.HEALER));
            }
        }
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged event) {
        int inGame = this.client.getVar(Varbits.IN_GAME_BA);
        if (this.inGameBit != inGame && this.inGameBit == 1) {
            this.overlay.setCurrentRound(null);
            if (this.config.waveTimes() && this.gameTime != null) {
                this.announceTime("Wave " + this.currentWave + " duration: ", this.gameTime.getTime(true));
            }
        }
        this.inGameBit = inGame;
    }

    private void announceTime(String preText, String time) {
        String chatMessage = new ChatMessageBuilder().append(ChatColorType.NORMAL).append(preText).append(ChatColorType.HIGHLIGHT).append(time).build();
        this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(chatMessage).build());
    }

    public Font getFont() {
        return this.font;
    }

    public Image getClockImage() {
        return this.clockImage;
    }
}

