/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.barbarianassault;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.MenuAction;
import net.runelite.api.widgets.Widget;
import net.runelite.client.plugins.barbarianassault.BarbarianAssaultConfig;
import net.runelite.client.plugins.barbarianassault.BarbarianAssaultPlugin;
import net.runelite.client.plugins.barbarianassault.Role;
import net.runelite.client.plugins.barbarianassault.Round;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayMenuEntry;
import net.runelite.client.ui.overlay.OverlayPosition;

class BarbarianAssaultOverlay
extends Overlay {
    private final Client client;
    private final BarbarianAssaultPlugin plugin;
    private final BarbarianAssaultConfig config;
    private Round currentRound;

    @Inject
    private BarbarianAssaultOverlay(Client client2, BarbarianAssaultPlugin plugin, BarbarianAssaultConfig config) {
        super(plugin);
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_WIDGETS);
        this.client = client2;
        this.plugin = plugin;
        this.config = config;
        this.getMenuEntries().add(new OverlayMenuEntry(MenuAction.RUNELITE_OVERLAY_CONFIG, "Configure", "B.A. overlay"));
    }

    @Override
    public Dimension render(Graphics2D graphics) {
        if (this.client.getGameState() != GameState.LOGGED_IN || this.currentRound == null) {
            return null;
        }
        Role role = this.currentRound.getRoundRole();
        if (role == null) {
            return null;
        }
        Widget roleText = this.client.getWidget(role.getRoleText());
        Widget roleSprite = this.client.getWidget(role.getRoleSprite());
        if (this.config.showTimer() && roleText != null && roleSprite != null) {
            roleText.setText(String.format("00:%02d", this.currentRound.getTimeToChange()));
            Rectangle spriteBounds = roleSprite.getBounds();
            roleSprite.setHidden(true);
            graphics.drawImage(this.plugin.getClockImage(), spriteBounds.x, spriteBounds.y, null);
        }
        return null;
    }

    public Round getCurrentRound() {
        return this.currentRound;
    }

    public void setCurrentRound(Round currentRound) {
        this.currentRound = currentRound;
    }
}

