/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.banktags.tabs;

import com.google.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.VarClientInt;
import net.runelite.api.VarClientStr;
import net.runelite.api.vars.InputType;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.callback.ClientThread;

public class BankSearch {
    private static final int INNER_CONTAINER_IDX = 2;
    private static final int SETTINGS_IDX = 4;
    private static final int ITEM_CONTAINER_IDX = 7;
    private static final int SCROLLBAR_IDX = 8;
    private static final int BOTTOM_BAR_IDX = 9;
    private static final int SEARCH_BUTTON_BACKGROUND_IDX = 15;
    private static final int TITLE_BAR_IDX = 16;
    private static final int ITEM_COUNT_IDX = 17;
    private static final int TAB_BAR_IDX = 18;
    private static final int INCINERATOR_IDX = 19;
    private static final int INCINERATOR_CONFIRM_IDX = 20;
    private static final int HIDDEN_WIDGET_IDX = 21;
    private final Client client;
    private final ClientThread clientThread;

    @Inject
    private BankSearch(Client client2, ClientThread clientThread) {
        this.client = client2;
        this.clientThread = clientThread;
    }

    public void search(InputType inputType, String search, Boolean closeInput) {
        this.clientThread.invoke(() -> {
            Widget bankContainer = this.client.getWidget(WidgetInfo.BANK_CONTAINER);
            if (bankContainer == null || bankContainer.isHidden()) {
                return;
            }
            Object[] widgetIds = bankContainer.getOnLoadListener();
            if (widgetIds == null || widgetIds.length < 21) {
                return;
            }
            if (closeInput.booleanValue()) {
                this.client.runScript(299, new Object[0]);
            }
            this.client.setVar(VarClientInt.INPUT_TYPE, inputType.getType());
            this.client.setVar(VarClientStr.INPUT_TEXT, search);
            this.client.runScript(277, WidgetInfo.BANK_CONTAINER.getId(), widgetIds[2], widgetIds[4], widgetIds[7], widgetIds[8], widgetIds[9], widgetIds[16], widgetIds[17], widgetIds[15], widgetIds[18], widgetIds[19], widgetIds[20], widgetIds[21]);
        });
    }

    public void reset(Boolean closeChat) {
        this.search(InputType.NONE, "", closeChat);
    }
}

