/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.banktags;

import com.google.inject.Provides;
import java.awt.event.KeyEvent;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemComposition;
import net.runelite.api.ItemContainer;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.VarClientInt;
import net.runelite.api.VarClientStr;
import net.runelite.api.events.ConfigChanged;
import net.runelite.api.events.DraggingWidgetChanged;
import net.runelite.api.events.FocusChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.MenuEntryAdded;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.events.ScriptCallbackEvent;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.vars.InputType;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.ItemManager;
import net.runelite.client.game.SpriteManager;
import net.runelite.client.game.chatbox.ChatboxPanelManager;
import net.runelite.client.input.KeyListener;
import net.runelite.client.input.KeyManager;
import net.runelite.client.input.MouseManager;
import net.runelite.client.input.MouseWheelListener;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDependency;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.banktags.BankTagsConfig;
import net.runelite.client.plugins.banktags.TagManager;
import net.runelite.client.plugins.banktags.tabs.BankSearch;
import net.runelite.client.plugins.banktags.tabs.TabInterface;
import net.runelite.client.plugins.banktags.tabs.TabSprites;
import net.runelite.client.plugins.cluescrolls.ClueScrollPlugin;
import net.runelite.client.util.Text;

@PluginDescriptor(name="Bank Tags", description="Enable tagging of bank items and searching of bank tags", tags={"searching", "tagging"})
@PluginDependency(value=ClueScrollPlugin.class)
public class BankTagsPlugin
extends Plugin
implements MouseWheelListener,
KeyListener {
    public static final String CONFIG_GROUP = "banktags";
    public static final String TAG_SEARCH = "tag:";
    private static final String EDIT_TAGS_MENU_OPTION = "Edit-tags";
    public static final String ICON_SEARCH = "icon_";
    public static final String VAR_TAG_SUFFIX = "*";
    private static final String SEARCH_BANK_INPUT_TEXT = "Show items whose names or tags contain the following text:<br>(To show only tagged items, start your search with 'tag:')";
    private static final String SEARCH_BANK_INPUT_TEXT_FOUND = "Show items whose names or tags contain the following text: (%d found)<br>(To show only tagged items, start your search with 'tag:')";
    @Inject
    private ItemManager itemManager;
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ChatboxPanelManager chatboxPanelManager;
    @Inject
    private MouseManager mouseManager;
    @Inject
    private BankTagsConfig config;
    @Inject
    private TagManager tagManager;
    @Inject
    private TabInterface tabInterface;
    @Inject
    private BankSearch bankSearch;
    @Inject
    private KeyManager keyManager;
    @Inject
    private SpriteManager spriteManager;
    private boolean shiftPressed = false;

    @Provides
    BankTagsConfig getConfig(ConfigManager configManager) {
        return configManager.getConfig(BankTagsConfig.class);
    }

    @Override
    public void startUp() {
        this.keyManager.registerKeyListener(this);
        this.mouseManager.registerMouseWheelListener(this);
        this.clientThread.invokeLater(this.tabInterface::init);
        this.spriteManager.addSpriteOverrides(TabSprites.values());
    }

    @Override
    public void shutDown() {
        this.keyManager.unregisterKeyListener(this);
        this.mouseManager.unregisterMouseWheelListener(this);
        this.clientThread.invokeLater(this.tabInterface::destroy);
        this.spriteManager.removeSpriteOverrides(TabSprites.values());
        this.shiftPressed = false;
    }

    @Subscribe
    public void onScriptCallbackEvent(ScriptCallbackEvent event) {
        String eventName = event.getEventName();
        int[] intStack = this.client.getIntStack();
        String[] stringStack = this.client.getStringStack();
        int intStackSize = this.client.getIntStackSize();
        int stringStackSize = this.client.getStringStackSize();
        switch (eventName) {
            case "bankTagsActive": {
                intStack[intStackSize - 1] = 1;
                break;
            }
            case "setSearchBankInputText": {
                stringStack[stringStackSize - 1] = SEARCH_BANK_INPUT_TEXT;
                break;
            }
            case "setSearchBankInputTextFound": {
                int matches = intStack[intStackSize - 1];
                stringStack[stringStackSize - 1] = String.format(SEARCH_BANK_INPUT_TEXT_FOUND, matches);
                break;
            }
            case "bankSearchFilter": {
                int itemId = intStack[intStackSize - 1];
                String itemName = stringStack[stringStackSize - 2];
                String search = stringStack[stringStackSize - 1];
                boolean tagSearch = search.startsWith(TAG_SEARCH);
                if (tagSearch) {
                    search = search.substring(TAG_SEARCH.length()).trim();
                }
                if (this.tagManager.findTag(itemId, search)) {
                    intStack[intStackSize - 2] = 1;
                    break;
                }
                if (tagSearch) break;
                intStack[intStackSize - 2] = itemName.contains(search) ? 1 : 0;
                break;
            }
            case "getSearchingTagTab": {
                intStack[intStackSize - 1] = this.tabInterface.isActive() ? 1 : 0;
            }
        }
    }

    @Subscribe
    public void onMenuEntryAdded(MenuEntryAdded event) {
        MenuEntry[] entries = this.client.getMenuEntries();
        if (event.getActionParam1() == WidgetInfo.BANK_ITEM_CONTAINER.getId() && event.getOption().equals("Examine")) {
            Widget container = this.client.getWidget(WidgetInfo.BANK_ITEM_CONTAINER);
            Widget item = container.getChild(event.getActionParam0());
            int itemID = item.getItemId();
            Object text = EDIT_TAGS_MENU_OPTION;
            int tagCount = this.tagManager.getTags(itemID, false).size() + this.tagManager.getTags(itemID, true).size();
            if (tagCount > 0) {
                text = (String)text + " (" + tagCount + ")";
            }
            MenuEntry editTags = new MenuEntry();
            editTags.setParam0(event.getActionParam0());
            editTags.setParam1(event.getActionParam1());
            editTags.setTarget(event.getTarget());
            editTags.setOption((String)text);
            editTags.setType(MenuAction.RUNELITE.getId());
            editTags.setIdentifier(event.getIdentifier());
            entries = Arrays.copyOf(entries, entries.length + 1);
            entries[entries.length - 1] = editTags;
            this.client.setMenuEntries(entries);
        }
        this.tabInterface.handleAdd(event);
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked event) {
        if (event.getWidgetId() == WidgetInfo.BANK_ITEM_CONTAINER.getId() && event.getMenuAction() == MenuAction.RUNELITE && event.getMenuOption().startsWith(EDIT_TAGS_MENU_OPTION)) {
            event.consume();
            int inventoryIndex = event.getActionParam();
            ItemContainer bankContainer = this.client.getItemContainer(InventoryID.BANK);
            if (bankContainer == null) {
                return;
            }
            Item[] items = bankContainer.getItems();
            if (inventoryIndex < 0 || inventoryIndex >= items.length) {
                return;
            }
            Item item = bankContainer.getItems()[inventoryIndex];
            if (item == null) {
                return;
            }
            int itemId = item.getId();
            ItemComposition itemComposition = this.itemManager.getItemComposition(itemId);
            String name = itemComposition.getName();
            Collection<String> tags = this.tagManager.getTags(itemId, false);
            this.tagManager.getTags(itemId, true).stream().map(i -> i + VAR_TAG_SUFFIX).forEach(tags::add);
            boolean isSearchOpen = this.client.getVar(VarClientInt.INPUT_TYPE) == InputType.SEARCH.getType();
            String searchText = this.client.getVar(VarClientStr.INPUT_TEXT);
            String initialValue = Text.toCSV(tags);
            this.chatboxPanelManager.openTextInput(name + " tags:<br>(append * for variation tag)").value(initialValue).onDone(newValue -> this.clientThread.invoke(() -> {
                ArrayList<String> newTags = new ArrayList<String>(Text.fromCSV(newValue.toLowerCase()));
                Collection newVarTags = new ArrayList<String>(newTags).stream().filter(s -> s.endsWith(VAR_TAG_SUFFIX)).map(s -> {
                    newTags.remove(s);
                    return s.substring(0, s.length() - VAR_TAG_SUFFIX.length());
                }).collect(Collectors.toList());
                this.tagManager.setTagString(itemId, Text.toCSV(newTags), false);
                this.tagManager.setTagString(itemId, Text.toCSV(newVarTags), true);
                this.tabInterface.updateTabIfActive(Text.fromCSV(initialValue.toLowerCase().replaceAll(Pattern.quote(VAR_TAG_SUFFIX), "")));
                this.tabInterface.updateTabIfActive(Text.fromCSV(newValue.toLowerCase().replaceAll(Pattern.quote(VAR_TAG_SUFFIX), "")));
            })).build();
            if (isSearchOpen) {
                this.bankSearch.reset(false);
                this.bankSearch.search(InputType.SEARCH, searchText, false);
            }
        } else {
            this.tabInterface.handleClick(event);
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged configChanged) {
        if (configChanged.getGroup().equals(CONFIG_GROUP) && configChanged.getKey().equals("useTabs")) {
            if (this.config.tabs()) {
                this.clientThread.invokeLater(this.tabInterface::init);
            } else {
                this.clientThread.invokeLater(this.tabInterface::destroy);
            }
        }
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        this.tabInterface.update();
    }

    @Subscribe
    public void onDraggingWidgetChanged(DraggingWidgetChanged event) {
        this.tabInterface.handleDrag(event.isDraggingWidget(), this.shiftPressed);
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded event) {
        if (event.getGroupId() == 12) {
            this.tabInterface.init();
        }
    }

    @Subscribe
    public void onFocusChanged(FocusChanged event) {
        if (!event.isFocused()) {
            this.shiftPressed = false;
        }
    }

    @Override
    public MouseWheelEvent mouseWheelMoved(MouseWheelEvent event) {
        this.tabInterface.handleWheel(event);
        return event;
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 16) {
            this.shiftPressed = true;
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 16) {
            this.shiftPressed = false;
        }
    }
}

