/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.bank;

import com.google.inject.Provides;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.MenuEntry;
import net.runelite.api.events.MenuEntryAdded;
import net.runelite.api.events.MenuShouldLeftClick;
import net.runelite.api.events.ScriptCallbackEvent;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.bank.BankCalculation;
import net.runelite.client.plugins.bank.BankConfig;
import net.runelite.client.plugins.banktags.tabs.BankSearch;
import net.runelite.client.util.StackFormatter;

@PluginDescriptor(name="Bank", description="Modifications to the banking interface", tags={"grand", "exchange", "high", "alchemy", "prices", "deposit"})
public class BankPlugin
extends Plugin {
    private static final String DEPOSIT_WORN = "Deposit worn items";
    private static final String DEPOSIT_INVENTORY = "Deposit inventory";
    private static final String DEPOSIT_LOOT = "Deposit loot";
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private BankCalculation bankCalculation;
    @Inject
    private BankConfig config;
    @Inject
    private BankSearch bankSearch;
    private boolean forceRightClickFlag;

    @Provides
    BankConfig getConfig(ConfigManager configManager) {
        return configManager.getConfig(BankConfig.class);
    }

    @Override
    protected void shutDown() {
        this.clientThread.invokeLater(() -> this.bankSearch.reset(false));
        this.forceRightClickFlag = false;
    }

    @Subscribe
    public void onMenuShouldLeftClick(MenuShouldLeftClick event) {
        MenuEntry[] menuEntries;
        if (!this.forceRightClickFlag) {
            return;
        }
        this.forceRightClickFlag = false;
        for (MenuEntry entry : menuEntries = this.client.getMenuEntries()) {
            if (!(entry.getOption().equals(DEPOSIT_WORN) && this.config.rightClickBankEquip() || entry.getOption().equals(DEPOSIT_INVENTORY) && this.config.rightClickBankInventory()) && (!entry.getOption().equals(DEPOSIT_LOOT) || !this.config.rightClickBankLoot())) continue;
            event.setForceRightClick(true);
            return;
        }
    }

    @Subscribe
    public void onMenuEntryAdded(MenuEntryAdded event) {
        if (event.getOption().equals(DEPOSIT_WORN) && this.config.rightClickBankEquip() || event.getOption().equals(DEPOSIT_INVENTORY) && this.config.rightClickBankInventory() || event.getOption().equals(DEPOSIT_LOOT) && this.config.rightClickBankLoot()) {
            this.forceRightClickFlag = true;
        }
    }

    @Subscribe
    public void onScriptCallbackEvent(ScriptCallbackEvent event) {
        if (!event.getEventName().equals("setBankTitle")) {
            return;
        }
        Object strCurrentTab = "";
        this.bankCalculation.calculate();
        long gePrice = this.bankCalculation.getGePrice();
        long haPrice = this.bankCalculation.getHaPrice();
        if (this.config.showGE() && gePrice != 0L) {
            strCurrentTab = (String)strCurrentTab + " (";
            if (this.config.showHA()) {
                strCurrentTab = (String)strCurrentTab + "EX: ";
            }
            strCurrentTab = this.config.showExact() ? (String)strCurrentTab + StackFormatter.formatNumber(gePrice) + ")" : (String)strCurrentTab + StackFormatter.quantityToStackSize(gePrice) + ")";
        }
        if (this.config.showHA() && haPrice != 0L) {
            strCurrentTab = (String)strCurrentTab + " (";
            if (this.config.showGE()) {
                strCurrentTab = (String)strCurrentTab + "HA: ";
            }
            strCurrentTab = this.config.showExact() ? (String)strCurrentTab + StackFormatter.formatNumber(haPrice) + ")" : (String)strCurrentTab + StackFormatter.quantityToStackSize(haPrice) + ")";
        }
        String[] stringStack = this.client.getStringStack();
        int stringStackSize = this.client.getStringStackSize();
        int n = stringStackSize - 1;
        stringStack[n] = stringStack[n] + (String)strCurrentTab;
    }
}

