/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.bank;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemComposition;
import net.runelite.api.ItemContainer;
import net.runelite.api.Varbits;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.bank.BankConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BankCalculation {
    private static final Logger log = LoggerFactory.getLogger(BankCalculation.class);
    private static final float HIGH_ALCHEMY_CONSTANT = 0.6f;
    private static final ImmutableList<Varbits> TAB_VARBITS = ImmutableList.of(Varbits.BANK_TAB_ONE_COUNT, Varbits.BANK_TAB_TWO_COUNT, Varbits.BANK_TAB_THREE_COUNT, Varbits.BANK_TAB_FOUR_COUNT, Varbits.BANK_TAB_FIVE_COUNT, Varbits.BANK_TAB_SIX_COUNT, Varbits.BANK_TAB_SEVEN_COUNT, Varbits.BANK_TAB_EIGHT_COUNT, Varbits.BANK_TAB_NINE_COUNT);
    private final BankConfig config;
    private final ItemManager itemManager;
    private final Client client;
    private int itemsHash;
    private long gePrice;
    private long haPrice;

    @Inject
    BankCalculation(ItemManager itemManager, BankConfig config, Client client2) {
        this.itemManager = itemManager;
        this.config = config;
        this.client = client2;
    }

    void calculate() {
        ItemContainer bankInventory = this.client.getItemContainer(InventoryID.BANK);
        if (bankInventory == null) {
            return;
        }
        Item[] items = bankInventory.getItems();
        int currentTab = this.client.getVar(Varbits.CURRENT_BANK_TAB);
        if (currentTab > 0) {
            int startIndex = 0;
            for (int i = currentTab - 1; i > 0; --i) {
                startIndex += this.client.getVar((Varbits)((Object)TAB_VARBITS.get(i - 1)));
            }
            int itemCount = this.client.getVar((Varbits)((Object)TAB_VARBITS.get(currentTab - 1)));
            items = Arrays.copyOfRange(items, startIndex, startIndex + itemCount);
        }
        if (items.length == 0 || !this.isBankDifferent(items)) {
            return;
        }
        log.debug("Calculating new bank value...");
        this.haPrice = 0L;
        this.gePrice = 0L;
        ArrayList<Integer> itemIds = new ArrayList<Integer>();
        for (Item item : items) {
            int price;
            int quantity = item.getQuantity();
            if (item.getId() <= 0 || quantity == 0) continue;
            if (item.getId() == 995) {
                this.gePrice += (long)quantity;
                this.haPrice += (long)quantity;
                continue;
            }
            if (item.getId() == 13204) {
                this.gePrice += (long)quantity * 1000L;
                this.haPrice += (long)quantity * 1000L;
                continue;
            }
            ItemComposition itemComposition = this.itemManager.getItemComposition(item.getId());
            if (this.config.showGE()) {
                itemIds.add(item.getId());
            }
            if (!this.config.showHA() || (price = itemComposition.getPrice()) <= 0) continue;
            this.haPrice += (long)Math.round((float)price * 0.6f) * (long)quantity;
        }
        if (this.config.showGE() && !itemIds.isEmpty()) {
            for (Item item : items) {
                int itemId = item.getId();
                int quantity = item.getQuantity();
                if (itemId <= 0 || quantity == 0 || itemId == 995 || itemId == 13204) continue;
                this.gePrice += (long)this.itemManager.getItemPrice(itemId) * (long)quantity;
            }
        }
    }

    private boolean isBankDifferent(Item[] items) {
        HashMap<Integer, Integer> mapCheck = new HashMap<Integer, Integer>();
        for (Item item : items) {
            mapCheck.put(item.getId(), item.getQuantity());
        }
        int curHash = mapCheck.hashCode();
        if (curHash != this.itemsHash) {
            this.itemsHash = curHash;
            return true;
        }
        return false;
    }

    public long getGePrice() {
        return this.gePrice;
    }

    public long getHaPrice() {
        return this.haPrice;
    }
}

