/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.attackstyles;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.inject.Inject;
import net.runelite.api.MenuAction;
import net.runelite.client.plugins.attackstyles.AttackStylesConfig;
import net.runelite.client.plugins.attackstyles.AttackStylesPlugin;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayMenuEntry;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.PanelComponent;
import net.runelite.client.ui.overlay.components.TitleComponent;

class AttackStylesOverlay
extends Overlay {
    private final AttackStylesPlugin plugin;
    private final AttackStylesConfig config;
    private final PanelComponent panelComponent = new PanelComponent();

    @Inject
    private AttackStylesOverlay(AttackStylesPlugin plugin, AttackStylesConfig config) {
        super(plugin);
        this.setPosition(OverlayPosition.ABOVE_CHATBOX_RIGHT);
        this.plugin = plugin;
        this.config = config;
        this.getMenuEntries().add(new OverlayMenuEntry(MenuAction.RUNELITE_OVERLAY_CONFIG, "Configure", "Attack style overlay"));
    }

    @Override
    public Dimension render(Graphics2D graphics) {
        this.panelComponent.getChildren().clear();
        boolean warnedSkillSelected = this.plugin.isWarnedSkillSelected();
        if (warnedSkillSelected || this.config.alwaysShowStyle()) {
            String attackStyleString = this.plugin.getAttackStyle().getName();
            this.panelComponent.getChildren().add(TitleComponent.builder().text(attackStyleString).color(warnedSkillSelected ? Color.RED : Color.WHITE).build());
            this.panelComponent.setPreferredSize(new Dimension(graphics.getFontMetrics().stringWidth(attackStyleString) + 10, 0));
            return this.panelComponent.render(graphics);
        }
        return null;
    }
}

