/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.antidrag;

import com.google.inject.Provides;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.events.ConfigChanged;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.antidrag.AntiDragConfig;

@PluginDescriptor(name="Anti Drag", description="Prevent dragging an item for a specified delay", tags={"antidrag", "delay", "inventory", "items"}, enabledByDefault=false)
public class AntiDragPlugin
extends Plugin {
    private static final int DEFAULT_DELAY = 5;
    @Inject
    private Client client;
    @Inject
    private AntiDragConfig config;

    @Provides
    AntiDragConfig getConfig(ConfigManager configManager) {
        return configManager.getConfig(AntiDragConfig.class);
    }

    @Override
    protected void startUp() throws Exception {
        this.client.setInventoryDragDelay(this.config.dragDelay());
    }

    @Override
    protected void shutDown() throws Exception {
        this.client.setInventoryDragDelay(5);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals("antiDrag")) {
            this.client.setInventoryDragDelay(this.config.dragDelay());
        }
    }
}

