/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.agility;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.time.Duration;
import java.time.Instant;
import javax.inject.Inject;
import net.runelite.api.MenuAction;
import net.runelite.client.plugins.agility.AgilityConfig;
import net.runelite.client.plugins.agility.AgilityPlugin;
import net.runelite.client.plugins.agility.AgilitySession;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayMenuEntry;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.PanelComponent;

class LapCounterOverlay
extends Overlay {
    private final AgilityPlugin plugin;
    private final AgilityConfig config;
    private final PanelComponent panelComponent = new PanelComponent();

    @Inject
    private LapCounterOverlay(AgilityPlugin plugin, AgilityConfig config) {
        super(plugin);
        this.setPosition(OverlayPosition.TOP_LEFT);
        this.setPriority(OverlayPriority.LOW);
        this.plugin = plugin;
        this.config = config;
        this.getMenuEntries().add(new OverlayMenuEntry(MenuAction.RUNELITE_OVERLAY_CONFIG, "Configure", "Agility overlay"));
    }

    @Override
    public Dimension render(Graphics2D graphics) {
        AgilitySession session = this.plugin.getSession();
        if (!this.config.showLapCount() || session == null || session.getLastLapCompleted() == null || session.getCourse() == null) {
            return null;
        }
        Duration lapTimeout = Duration.ofMinutes(this.config.lapTimeout());
        Duration sinceLap = Duration.between(session.getLastLapCompleted(), Instant.now());
        if (sinceLap.compareTo(lapTimeout) >= 0) {
            session.setLastLapCompleted(null);
            return null;
        }
        this.panelComponent.getChildren().clear();
        this.panelComponent.getChildren().add(LineComponent.builder().left("Total Laps:").right(Integer.toString(session.getTotalLaps())).build());
        if (session.getLapsTillLevel() > 0) {
            this.panelComponent.getChildren().add(LineComponent.builder().left("Laps until level:").right(Integer.toString(session.getLapsTillLevel())).build());
        }
        return this.panelComponent.render(graphics);
    }
}

