/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.agility;

import java.time.Instant;
import net.runelite.api.Client;
import net.runelite.api.Experience;
import net.runelite.api.Skill;
import net.runelite.client.plugins.agility.Courses;

class AgilitySession {
    private final Courses course;
    private Instant lastLapCompleted;
    private int totalLaps;
    private int lapsTillLevel;

    AgilitySession(Courses course) {
        this.course = course;
    }

    void incrementLapCount(Client client2) {
        int remainingXp;
        this.lastLapCompleted = Instant.now();
        ++this.totalLaps;
        int currentExp = client2.getSkillExperience(Skill.AGILITY);
        int nextLevel = client2.getRealSkillLevel(Skill.AGILITY) + 1;
        do {
            remainingXp = nextLevel <= 126 ? Experience.getXpForLevel(nextLevel) - currentExp : 0;
            ++nextLevel;
        } while (remainingXp < 0);
        this.lapsTillLevel = remainingXp > 0 ? (int)Math.ceil((double)remainingXp / this.course.getTotalXp()) : 0;
    }

    void resetLapCount() {
        this.totalLaps = 0;
        this.lapsTillLevel = 0;
    }

    public Courses getCourse() {
        return this.course;
    }

    public Instant getLastLapCompleted() {
        return this.lastLapCompleted;
    }

    public int getTotalLaps() {
        return this.totalLaps;
    }

    public int getLapsTillLevel() {
        return this.lapsTillLevel;
    }

    public void setLastLapCompleted(Instant lastLapCompleted) {
        this.lastLapCompleted = lastLapCompleted;
    }

    public void setTotalLaps(int totalLaps) {
        this.totalLaps = totalLaps;
    }

    public void setLapsTillLevel(int lapsTillLevel) {
        this.lapsTillLevel = lapsTillLevel;
    }
}

