/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.agility;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.geom.Area;
import java.util.List;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Point;
import net.runelite.api.Tile;
import net.runelite.api.coords.LocalPoint;
import net.runelite.client.game.AgilityShortcut;
import net.runelite.client.plugins.agility.AgilityConfig;
import net.runelite.client.plugins.agility.AgilityPlugin;
import net.runelite.client.plugins.agility.Obstacles;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayUtil;

class AgilityOverlay
extends Overlay {
    private static final int MAX_DISTANCE = 2350;
    private static final Color SHORTCUT_HIGH_LEVEL_COLOR = Color.ORANGE;
    private final Client client;
    private final AgilityPlugin plugin;
    private final AgilityConfig config;

    @Inject
    private AgilityOverlay(Client client2, AgilityPlugin plugin, AgilityConfig config) {
        super(plugin);
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
        this.client = client2;
        this.plugin = plugin;
        this.config = config;
    }

    @Override
    public Dimension render(Graphics2D graphics) {
        LocalPoint playerLocation = this.client.getLocalPlayer().getLocalLocation();
        Point mousePosition = this.client.getMouseCanvasPosition();
        List<Tile> marksOfGrace = this.plugin.getMarksOfGrace();
        this.plugin.getObstacles().forEach((object, obstacle) -> {
            if (Obstacles.SHORTCUT_OBSTACLE_IDS.containsKey(object.getId()) && !this.config.highlightShortcuts() || Obstacles.TRAP_OBSTACLE_IDS.contains(object.getId()) && !this.config.showTrapOverlay()) {
                return;
            }
            Tile tile = obstacle.getTile();
            if (tile.getPlane() == this.client.getPlane() && object.getLocalLocation().distanceTo(playerLocation) < 2350) {
                if (Obstacles.TRAP_OBSTACLE_IDS.contains(object.getId())) {
                    Polygon polygon = object.getCanvasTilePoly();
                    if (polygon != null) {
                        OverlayUtil.renderPolygon(graphics, polygon, this.config.getTrapColor());
                    }
                    return;
                }
                Area objectClickbox = object.getClickbox();
                if (objectClickbox != null) {
                    Color configColor;
                    AgilityShortcut agilityShortcut = obstacle.getShortcut();
                    Color color = configColor = agilityShortcut == null || agilityShortcut.getLevel() <= this.plugin.getAgilityLevel() ? this.config.getOverlayColor() : SHORTCUT_HIGH_LEVEL_COLOR;
                    if (this.config.highlightMarks() && !marksOfGrace.isEmpty()) {
                        configColor = this.config.getMarkColor();
                    }
                    if (objectClickbox.contains(mousePosition.getX(), mousePosition.getY())) {
                        graphics.setColor(configColor.darker());
                    } else {
                        graphics.setColor(configColor);
                    }
                    graphics.draw(objectClickbox);
                    graphics.setColor(new Color(configColor.getRed(), configColor.getGreen(), configColor.getBlue(), 50));
                    graphics.fill(objectClickbox);
                }
            }
        });
        if (this.config.highlightMarks() && !marksOfGrace.isEmpty()) {
            for (Tile markOfGraceTile : marksOfGrace) {
                Polygon poly;
                if (markOfGraceTile.getPlane() != this.client.getPlane() || markOfGraceTile.getItemLayer() == null || markOfGraceTile.getLocalLocation().distanceTo(playerLocation) >= 2350 || (poly = markOfGraceTile.getItemLayer().getCanvasTilePoly()) == null) continue;
                OverlayUtil.renderPolygon(graphics, poly, this.config.getMarkColor());
            }
        }
        return null;
    }
}

