/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.graph.Graph;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.Graphs;
import com.google.common.graph.MutableGraph;
import com.google.common.reflect.ClassPath;
import com.google.inject.CreationException;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.swing.SwingUtilities;
import net.runelite.client.RuneLite;
import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.config.RuneLiteConfig;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.PluginChanged;
import net.runelite.client.events.SessionClose;
import net.runelite.client.events.SessionOpen;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDependency;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.PluginInstantiationException;
import net.runelite.client.task.Schedule;
import net.runelite.client.task.ScheduledMethod;
import net.runelite.client.task.Scheduler;
import net.runelite.client.util.GameEventManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class PluginManager {
    private static final Logger log = LoggerFactory.getLogger(PluginManager.class);
    private static final String PLUGIN_PACKAGE = "net.runelite.client.plugins";
    private final boolean developerMode;
    private final EventBus eventBus;
    private final Scheduler scheduler;
    private final ConfigManager configManager;
    private final ScheduledExecutorService executor;
    private final Provider<GameEventManager> sceneTileManager;
    private final List<Plugin> plugins = new CopyOnWriteArrayList<Plugin>();
    private final List<Plugin> activePlugins = new CopyOnWriteArrayList<Plugin>();
    private final String runeliteGroupName = RuneLiteConfig.class.getAnnotation(ConfigGroup.class).value();
    boolean isOutdated;

    @Inject
    @VisibleForTesting
    PluginManager(@Named(value="developerMode") boolean developerMode, EventBus eventBus, Scheduler scheduler, ConfigManager configManager, ScheduledExecutorService executor, Provider<GameEventManager> sceneTileManager) {
        this.developerMode = developerMode;
        this.eventBus = eventBus;
        this.scheduler = scheduler;
        this.configManager = configManager;
        this.executor = executor;
        this.sceneTileManager = sceneTileManager;
    }

    @Subscribe
    public void onSessionOpen(SessionOpen event) {
        this.refreshPlugins();
    }

    @Subscribe
    public void onSessionClose(SessionClose event) {
        this.refreshPlugins();
    }

    private void refreshPlugins() {
        this.loadDefaultPluginConfiguration();
        this.getPlugins().forEach(plugin -> this.executor.submit(() -> {
            try {
                if (!this.startPlugin((Plugin)plugin)) {
                    this.stopPlugin((Plugin)plugin);
                }
            }
            catch (PluginInstantiationException e) {
                log.warn("Error during starting/stopping plugin {}. {}", (Object)plugin.getClass().getSimpleName(), (Object)e);
            }
        }));
    }

    public Config getPluginConfigProxy(Plugin plugin) {
        Injector injector = plugin.getInjector();
        for (Key<?> key : injector.getAllBindings().keySet()) {
            Class<?> type = key.getTypeLiteral().getRawType();
            if (!Config.class.isAssignableFrom(type)) continue;
            return (Config)injector.getInstance(key);
        }
        return null;
    }

    public List<Config> getPluginConfigProxies() {
        ArrayList<Injector> injectors = new ArrayList<Injector>();
        injectors.add(RuneLite.getInjector());
        this.getPlugins().forEach(pl -> injectors.add(pl.getInjector()));
        ArrayList<Config> list = new ArrayList<Config>();
        for (Injector injector : injectors) {
            for (Key<?> key : injector.getAllBindings().keySet()) {
                Class<?> type = key.getTypeLiteral().getRawType();
                if (!Config.class.isAssignableFrom(type)) continue;
                Config config = (Config)injector.getInstance(key);
                list.add(config);
            }
        }
        return list;
    }

    public void loadDefaultPluginConfiguration() {
        for (Config config : this.getPluginConfigProxies()) {
            this.configManager.setDefaultConfiguration(config, false);
        }
    }

    public void loadCorePlugins() throws IOException {
        this.plugins.addAll(this.scanAndInstantiate(this.getClass().getClassLoader(), PLUGIN_PACKAGE));
    }

    public void startCorePlugins() {
        ArrayList<Plugin> scannedPlugins = new ArrayList<Plugin>(this.plugins);
        for (Plugin plugin : scannedPlugins) {
            try {
                this.startPlugin(plugin);
            }
            catch (PluginInstantiationException ex) {
                log.warn("Unable to start plugin {}. {}", (Object)plugin.getClass().getSimpleName(), (Object)ex);
                this.plugins.remove(plugin);
            }
        }
    }

    List<Plugin> scanAndInstantiate(ClassLoader classLoader, String packageName) throws IOException {
        MutableGraph graph = GraphBuilder.directed().build();
        ArrayList<Plugin> scannedPlugins = new ArrayList<Plugin>();
        ClassPath classPath = ClassPath.from(classLoader);
        ImmutableSet<ClassPath.ClassInfo> classes = packageName == null ? classPath.getAllClasses() : classPath.getTopLevelClassesRecursive(packageName);
        for (ClassPath.ClassInfo classInfo : classes) {
            Class<?> clazz = classInfo.load();
            PluginDependency[] pluginDescriptor = clazz.getAnnotation(PluginDescriptor.class);
            if (pluginDescriptor == null) {
                if (clazz.getSuperclass() != Plugin.class) continue;
                log.warn("Class {} is a plugin, but has no plugin descriptor", (Object)clazz);
                continue;
            }
            if (clazz.getSuperclass() != Plugin.class) {
                log.warn("Class {} has plugin descriptor, but is not a plugin", (Object)clazz);
                continue;
            }
            if (!pluginDescriptor.loadWhenOutdated() && this.isOutdated || pluginDescriptor.developerPlugin() && !this.developerMode) continue;
            Class<?> pluginClass = clazz;
            graph.addNode(pluginClass);
        }
        for (Class pluginClazz : graph.nodes()) {
            PluginDependency[] pluginDependencies;
            for (PluginDependency pluginDependency : pluginDependencies = (PluginDependency[])pluginClazz.getAnnotationsByType(PluginDependency.class)) {
                graph.putEdge(pluginClazz, pluginDependency.value());
            }
        }
        if (Graphs.hasCycle(graph)) {
            throw new RuntimeException("Plugin dependency graph contains a cycle!");
        }
        List sortedPlugins = this.topologicalSort(graph);
        sortedPlugins = Lists.reverse(sortedPlugins);
        for (Class pluginClazz : sortedPlugins) {
            Plugin plugin;
            try {
                plugin = this.instantiate(scannedPlugins, pluginClazz);
            }
            catch (PluginInstantiationException ex) {
                log.warn("Error instantiating plugin!", ex);
                continue;
            }
            scannedPlugins.add(plugin);
        }
        return scannedPlugins;
    }

    public synchronized boolean startPlugin(Plugin plugin) throws PluginInstantiationException {
        if (this.activePlugins.contains(plugin) || !this.isPluginEnabled(plugin)) {
            return false;
        }
        this.activePlugins.add(plugin);
        try {
            GameEventManager gameEventManager;
            SwingUtilities.invokeAndWait(() -> {
                try {
                    plugin.startUp();
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            });
            log.debug("Plugin {} is now running", (Object)plugin.getClass().getSimpleName());
            if (!this.isOutdated && this.sceneTileManager != null && (gameEventManager = this.sceneTileManager.get()) != null) {
                gameEventManager.simulateGameEvents(plugin);
            }
            this.eventBus.register(plugin);
            this.schedule(plugin);
            this.eventBus.post(new PluginChanged(plugin, true));
        }
        catch (IllegalArgumentException | InterruptedException | InvocationTargetException ex) {
            throw new PluginInstantiationException(ex);
        }
        return true;
    }

    public synchronized boolean stopPlugin(Plugin plugin) throws PluginInstantiationException {
        if (!this.activePlugins.contains(plugin) || this.isPluginEnabled(plugin)) {
            return false;
        }
        this.activePlugins.remove(plugin);
        try {
            this.unschedule(plugin);
            this.eventBus.unregister(plugin);
            SwingUtilities.invokeAndWait(() -> {
                try {
                    plugin.shutDown();
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            });
            log.debug("Plugin {} is now stopped", (Object)plugin.getClass().getSimpleName());
            this.eventBus.post(new PluginChanged(plugin, false));
        }
        catch (InterruptedException | InvocationTargetException ex) {
            throw new PluginInstantiationException(ex);
        }
        return true;
    }

    public void setPluginEnabled(Plugin plugin, boolean enabled) {
        String keyName = plugin.getClass().getSimpleName().toLowerCase();
        this.configManager.setConfiguration(this.runeliteGroupName, keyName, String.valueOf(enabled));
    }

    public boolean isPluginEnabled(Plugin plugin) {
        String keyName = plugin.getClass().getSimpleName().toLowerCase();
        String value = this.configManager.getConfiguration(this.runeliteGroupName, keyName);
        if (value != null) {
            return Boolean.valueOf(value);
        }
        PluginDescriptor pluginDescriptor = plugin.getClass().getAnnotation(PluginDescriptor.class);
        return pluginDescriptor == null || pluginDescriptor.enabledByDefault();
    }

    private Plugin instantiate(List<Plugin> scannedPlugins, Class<Plugin> clazz) throws PluginInstantiationException {
        Plugin plugin;
        PluginDependency[] pluginDependencies = (PluginDependency[])clazz.getAnnotationsByType(PluginDependency.class);
        ArrayList<Plugin> deps = new ArrayList<Plugin>();
        for (PluginDependency pluginDependency : pluginDependencies) {
            Optional<Plugin> dependency = scannedPlugins.stream().filter(p -> p.getClass() == pluginDependency.value()).findFirst();
            if (!dependency.isPresent()) {
                throw new PluginInstantiationException("Unmet dependency for " + clazz.getSimpleName() + ": " + pluginDependency.value().getSimpleName());
            }
            deps.add(dependency.get());
        }
        try {
            plugin = clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException ex) {
            throw new PluginInstantiationException(ex);
        }
        try {
            Module pluginModule = binder -> {
                binder.bind(clazz).toInstance(plugin);
                binder.install(plugin);
                for (Plugin p : deps) {
                    Module p2 = binder2 -> {
                        binder2.bind(p.getClass()).toInstance(p);
                        binder2.install(p);
                    };
                    binder.install(p2);
                }
            };
            Injector pluginInjector = RuneLite.getInjector().createChildInjector(pluginModule);
            pluginInjector.injectMembers(plugin);
            plugin.injector = pluginInjector;
        }
        catch (CreationException ex) {
            throw new PluginInstantiationException(ex);
        }
        log.debug("Loaded plugin {}", (Object)clazz.getSimpleName());
        return plugin;
    }

    void add(Plugin plugin) {
        this.plugins.add(plugin);
    }

    void remove(Plugin plugin) {
        this.plugins.remove(plugin);
    }

    public Collection<Plugin> getPlugins() {
        return this.plugins;
    }

    private void schedule(Plugin plugin) {
        for (Method method : plugin.getClass().getMethods()) {
            Schedule schedule = method.getAnnotation(Schedule.class);
            if (schedule == null) continue;
            ScheduledMethod scheduledMethod = new ScheduledMethod(schedule, method, plugin);
            log.debug("Scheduled task {}", (Object)scheduledMethod);
            this.scheduler.addScheduledMethod(scheduledMethod);
        }
    }

    private void unschedule(Plugin plugin) {
        ArrayList<ScheduledMethod> methods = new ArrayList<ScheduledMethod>(this.scheduler.getScheduledMethods());
        for (ScheduledMethod method : methods) {
            if (method.getObject() != plugin) continue;
            log.debug("Removing scheduled task {}", (Object)method);
            this.scheduler.removeScheduledMethod(method);
        }
    }

    private <T> List<T> topologicalSort(Graph<T> graph) {
        MutableGraph graphCopy = Graphs.copyOf(graph);
        ArrayList l = new ArrayList();
        Set s = graphCopy.nodes().stream().filter(node -> graphCopy.inDegree(node) == 0).collect(Collectors.toSet());
        while (!s.isEmpty()) {
            Iterator it = s.iterator();
            Object n = it.next();
            it.remove();
            l.add(n);
            for (Object m : graphCopy.successors(n)) {
                graphCopy.removeEdge(n, m);
                if (graphCopy.inDegree(m) != 0) continue;
                s.add(m);
            }
        }
        if (!graphCopy.edges().isEmpty()) {
            throw new RuntimeException("Graph has at least one cycle");
        }
        return l;
    }

    public void setOutdated(boolean isOutdated) {
        this.isOutdated = isOutdated;
    }
}

