/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.menus;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.NPCComposition;
import net.runelite.api.events.MenuEntryAdded;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.events.NpcActionChanged;
import net.runelite.api.events.PlayerMenuOptionClicked;
import net.runelite.api.events.PlayerMenuOptionsChanged;
import net.runelite.api.events.WidgetMenuOptionClicked;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.menus.WidgetMenuOption;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class MenuManager {
    private static final Logger log = LoggerFactory.getLogger(MenuManager.class);
    private static final int IDX_LOWER = 4;
    private static final int IDX_UPPER = 8;
    private final Client client;
    private final EventBus eventBus;
    private final Map<Integer, String> playerMenuIndexMap = new HashMap<Integer, String>();
    private final Multimap<Integer, WidgetMenuOption> managedMenuOptions = HashMultimap.create();
    private final Set<String> npcMenuOptions = new HashSet<String>();

    @Inject
    private MenuManager(Client client2, EventBus eventBus) {
        this.client = client2;
        this.eventBus = eventBus;
    }

    public void addManagedCustomMenu(WidgetMenuOption customMenuOption) {
        WidgetInfo widget = customMenuOption.getWidget();
        this.managedMenuOptions.put(widget.getId(), customMenuOption);
    }

    public void removeManagedCustomMenu(WidgetMenuOption customMenuOption) {
        WidgetInfo widget = customMenuOption.getWidget();
        this.managedMenuOptions.remove(widget.getId(), customMenuOption);
    }

    private boolean menuContainsCustomMenu(WidgetMenuOption customMenuOption) {
        for (MenuEntry menuEntry : this.client.getMenuEntries()) {
            String option = menuEntry.getOption();
            String target = menuEntry.getTarget();
            if (!option.equals(customMenuOption.getMenuOption()) || !target.equals(customMenuOption.getMenuTarget())) continue;
            return true;
        }
        return false;
    }

    @Subscribe
    public void onMenuEntryAdded(MenuEntryAdded event) {
        int widgetId = event.getActionParam1();
        Collection<WidgetMenuOption> options = this.managedMenuOptions.get(widgetId);
        for (WidgetMenuOption currentMenu : options) {
            if (this.menuContainsCustomMenu(currentMenu)) continue;
            MenuEntry[] menuEntries = this.client.getMenuEntries();
            menuEntries = Arrays.copyOf(menuEntries, menuEntries.length + 1);
            MenuEntry menuEntry = new MenuEntry();
            menuEntries[menuEntries.length - 1] = menuEntry;
            MenuEntry menuEntry2 = menuEntry;
            menuEntry2.setOption(currentMenu.getMenuOption());
            menuEntry2.setParam1(widgetId);
            menuEntry2.setTarget(currentMenu.getMenuTarget());
            menuEntry2.setType(MenuAction.RUNELITE.getId());
            this.client.setMenuEntries(menuEntries);
        }
    }

    public void addPlayerMenuItem(String menuText) {
        Preconditions.checkNotNull(menuText);
        int playerMenuIndex = this.findEmptyPlayerMenuIndex();
        if (playerMenuIndex == 8) {
            return;
        }
        this.addPlayerMenuItem(playerMenuIndex, menuText);
    }

    public void removePlayerMenuItem(String menuText) {
        Preconditions.checkNotNull(menuText);
        for (Map.Entry<Integer, String> entry : this.playerMenuIndexMap.entrySet()) {
            if (!entry.getValue().equalsIgnoreCase(menuText)) continue;
            this.removePlayerMenuItem(entry.getKey());
            break;
        }
    }

    @Subscribe
    public void onPlayerMenuOptionsChanged(PlayerMenuOptionsChanged event) {
        int idx = event.getIndex();
        String menuText = this.playerMenuIndexMap.get(idx);
        if (menuText == null) {
            return;
        }
        int newIdx = this.findEmptyPlayerMenuIndex();
        if (newIdx == 8) {
            log.debug("Client has updated player menu index {} where option {} was, and there are no more free slots available", (Object)idx, (Object)menuText);
            return;
        }
        log.debug("Client has updated player menu index {} where option {} was, moving to index {}", idx, menuText, newIdx);
        this.playerMenuIndexMap.remove(idx);
        this.addPlayerMenuItem(newIdx, menuText);
    }

    @Subscribe
    public void onNpcActionChanged(NpcActionChanged event) {
        NPCComposition composition = event.getNpcComposition();
        for (String npcOption : this.npcMenuOptions) {
            this.addNpcOption(composition, npcOption);
        }
    }

    private void addNpcOption(NPCComposition composition, String npcOption) {
        String[] actions = composition.getActions();
        int unused = -1;
        for (int i = 0; i < actions.length; ++i) {
            if (actions[i] == null && unused == -1) {
                unused = i;
                continue;
            }
            if (actions[i] == null || !actions[i].equals(npcOption)) continue;
            return;
        }
        if (unused == -1) {
            return;
        }
        actions[unused] = npcOption;
    }

    private void removeNpcOption(NPCComposition composition, String npcOption) {
        String[] actions = composition.getActions();
        if (composition.getActions() == null) {
            return;
        }
        for (int i = 0; i < actions.length; ++i) {
            if (actions[i] == null || !actions[i].equals(npcOption)) continue;
            actions[i] = null;
        }
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked event) {
        if (event.getMenuAction() != MenuAction.RUNELITE) {
            return;
        }
        int widgetId = event.getWidgetId();
        Collection<WidgetMenuOption> options = this.managedMenuOptions.get(widgetId);
        for (WidgetMenuOption curMenuOption : options) {
            if (!curMenuOption.getMenuTarget().equals(event.getMenuTarget()) || !curMenuOption.getMenuOption().equals(event.getMenuOption())) continue;
            WidgetMenuOptionClicked customMenu = new WidgetMenuOptionClicked();
            customMenu.setMenuOption(event.getMenuOption());
            customMenu.setMenuTarget(event.getMenuTarget());
            customMenu.setWidget(curMenuOption.getWidget());
            this.eventBus.post(customMenu);
            return;
        }
        String target = event.getMenuTarget();
        String username = Text.removeTags(target).split("[(]")[0].trim();
        PlayerMenuOptionClicked playerMenuOptionClicked = new PlayerMenuOptionClicked();
        playerMenuOptionClicked.setMenuOption(event.getMenuOption());
        playerMenuOptionClicked.setMenuTarget(username);
        this.eventBus.post(playerMenuOptionClicked);
    }

    private void addPlayerMenuItem(int playerOptionIndex, String menuText) {
        this.client.getPlayerOptions()[playerOptionIndex] = menuText;
        this.client.getPlayerOptionsPriorities()[playerOptionIndex] = true;
        this.client.getPlayerMenuTypes()[playerOptionIndex] = MenuAction.RUNELITE.getId();
        this.playerMenuIndexMap.put(playerOptionIndex, menuText);
    }

    private void removePlayerMenuItem(int playerOptionIndex) {
        this.client.getPlayerOptions()[playerOptionIndex] = null;
        this.playerMenuIndexMap.remove(playerOptionIndex);
    }

    private int findEmptyPlayerMenuIndex() {
        int index;
        String[] playerOptions = this.client.getPlayerOptions();
        for (index = 4; index < 8 && playerOptions[index] != null; ++index) {
        }
        return index;
    }
}

