/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.input;

import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.inject.Singleton;
import net.runelite.client.input.MouseListener;
import net.runelite.client.input.MouseWheelListener;

@Singleton
public class MouseManager {
    private final List<MouseListener> mouseListeners = new CopyOnWriteArrayList<MouseListener>();
    private final List<MouseWheelListener> mouseWheelListeners = new CopyOnWriteArrayList<MouseWheelListener>();

    public void registerMouseListener(MouseListener mouseListener) {
        if (!this.mouseListeners.contains(mouseListener)) {
            this.mouseListeners.add(mouseListener);
        }
    }

    public void registerMouseListener(int position, MouseListener mouseListener) {
        this.mouseListeners.add(position, mouseListener);
    }

    public void unregisterMouseListener(MouseListener mouseListener) {
        this.mouseListeners.remove(mouseListener);
    }

    public void registerMouseWheelListener(MouseWheelListener mouseWheelListener) {
        if (!this.mouseWheelListeners.contains(mouseWheelListener)) {
            this.mouseWheelListeners.add(mouseWheelListener);
        }
    }

    public void registerMouseWheelListener(int position, MouseWheelListener mouseWheelListener) {
        this.mouseWheelListeners.add(position, mouseWheelListener);
    }

    public void unregisterMouseWheelListener(MouseWheelListener mouseWheelListener) {
        this.mouseWheelListeners.remove(mouseWheelListener);
    }

    public MouseEvent processMousePressed(MouseEvent mouseEvent) {
        for (MouseListener mouseListener : this.mouseListeners) {
            mouseEvent = mouseListener.mousePressed(mouseEvent);
        }
        return mouseEvent;
    }

    public MouseEvent processMouseReleased(MouseEvent mouseEvent) {
        for (MouseListener mouseListener : this.mouseListeners) {
            mouseEvent = mouseListener.mouseReleased(mouseEvent);
        }
        return mouseEvent;
    }

    public MouseEvent processMouseClicked(MouseEvent mouseEvent) {
        for (MouseListener mouseListener : this.mouseListeners) {
            mouseEvent = mouseListener.mouseClicked(mouseEvent);
        }
        return mouseEvent;
    }

    public MouseEvent processMouseEntered(MouseEvent mouseEvent) {
        for (MouseListener mouseListener : this.mouseListeners) {
            mouseEvent = mouseListener.mouseEntered(mouseEvent);
        }
        return mouseEvent;
    }

    public MouseEvent processMouseExited(MouseEvent mouseEvent) {
        for (MouseListener mouseListener : this.mouseListeners) {
            mouseEvent = mouseListener.mouseExited(mouseEvent);
        }
        return mouseEvent;
    }

    public MouseEvent processMouseDragged(MouseEvent mouseEvent) {
        for (MouseListener mouseListener : this.mouseListeners) {
            mouseEvent = mouseListener.mouseDragged(mouseEvent);
        }
        return mouseEvent;
    }

    public MouseEvent processMouseMoved(MouseEvent mouseEvent) {
        for (MouseListener mouseListener : this.mouseListeners) {
            mouseEvent = mouseListener.mouseMoved(mouseEvent);
        }
        return mouseEvent;
    }

    public MouseWheelEvent processMouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        for (MouseWheelListener mouseWheelListener : this.mouseWheelListeners) {
            mouseWheelEvent = mouseWheelListener.mouseWheelMoved(mouseWheelEvent);
        }
        return mouseWheelEvent;
    }
}

