/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.input;

import java.awt.event.KeyEvent;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.inject.Singleton;
import net.runelite.client.input.KeyListener;

@Singleton
public class KeyManager {
    private final List<KeyListener> keyListeners = new CopyOnWriteArrayList<KeyListener>();

    public void registerKeyListener(KeyListener keyListener) {
        if (!this.keyListeners.contains(keyListener)) {
            this.keyListeners.add(keyListener);
        }
    }

    public void unregisterKeyListener(KeyListener keyListener) {
        this.keyListeners.remove(keyListener);
    }

    public void processKeyPressed(KeyEvent keyEvent) {
        for (KeyListener keyListener : this.keyListeners) {
            keyListener.keyPressed(keyEvent);
        }
    }

    public void processKeyReleased(KeyEvent keyEvent) {
        for (KeyListener keyListener : this.keyListeners) {
            keyListener.keyReleased(keyEvent);
        }
    }

    public void processKeyTyped(KeyEvent keyEvent) {
        for (KeyListener keyListener : this.keyListeners) {
            keyListener.keyTyped(keyEvent);
        }
    }
}

