/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.graphics;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.runelite.api.Client;
import net.runelite.api.MainBufferProvider;
import net.runelite.api.Model;
import net.runelite.api.NPC;
import net.runelite.api.NPCComposition;
import net.runelite.api.Perspective;
import net.runelite.api.Player;
import net.runelite.api.coords.LocalPoint;
import net.runelite.client.graphics.PixelDistanceAlpha;
import net.runelite.client.task.Schedule;

@Singleton
public class ModelOutlineRenderer {
    private final Client client;
    private boolean isReset;
    private boolean usedSinceLastCheck;
    private int imageWidth;
    private int imageHeight;
    private int clipX1;
    private int clipY1;
    private int clipX2;
    private int clipY2;
    private int[] visited;
    private int currentVisitedNumber = 0;
    private int[] projectedVerticesX;
    private int[] projectedVerticesY;
    private boolean[] projectedVerticesRenderable;
    private int[][] outlinePixels;
    private int[] outlinePixelsLengths;
    private int outlineArrayWidth;
    private List<List<PixelDistanceAlpha>> precomputedDistancePriorities;

    @Inject
    private ModelOutlineRenderer(Client client2) {
        this.client = client2;
        this.reset();
    }

    @Schedule(period=5L, unit=ChronoUnit.SECONDS)
    public void checkUsage() {
        if (!this.isReset && !this.usedSinceLastCheck) {
            this.reset();
        }
        this.usedSinceLastCheck = false;
    }

    private void reset() {
        this.visited = new int[0];
        this.projectedVerticesX = new int[0];
        this.projectedVerticesY = new int[0];
        this.projectedVerticesRenderable = new boolean[0];
        this.outlinePixels = new int[0][];
        this.outlinePixelsLengths = new int[0];
        this.precomputedDistancePriorities = new ArrayList<List<PixelDistanceAlpha>>(0);
        this.isReset = true;
    }

    private static int nextPowerOfTwo(int value) {
        --value;
        value |= value >> 1;
        value |= value >> 2;
        value |= value >> 4;
        value |= value >> 8;
        value |= value >> 16;
        return ++value;
    }

    private static boolean cullFace(int x1, int y1, int x2, int y2, int x3, int y3) {
        return (y2 - y1) * (x3 - x2) - (x2 - x1) * (y3 - y2) < 0;
    }

    private List<PixelDistanceAlpha> getPriorityList(int outlineWidth) {
        while (this.precomputedDistancePriorities.size() <= outlineWidth) {
            this.precomputedDistancePriorities.add(null);
        }
        if (this.precomputedDistancePriorities.get(outlineWidth) != null) {
            return this.precomputedDistancePriorities.get(outlineWidth);
        }
        ArrayList<PixelDistanceAlpha> ps = new ArrayList<PixelDistanceAlpha>();
        for (int x = 0; x <= outlineWidth; ++x) {
            for (int y = 0; y <= outlineWidth; ++y) {
                double dist;
                if (x == 0 && y == 0 || (dist = Math.sqrt(x * x + y * y)) > (double)outlineWidth) continue;
                int outerAlpha = outlineWidth == 1 ? 255 : (int)(255.0 * (dist - 1.0) / (double)(outlineWidth - 1));
                ps.add(new PixelDistanceAlpha(outerAlpha, x + y * this.outlineArrayWidth));
            }
        }
        ps.sort(Comparator.comparingDouble(PixelDistanceAlpha::getOuterAlpha));
        this.precomputedDistancePriorities.set(outlineWidth, ps);
        return ps;
    }

    private void ensureMinimumOutlineQueueSize(int distArrayPos, int additionalMinimumSize) {
        int minimumSize = this.outlinePixelsLengths[distArrayPos] + additionalMinimumSize;
        while (this.outlinePixels[distArrayPos].length < minimumSize) {
            int[] newArr = new int[ModelOutlineRenderer.nextPowerOfTwo(minimumSize)];
            System.arraycopy(this.outlinePixels[distArrayPos], 0, newArr, 0, this.outlinePixels[distArrayPos].length);
            this.outlinePixels[distArrayPos] = newArr;
        }
    }

    private void resetVisited(int pixelAmount) {
        if (this.visited.length < pixelAmount) {
            this.visited = new int[ModelOutlineRenderer.nextPowerOfTwo(pixelAmount)];
            this.currentVisitedNumber = 0;
        }
        ++this.currentVisitedNumber;
    }

    private void resetOutline(int outlineWidth) {
        this.outlineArrayWidth = outlineWidth + 2;
        int arraySizes = this.outlineArrayWidth * this.outlineArrayWidth;
        if (this.outlinePixels.length < arraySizes) {
            this.outlinePixels = new int[arraySizes][];
            this.outlinePixelsLengths = new int[arraySizes];
            for (int i = 0; i < arraySizes; ++i) {
                this.outlinePixels[i] = new int[4];
            }
        } else {
            for (int i = 0; i < arraySizes; ++i) {
                this.outlinePixelsLengths[i] = 0;
            }
        }
    }

    private void simulateHorizontalLineRasterizationForOutline(int pixelPos, int x1, int x2) {
        if (x2 > this.clipX2) {
            x2 = this.clipX2;
        }
        if (x1 < this.clipX1) {
            x1 = this.clipX1;
        }
        if (x1 >= x2) {
            return;
        }
        this.ensureMinimumOutlineQueueSize(1, 2);
        if (x2 < this.clipX2) {
            int n = this.outlinePixelsLengths[1];
            this.outlinePixelsLengths[1] = n + 1;
            this.outlinePixels[1][n] = pixelPos + x2;
        }
        if (x1 > this.clipX1) {
            int n = this.outlinePixelsLengths[1];
            this.outlinePixelsLengths[1] = n + 1;
            this.outlinePixels[1][n] = pixelPos + x1 - 1;
        }
        int xDist = x2 - x1 >> 2;
        pixelPos += x1;
        while (xDist-- > 0) {
            this.visited[pixelPos++] = this.currentVisitedNumber;
            this.visited[pixelPos++] = this.currentVisitedNumber;
            this.visited[pixelPos++] = this.currentVisitedNumber;
            this.visited[pixelPos++] = this.currentVisitedNumber;
        }
        xDist = x2 - x1 & 3;
        while (xDist-- > 0) {
            this.visited[pixelPos++] = this.currentVisitedNumber;
        }
    }

    private void outlineAroundHorizontalLine(int pixelPos, int x1, int x2, int x3, int x4) {
        int x;
        if (x1 < this.clipX1) {
            x1 = this.clipX1;
        }
        if (x2 < this.clipX1) {
            x2 = this.clipX1;
        }
        if (x3 < this.clipX1) {
            x3 = this.clipX1;
        }
        if (x4 < this.clipX1) {
            x4 = this.clipX1;
        }
        if (x1 > this.clipX2) {
            x1 = this.clipX2;
        }
        if (x2 > this.clipX2) {
            x2 = this.clipX2;
        }
        if (x3 > this.clipX2) {
            x3 = this.clipX2;
        }
        if (x4 > this.clipX2) {
            x4 = this.clipX2;
        }
        if (x1 < x3) {
            this.ensureMinimumOutlineQueueSize(this.outlineArrayWidth, x3 - x1);
            for (x = x1; x < x3; ++x) {
                int n = this.outlineArrayWidth;
                int n2 = this.outlinePixelsLengths[n];
                this.outlinePixelsLengths[n] = n2 + 1;
                this.outlinePixels[this.outlineArrayWidth][n2] = pixelPos - this.imageWidth + x;
            }
        } else {
            this.ensureMinimumOutlineQueueSize(this.outlineArrayWidth, x1 - x3);
            for (x = x3; x < x1; ++x) {
                int n = this.outlineArrayWidth;
                int n3 = this.outlinePixelsLengths[n];
                this.outlinePixelsLengths[n] = n3 + 1;
                this.outlinePixels[this.outlineArrayWidth][n3] = pixelPos + x;
            }
        }
        if (x2 < x4) {
            this.ensureMinimumOutlineQueueSize(this.outlineArrayWidth, x4 - x2);
            for (x = x2; x < x4; ++x) {
                int n = this.outlineArrayWidth;
                int n4 = this.outlinePixelsLengths[n];
                this.outlinePixelsLengths[n] = n4 + 1;
                this.outlinePixels[this.outlineArrayWidth][n4] = pixelPos + x;
            }
        } else {
            this.ensureMinimumOutlineQueueSize(this.outlineArrayWidth, x2 - x4);
            for (x = x4; x < x2; ++x) {
                int n = this.outlineArrayWidth;
                int n5 = this.outlinePixelsLengths[n];
                this.outlinePixelsLengths[n] = n5 + 1;
                this.outlinePixels[this.outlineArrayWidth][n5] = pixelPos - this.imageWidth + x;
            }
        }
    }

    private void simulateTriangleRasterizationForOutline(int x1, int y1, int x2, int y2, int x3, int y3) {
        int xp;
        int yp;
        if (y1 > y2) {
            yp = y1;
            xp = x1;
            y1 = y2;
            y2 = yp;
            x1 = x2;
            x2 = xp;
        }
        if (y2 > y3) {
            yp = y2;
            xp = x2;
            y2 = y3;
            y3 = yp;
            x2 = x3;
            x3 = xp;
        }
        if (y1 > y2) {
            yp = y1;
            xp = x1;
            y1 = y2;
            y2 = yp;
            x1 = x2;
            x2 = xp;
        }
        if (y1 > this.clipY2) {
            return;
        }
        int slope1 = 0;
        if (y1 != y2) {
            slope1 = (x2 - x1 << 14) / (y2 - y1);
        }
        int slope2 = 0;
        if (y3 != y2) {
            slope2 = (x3 - x2 << 14) / (y3 - y2);
        }
        int slope3 = 0;
        if (y1 != y3) {
            slope3 = (x1 - x3 << 14) / (y1 - y3);
        }
        if (y2 > this.clipY2) {
            y2 = this.clipY2;
        }
        if (y3 > this.clipY2) {
            y3 = this.clipY2;
        }
        if (y1 == y3 || y3 < 0) {
            return;
        }
        x2 <<= 14;
        x3 = x1 <<= 14;
        if (y1 < 0) {
            x3 -= y1 * slope3;
            x1 -= y1 * slope1;
            y1 = 0;
        }
        if (y2 < 0) {
            x2 -= slope2 * y2;
            y2 = 0;
        }
        int pixelPos = y1 * this.imageWidth;
        if (y1 != y2 && slope3 < slope1 || y1 == y2 && slope3 > slope2) {
            int currX2;
            int currX1;
            int prevX2;
            int prevX1;
            int height1 = y2 - y1;
            int height2 = y3 - y2;
            if (height1 <= 0) {
                prevX1 = x3 >> 14;
                prevX2 = x2 >> 14;
            } else {
                prevX1 = x3 >> 14;
                prevX2 = x1 >> 14;
            }
            this.outlineAroundHorizontalLine(pixelPos, prevX1, prevX2, prevX2, prevX2);
            while (height1-- > 0) {
                currX1 = x3 >> 14;
                currX2 = x1 >> 14;
                this.outlineAroundHorizontalLine(pixelPos, currX1, currX2, prevX1, prevX2);
                this.simulateHorizontalLineRasterizationForOutline(pixelPos, currX1, currX2);
                x3 += slope3;
                x1 += slope1;
                pixelPos += this.imageWidth;
                prevX1 = currX1;
                prevX2 = currX2;
            }
            while (height2-- > 0) {
                currX1 = x3 >> 14;
                currX2 = x2 >> 14;
                this.outlineAroundHorizontalLine(pixelPos, currX1, currX2, prevX1, prevX2);
                this.simulateHorizontalLineRasterizationForOutline(pixelPos, currX1, currX2);
                x3 += slope3;
                x2 += slope2;
                pixelPos += this.imageWidth;
                prevX1 = currX1;
                prevX2 = currX2;
            }
            this.outlineAroundHorizontalLine(pixelPos, prevX1, prevX1, prevX1, prevX2);
        } else {
            int currX2;
            int currX1;
            int prevX2;
            int prevX1;
            int height1 = y2 - y1;
            int height2 = y3 - y2;
            if (height1 <= 0) {
                prevX1 = x2 >> 14;
                prevX2 = x3 >> 14;
            } else {
                prevX1 = x1 >> 14;
                prevX2 = x3 >> 14;
            }
            this.outlineAroundHorizontalLine(pixelPos, prevX1, prevX2, prevX2, prevX2);
            while (height1-- > 0) {
                currX1 = x1 >> 14;
                currX2 = x3 >> 14;
                this.outlineAroundHorizontalLine(pixelPos, currX1, currX2, prevX1, prevX2);
                this.simulateHorizontalLineRasterizationForOutline(pixelPos, currX1, currX2);
                x1 += slope1;
                x3 += slope3;
                pixelPos += this.imageWidth;
                prevX1 = currX1;
                prevX2 = currX2;
            }
            while (height2-- > 0) {
                currX1 = x2 >> 14;
                currX2 = x3 >> 14;
                this.outlineAroundHorizontalLine(pixelPos, currX1, currX2, prevX1, prevX2);
                this.simulateHorizontalLineRasterizationForOutline(pixelPos, currX1, currX2);
                x3 += slope3;
                x2 += slope2;
                pixelPos += this.imageWidth;
                prevX1 = currX1;
                prevX2 = currX2;
            }
            this.outlineAroundHorizontalLine(pixelPos, prevX1, prevX1, prevX1, prevX2);
        }
    }

    private boolean projectVertices(Model model, int localX, int localY, int localZ, int vertexOrientation) {
        int cameraX = this.client.getCameraX();
        int cameraY = this.client.getCameraY();
        int cameraZ = this.client.getCameraZ();
        int cameraYaw = this.client.getCameraYaw();
        int cameraPitch = this.client.getCameraPitch();
        int scale = this.client.getScale();
        int orientationSin = Perspective.SINE[vertexOrientation];
        int orientationCos = Perspective.COSINE[vertexOrientation];
        int pitchSin = Perspective.SINE[cameraPitch];
        int pitchCos = Perspective.COSINE[cameraPitch];
        int yawSin = Perspective.SINE[cameraYaw];
        int yawCos = Perspective.COSINE[cameraYaw];
        int vertexCount = model.getVerticesCount();
        int[] verticesX = model.getVerticesX();
        int[] verticesY = model.getVerticesY();
        int[] verticesZ = model.getVerticesZ();
        boolean anyVisible = false;
        while (this.projectedVerticesX.length < vertexCount) {
            int newSize = ModelOutlineRenderer.nextPowerOfTwo(vertexCount);
            this.projectedVerticesX = new int[newSize];
            this.projectedVerticesY = new int[newSize];
            this.projectedVerticesRenderable = new boolean[newSize];
        }
        for (int i = 0; i < vertexCount; ++i) {
            int vx = verticesX[i];
            int vy = verticesZ[i];
            int vz = verticesY[i];
            int vh = vx * orientationCos + vy * orientationSin >> 16;
            vy = vy * orientationCos - vx * orientationSin >> 16;
            vx = vh;
            vx += localX;
            vy += localY;
            vz += localZ;
            vh = (vx -= cameraX) * yawCos + (vy -= cameraY) * yawSin >> 16;
            vy = vy * yawCos - vx * yawSin >> 16;
            vx = vh;
            vh = (vz -= cameraZ) * pitchCos - vy * pitchSin >> 16;
            vz = vz * pitchSin + vy * pitchCos >> 16;
            vy = vh;
            if (vz >= 50) {
                this.projectedVerticesX[i] = (this.clipX1 + this.clipX2) / 2 + vx * scale / vz;
                this.projectedVerticesY[i] = (this.clipY1 + this.clipY2) / 2 + vy * scale / vz;
                this.projectedVerticesRenderable[i] = true;
                anyVisible |= this.projectedVerticesX[i] >= this.clipX1 && this.projectedVerticesX[i] < this.clipX2 && this.projectedVerticesY[i] >= this.clipY1 && this.projectedVerticesY[i] < this.clipY2;
                continue;
            }
            this.projectedVerticesRenderable[i] = false;
        }
        return anyVisible;
    }

    private void simulateModelRasterizationForOutline(Model model) {
        int triangleCount = model.getTrianglesCount();
        int[] indices1 = model.getTrianglesX();
        int[] indices2 = model.getTrianglesY();
        int[] indices3 = model.getTrianglesZ();
        byte[] triangleTransparencies = model.getTriangleTransparencies();
        for (int i = 0; i < triangleCount; ++i) {
            int v3y;
            int index3;
            int v3x;
            int v2y;
            int index2;
            int v2x;
            int v1y;
            int index1;
            int v1x;
            if (!this.projectedVerticesRenderable[indices1[i]] || !this.projectedVerticesRenderable[indices2[i]] || !this.projectedVerticesRenderable[indices3[i]] || triangleTransparencies != null && (triangleTransparencies[i] & 0xFF) >= 254 || ModelOutlineRenderer.cullFace(v1x = this.projectedVerticesX[index1 = indices1[i]], v1y = this.projectedVerticesY[index1], v2x = this.projectedVerticesX[index2 = indices2[i]], v2y = this.projectedVerticesY[index2], v3x = this.projectedVerticesX[index3 = indices3[i]], v3y = this.projectedVerticesY[index3])) continue;
            this.simulateTriangleRasterizationForOutline(v1x, v1y, v2x, v2y, v3x, v3y);
        }
    }

    private void renderOutline(BufferedImage image, int outlineWidth, Color innerColor, Color outerColor) {
        int[] imageData = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        List<PixelDistanceAlpha> ps = this.getPriorityList(outlineWidth);
        for (PixelDistanceAlpha p : ps) {
            int y;
            int x;
            int pixelPos;
            int i2;
            int alpha;
            int color;
            if (outlineWidth == 1) {
                color = innerColor.getRed() + outerColor.getRed() << 15 | innerColor.getGreen() + outerColor.getGreen() << 7 | innerColor.getBlue() + outerColor.getBlue() >> 1;
                alpha = innerColor.getAlpha() + outerColor.getAlpha() >> 1;
            } else {
                int outerAlphaFraction;
                int outerAlpha = p.getOuterAlpha();
                int innerAlpha = 255 - outerAlpha;
                int innerAlphaFraction = innerAlpha * innerColor.getAlpha() / 255;
                alpha = innerAlphaFraction + (outerAlphaFraction = outerAlpha * outerColor.getAlpha() / 255);
                color = alpha != 0 ? (innerColor.getRed() * innerAlphaFraction + outerColor.getRed() * outerAlphaFraction) / alpha << 16 | (innerColor.getGreen() * innerAlphaFraction + outerColor.getGreen() * outerAlphaFraction) / alpha << 8 | (innerColor.getBlue() * innerAlphaFraction + outerColor.getBlue() * outerAlphaFraction) / alpha : 0;
            }
            int distArrayPos = p.getDistArrayPos();
            int nextDistArrayPosY = distArrayPos + this.outlineArrayWidth;
            int nextDistArrayPosX = distArrayPos + 1;
            this.ensureMinimumOutlineQueueSize(nextDistArrayPosX, this.outlinePixelsLengths[distArrayPos] * 2);
            this.ensureMinimumOutlineQueueSize(nextDistArrayPosY, this.outlinePixelsLengths[distArrayPos] * 2);
            if (alpha == 255) {
                if (outlineWidth == 1) {
                    for (i2 = 0; i2 < this.outlinePixelsLengths[distArrayPos]; ++i2) {
                        pixelPos = this.outlinePixels[distArrayPos][i2];
                        x = pixelPos % this.imageWidth;
                        y = pixelPos / this.imageWidth;
                        if (x < this.clipX1 || x >= this.clipX2 || y < this.clipY1 || y >= this.clipY2 || this.visited[pixelPos] == this.currentVisitedNumber) continue;
                        imageData[pixelPos] = color;
                    }
                    continue;
                }
                for (i2 = 0; i2 < this.outlinePixelsLengths[distArrayPos]; ++i2) {
                    pixelPos = this.outlinePixels[distArrayPos][i2];
                    x = pixelPos % this.imageWidth;
                    y = pixelPos / this.imageWidth;
                    if (x < this.clipX1 || x >= this.clipX2 || y < this.clipY1 || y >= this.clipY2 || this.visited[pixelPos] == this.currentVisitedNumber) continue;
                    this.visited[pixelPos] = this.currentVisitedNumber;
                    imageData[pixelPos] = color;
                    if (pixelPos % this.imageWidth != 0) {
                        int n = nextDistArrayPosX;
                        int n2 = this.outlinePixelsLengths[n];
                        this.outlinePixelsLengths[n] = n2 + 1;
                        this.outlinePixels[nextDistArrayPosX][n2] = pixelPos - 1;
                    }
                    if ((pixelPos + 1) % this.imageWidth != 0) {
                        int n = nextDistArrayPosX;
                        int n3 = this.outlinePixelsLengths[n];
                        this.outlinePixelsLengths[n] = n3 + 1;
                        this.outlinePixels[nextDistArrayPosX][n3] = pixelPos + 1;
                    }
                    int n = nextDistArrayPosY;
                    int n4 = this.outlinePixelsLengths[n];
                    this.outlinePixelsLengths[n] = n4 + 1;
                    this.outlinePixels[nextDistArrayPosY][n4] = pixelPos - this.imageWidth;
                    int n5 = nextDistArrayPosY;
                    int n6 = this.outlinePixelsLengths[n5];
                    this.outlinePixelsLengths[n5] = n6 + 1;
                    this.outlinePixels[nextDistArrayPosY][n6] = pixelPos + this.imageWidth;
                }
                continue;
            }
            for (i2 = 0; i2 < this.outlinePixelsLengths[distArrayPos]; ++i2) {
                pixelPos = this.outlinePixels[distArrayPos][i2];
                x = pixelPos % this.imageWidth;
                y = pixelPos / this.imageWidth;
                if (x < this.clipX1 || x >= this.clipX2 || y < this.clipY1 || y >= this.clipY2 || this.visited[pixelPos] == this.currentVisitedNumber) continue;
                this.visited[pixelPos] = this.currentVisitedNumber;
                imageData[pixelPos] = (((color & 0xFF0000) * alpha + (imageData[pixelPos] & 0xFF0000) * (255 - alpha)) / 255 & 0xFF0000) + (((color & 0xFF00) * alpha + (imageData[pixelPos] & 0xFF00) * (255 - alpha)) / 255 & 0xFF00) + (((color & 0xFF) * alpha + (imageData[pixelPos] & 0xFF) * (255 - alpha)) / 255 & 0xFF);
                if (pixelPos % this.imageWidth != 0) {
                    int n = nextDistArrayPosX;
                    int n7 = this.outlinePixelsLengths[n];
                    this.outlinePixelsLengths[n] = n7 + 1;
                    this.outlinePixels[nextDistArrayPosX][n7] = pixelPos - 1;
                }
                if ((pixelPos + 1) % this.imageWidth != 0) {
                    int n = nextDistArrayPosX;
                    int n8 = this.outlinePixelsLengths[n];
                    this.outlinePixelsLengths[n] = n8 + 1;
                    this.outlinePixels[nextDistArrayPosX][n8] = pixelPos + 1;
                }
                int n = nextDistArrayPosY;
                int n9 = this.outlinePixelsLengths[n];
                this.outlinePixelsLengths[n] = n9 + 1;
                this.outlinePixels[nextDistArrayPosY][n9] = pixelPos - this.imageWidth;
                int n10 = nextDistArrayPosY;
                int n11 = this.outlinePixelsLengths[n10];
                this.outlinePixelsLengths[n10] = n11 + 1;
                this.outlinePixels[nextDistArrayPosY][n11] = pixelPos + this.imageWidth;
            }
        }
    }

    private void drawModelOutline(Model model, int localX, int localY, int localZ, int orientation, int outlineWidth, Color innerColor, Color outerColor) {
        if (outlineWidth <= 0) {
            return;
        }
        this.isReset = false;
        this.usedSinceLastCheck = true;
        MainBufferProvider bufferProvider = (MainBufferProvider)((Object)this.client.getBufferProvider());
        BufferedImage image = (BufferedImage)bufferProvider.getImage();
        this.clipX1 = this.client.getViewportXOffset();
        this.clipY1 = this.client.getViewportYOffset();
        this.clipX2 = this.client.getViewportWidth() + this.clipX1;
        this.clipY2 = this.client.getViewportHeight() + this.clipY1;
        this.imageWidth = image.getWidth();
        this.imageHeight = image.getHeight();
        int pixelAmount = this.imageWidth * this.imageHeight;
        this.resetVisited(pixelAmount);
        this.resetOutline(outlineWidth);
        if (!this.projectVertices(model, localX, localY, localZ, orientation)) {
            return;
        }
        this.simulateModelRasterizationForOutline(model);
        this.renderOutline(image, outlineWidth, innerColor, outerColor);
    }

    public void drawOutline(NPC npc, int outlineWidth, Color color) {
        this.drawOutline(npc, outlineWidth, color, color);
    }

    public void drawOutline(NPC npc, int outlineWidth, Color innerColor, Color outerColor) {
        LocalPoint lp;
        int size = 1;
        NPCComposition composition = npc.getTransformedComposition();
        if (composition != null) {
            size = composition.getSize();
        }
        if ((lp = npc.getLocalLocation()) != null) {
            int northEastX = lp.getX() + 128 * (size - 1) / 2;
            int northEastY = lp.getY() + 128 * (size - 1) / 2;
            LocalPoint northEastLp = new LocalPoint(northEastX, northEastY);
            this.drawModelOutline(npc.getModel(), lp.getX(), lp.getY(), Perspective.getTileHeight(this.client, northEastLp, this.client.getPlane()), npc.getOrientation(), outlineWidth, innerColor, outerColor);
        }
    }

    public void drawOutline(Player player, int outlineWidth, Color color) {
        this.drawOutline(player, outlineWidth, color, color);
    }

    public void drawOutline(Player player, int outlineWidth, Color innerColor, Color outerColor) {
        LocalPoint lp = player.getLocalLocation();
        if (lp != null) {
            this.drawModelOutline(player.getModel(), lp.getX(), lp.getY(), Perspective.getTileHeight(this.client, lp, this.client.getPlane()), player.getOrientation(), outlineWidth, innerColor, outerColor);
        }
    }
}

