/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.game;

import com.google.common.collect.ImmutableMap;

public enum UntradeableItemMapping {
    MARK_OF_GRACE(11849, 10, 12640),
    GRACEFUL_HOOD(11850, 28, 11849),
    GRACEFUL_TOP(11854, 44, 11849),
    GRACEFUL_LEGS(11856, 48, 11849),
    GRACEFUL_GLOVES(11858, 24, 11849),
    GRACEFUL_BOOTS(11860, 32, 11849),
    GRACEFUL_CAPE(11852, 32, 11849),
    GOLDEN_NUGGET(12012, 10, 1761),
    PROSPECTOR_HELMET(12013, 32, 12012),
    PROSPECTOR_JACKET(12014, 48, 12012),
    PROSPECTOR_LEGS(12015, 40, 12012),
    PROSPECTOR_BOOTS(12016, 24, 12012);

    private static final ImmutableMap<Integer, UntradeableItemMapping> UNTRADEABLE_RECLAIM_MAP;
    private final int itemID;
    private final int quantity;
    private final int priceID;

    public static UntradeableItemMapping map(int itemId) {
        return UNTRADEABLE_RECLAIM_MAP.get(itemId);
    }

    public int getItemID() {
        return this.itemID;
    }

    public int getQuantity() {
        return this.quantity;
    }

    public int getPriceID() {
        return this.priceID;
    }

    private UntradeableItemMapping(int itemID, int quantity, int priceID) {
        this.itemID = itemID;
        this.quantity = quantity;
        this.priceID = priceID;
    }

    static {
        ImmutableMap.Builder<Integer, UntradeableItemMapping> map = ImmutableMap.builder();
        for (UntradeableItemMapping p : UntradeableItemMapping.values()) {
            map.put(p.getItemID(), p);
        }
        UNTRADEABLE_RECLAIM_MAP = map.build();
    }
}

