/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.game;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.inject.Inject;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.inject.Singleton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.SpritePixels;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.game.SpriteOverride;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SpriteManager {
    private static final Logger log = LoggerFactory.getLogger(SpriteManager.class);
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    public Cache<Long, BufferedImage> cache = CacheBuilder.newBuilder().maximumSize(128L).expireAfterAccess(1L, TimeUnit.HOURS).build();

    @Nullable
    public BufferedImage getSprite(int archive, int file) {
        assert (this.client.isClientThread());
        if (this.client.getGameState().ordinal() < GameState.LOGIN_SCREEN.ordinal()) {
            return null;
        }
        Long key = (long)archive << 32 | (long)file;
        BufferedImage cached = this.cache.getIfPresent(key);
        if (cached != null) {
            return cached;
        }
        SpritePixels[] sp = this.client.getSprites(this.client.getIndexSprites(), archive, 0);
        if (sp == null || file >= sp.length) {
            return null;
        }
        BufferedImage img = sp[file].toBufferedImage();
        this.cache.put(key, img);
        return img;
    }

    public void getSpriteAsync(int archive, int file, Consumer<BufferedImage> user) {
        BufferedImage cached = this.cache.getIfPresent((long)archive << 32 | (long)file);
        if (cached != null) {
            user.accept(cached);
            return;
        }
        this.clientThread.invoke(() -> {
            BufferedImage img = this.getSprite(archive, file);
            if (img == null) {
                return false;
            }
            user.accept(img);
            return true;
        });
    }

    public void addSpriteTo(JButton c, int archive, int file) {
        this.getSpriteAsync(archive, file, img -> SwingUtilities.invokeLater(() -> c.setIcon(new ImageIcon((Image)img))));
    }

    public void addSpriteTo(JLabel c, int archive, int file) {
        this.getSpriteAsync(archive, file, img -> SwingUtilities.invokeLater(() -> c.setIcon(new ImageIcon((Image)img))));
    }

    public void addSpriteOverrides(SpriteOverride[] add) {
        if (add.length <= 0) {
            return;
        }
        this.clientThread.invokeLater(() -> {
            Map<Integer, SpritePixels> overrides = this.client.getSpriteOverrides();
            Class<?> owner = add[0].getClass();
            for (SpriteOverride o : add) {
                BufferedImage image = ImageUtil.getResourceStreamFromClass(owner, o.getFileName());
                SpritePixels sp = ImageUtil.getImageSpritePixels(image, this.client);
                overrides.put(o.getSpriteId(), sp);
            }
        });
    }

    public void removeSpriteOverrides(SpriteOverride[] remove) {
        this.clientThread.invokeLater(() -> {
            Map<Integer, SpritePixels> overrides = this.client.getSpriteOverrides();
            for (SpriteOverride o : remove) {
                overrides.remove(o.getSpriteId());
            }
        });
    }
}

