/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.game;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Collections;

public enum ItemMapping {
    ITEM_AHRIMS_HOOD(4708, 4859, 4858, 4857, 4856),
    ITEM_AHRIMS_ROBETOP(4712, 4871, 4870, 4869, 4868),
    ITEM_AHRIMS_ROBEBOTTOM(4714, 4877, 4876, 4875, 4874),
    ITEM_AHRIMS_STAFF(4710, 4865, 4864, 4863, 4862),
    ITEM_KARILS_COIF(4732, 4931, 4930, 4929, 4928),
    ITEM_KARILS_LEATHERTOP(4736, 4943, 4942, 4941, 4940),
    ITEM_KARILS_LEATHERSKIRT(4738, 4949, 4948, 4947, 4946),
    ITEM_KARILS_CROSSBOW(4734, 4937, 4936, 4935, 4934),
    ITEM_DHAROKS_HELM(4716, 4883, 4882, 4881, 4880),
    ITEM_DHAROKS_PLATEBODY(4720, 4895, 4894, 4893, 4892),
    ITEM_DHAROKS_PLATELEGS(4722, 4901, 4900, 4899, 4898),
    ITEM_DHARKS_GREATEAXE(4718, 4889, 4888, 4887, 4886),
    ITEM_GUTHANS_HELM(4724, 4907, 4906, 4905, 4904),
    ITEM_GUTHANS_PLATEBODY(4728, 4919, 4918, 4917, 4916),
    ITEM_GUTHANS_CHAINSKIRT(4730, 4925, 4924, 4923, 4922),
    ITEM_GUTHANS_WARSPEAR(4726, 4913, 4912, 4911, 4910),
    ITEM_TORAGS_HELM(4745, 4955, 4954, 4953, 4952),
    ITEM_TORAGS_PLATEBODY(4749, 4967, 4966, 4965, 4964),
    ITEM_TORAGS_PLATELEGS(4751, 4973, 4972, 4971, 4970),
    ITEM_TORAGS_HAMMERS(4747, 4961, 4960, 4959, 4958),
    ITEM_VERACS_HELM(4753, 4979, 4978, 4977, 4976),
    ITEM_VERACS_BRASSARD(4757, 4991, 4990, 4989, 4988),
    ITEM_VERACS_PLATESKIRT(4759, 4997, 4996, 4995, 4994),
    ITEM_VERACS_FLAIL(4755, 4985, 4984, 4983, 4982),
    ITEM_DRAGON_SCIMITAR(4587, 20000),
    ITEM_DRAGON_SCIMITAR_ORNAMENT_KIT(20002, 20000),
    ITEM_DRAGON_DEFENDER(20143, 19722),
    ITEM_DRAGON_PICKAXE(11920, 12797),
    ITEM_DRAGON_KITESHIELD(21895, 22244),
    ITEM_DRAGON_KITESHIELD_ORNAMENT_KIT(22239, 22244),
    ITEM_DRAGON_FULL_HELM(11335, 12417),
    ITEM_DRAGON_FULL_HELM_ORNAMENT_KIT(12538, 12417),
    ITEM_DRAGON_CHAINBODY(3140, 12414),
    ITEM_DRAGON_CHAINBODY_ORNAMENT_KIT(12534, 12414),
    ITEM_DRAGON_PLATEBODY(21892, 22242),
    ITEM_DRAGON_PLATEBODY_ORNAMENT_KIT(22236, 22242),
    ITEM_DRAGON_PLATESKIRT(4585, 12416),
    ITEM_DRAGON_SKIRT_ORNAMENT_KIT(12536, 12416),
    ITEM_DRAGON_PLATELEGS(4087, 12415),
    ITEM_DRAGON_LEGS_ORNAMENT_KIT(12536, 12415),
    ITEM_DRAGON_SQ_SHIELD(1187, 12418),
    ITEM_DRAGON_SQ_SHIELD_ORNAMENT_KIT(12532, 12418),
    ITEM_DRAGON_BOOTS(11840, 22234),
    ITEM_DRAGON_BOOTS_ORNAMENT_KIT(22231, 22234),
    ITEM_ARMADYL_GODSWORD(11802, 20368),
    ITEM_ARMADYL_GODSWORD_ORNAMENT_KIT(20068, 20368),
    ITEM_BANDOS_GODSWORD(11804, 20370),
    ITEM_BANDOS_GODSWORD_ORNAMENT_KIT(20071, 20370),
    ITEM_ZAMORAK_GODSWORD(11808, 20374),
    ITEM_ZAMORAK_GODSWORD_ORNAMENT_KIT(20077, 20374),
    ITEM_SARADOMIN_GODSWORD(11806, 20372),
    ITEM_SARADOMIN_GODSWORD_ORNAMENT_KIT(20074, 20372),
    ITEM_AMULET_OF_TORTURE(19553, 20366),
    ITEM_TORTURE_ORNAMENT_KIT(20062, 20366),
    ITEM_NECKLACE_OF_ANGUISH(19547, 22249),
    ITEM_ANGUISH_ORNAMENT_KIT(22246, 22249),
    ITEM_OCCULT_NECKLACE(12002, 19720),
    ITEM_OCCULT_ORNAMENT_KIT(20065, 19720),
    ITE_AMULET_OF_FURY(6585, 12436),
    ITE_FURY_ORNAMENT_KIT(12526, 12436),
    ITEM_ENSOULED_GOBLIN_HEAD(13448, 13447),
    ITEM_ENSOULED_MONKEY_HEAD(13451, 13450),
    ITEM_ENSOULED_IMP_HEAD(13454, 13453),
    ITEM_ENSOULED_MINOTAUR_HEAD(13457, 13456),
    ITEM_ENSOULED_SCORPION_HEAD(13460, 13459),
    ITEM_ENSOULED_BEAR_HEAD(13463, 13462),
    ITEM_ENSOULED_UNICORN_HEAD(13466, 13465),
    ITEM_ENSOULED_DOG_HEAD(13469, 13468),
    ITEM_ENSOULED_CHAOS_DRUID_HEAD(13472, 13471),
    ITEM_ENSOULED_GIANT_HEAD(13475, 13474),
    ITEM_ENSOULED_OGRE_HEAD(13478, 13477),
    ITEM_ENSOULED_ELF_HEAD(13481, 13480),
    ITEM_ENSOULED_TROLL_HEAD(13484, 13483),
    ITEM_ENSOULED_HORROR_HEAD(13487, 13486),
    ITEM_ENSOULED_KALPHITE_HEAD(13490, 13489),
    ITEM_ENSOULED_DAGANNOTH_HEAD(13493, 13492),
    ITEM_ENSOULED_BLOODVELD_HEAD(13496, 13495),
    ITEM_ENSOULED_TZHAAR_HEAD(13499, 13498),
    ITEM_ENSOULED_DEMON_HEAD(13502, 13501),
    ITEM_ENSOULED_AVIANSIE_HEAD(13505, 13504),
    ITEM_ENSOULED_ABYSSAL_HEAD(13508, 13507),
    ITEM_ENSOULED_DRAGON_HEAD(13511, 13510),
    ITEM_BERSERKER_RING(6737, 11773),
    ITEM_SEERS_RING(6731, 11770),
    ITEM_WARRIOR_RING(6735, 11772),
    ITEM_ARCHERS_RING(6733, 11771),
    ITEM_TREASONOUS_RING(12605, 12692),
    ITEM_TYRANNICAL_RING(12603, 12691),
    ITEM_RING_OF_THE_GODS(12601, 13202),
    ITEM_RING_OF_SUFFERING(19550, 19710, 20655, 20657),
    ITEM_GRANITE_RING(21739, 21752),
    ITEM_GRANITE_MAUL(4153, 12848),
    ITEM_MAGIC_SHORTBOW(861, 12788),
    ITEM_SARADOMINS_BLESSED_SWORD(12804, 12809),
    ITEM_RING_OF_WEALTH(2572, 12785, 11988, 20790, 11986, 20789, 11984, 20788, 11982, 20787, 20786),
    ITEM_AMULET_OF_GLORY(1704, 1706, 1708, 1710, 11976),
    ITEM_AMULET_OF_GLORY_T(10362, 10360, 10358, 10356, 11966),
    ITEM_SKILLS_NECKLACE(11113, 11111, 11109, 11107, 11970),
    ITEM_RING_OF_DUELING(2552, 2566, 2564, 2562, 2560, 2558, 2556, 2554),
    ITEM_GAMES_NECKLACE(3853, 3867, 3865, 3863, 3861, 3859, 3857, 3855),
    ITEM_ABYSSAL_WHIP(4151, 12773, 12774),
    ITEM_KRAKEN_TENTACLE(12004, 12006),
    ITEM_TRIDENT_OF_THE_SEAS(11908, 11907),
    ITEM_TRIDENT_OF_THE_SEAS_E(22290, 22288),
    ITEM_TRIDENT_OF_THE_SWAMP(12900, 12899),
    ITEM_TRIDENT_OF_THE_SWAMP_E(22294, 22292),
    ITEM_TOXIC_BLOWPIPE(12924, 12926),
    ITEM_TOXIC_STAFF_OFF_THE_DEAD(12902, 12904),
    ITEM_SERPENTINE_HELM(12929, 12931, 13196, 13197, 13198, 13199),
    ITEM_DRAGONFIRE_SHIELD(11284, 11283),
    ITEM_DRAGONFIRE_WARD(22003, 22002),
    ITEM_ANCIENT_WYVERN_SHIELD(21634, 21633),
    ITEM_SANGUINESTI_STAFF(22481, 22323),
    ITEM_SCYTHE_OF_VITUR(22486, 22325),
    ITEM_TOME_OF_FIRE(20716, 20714),
    ITEM_CRAWS_BOW(22547, 22550),
    ITEM_VIGGORAS_CHAINMACE(22542, 22545),
    ITEM_THAMMARONS_SCEPTRE(22552, 22555),
    ITEM_INFINITY_TOP(6916, 10605, 20574, 12458, 12420),
    ITEM_INFINITY_TOP_LIGHT_COLOUR_KIT(12530, 12420),
    ITEM_INFINITY_TOP_DARK_COLOUR_KIT(12528, 12458),
    ITEM_INFINITY_BOTTOMS(6924, 20575, 12459, 12421),
    ITEM_INFINITY_BOTTOMS_LIGHT_COLOUR_KIT(12530, 12421),
    ITEM_INFINITY_BOTTOMS_DARK_COLOUR_KIT(12528, 12459),
    ITEM_INFINITY_HAT(6918, 12457, 12419),
    ITEM_INFINITY_HAT_LIGHT_COLOUR_KIT(12530, 12419),
    ITEM_INFINITY_HAT_DARK_COLOUR_KIT(12528, 12457),
    ITEM_DARK_BOW(11235, 12765, 12766, 12767, 12768, 20408),
    ITEM_ODIUM_WARD(11926, 12807),
    ITEM_MALEDICTION_WARD(11924, 12806),
    ITEM_STEAM_BATTLESTAFF(11787, 12795),
    ITEM_LAVA_BATTLESTAFF(3053, 21198),
    ITEM_BLACK_MASK(8921, 11784, 8919, 11783, 8917, 11782, 8915, 11781, 8913, 11780, 8911, 11779, 8909, 11778, 8907, 11777, 8905, 11776, 8903, 11775, 11774, 11864, 11865, 19639, 19641, 21264, 21266, 19647, 19649, 19643, 19645, 21888, 21890, 23073, 23075),
    ITEM_PHARAOHS_SCEPTRE_1(9050, 9048),
    ITEM_PHARAOHS_SCEPTRE_2(9050, 9046),
    ITEM_PHARAOHS_SCEPTRE_4(9050, 13078),
    ITEM_PHARAOHS_SCEPTRE_5(9050, 13077),
    ITEM_PHARAOHS_SCEPTRE_6(9050, 13076),
    ITEM_PHARAOHS_SCEPTRE_7(9050, 13075),
    ITEM_PHARAOHS_SCEPTRE_8(9050, 13074),
    ITEM_HYDRA_LEATHER(22983, 22981),
    ITEM_HYDRA_TAIL(22988, 22986),
    ITEM_DRAGONBONE_NECKLACE(22111, 22986),
    ITEM_BOTTOMLESS_COMPOST_BUCKET(22994, 22997);

    private static final Multimap<Integer, Integer> MAPPINGS;
    private final int tradeableItem;
    private final int[] untradableItems;

    private ItemMapping(int tradeableItem, int ... untradableItems) {
        this.tradeableItem = tradeableItem;
        this.untradableItems = untradableItems;
    }

    public static Collection<Integer> map(int itemId) {
        Collection<Integer> mapping = MAPPINGS.get(itemId);
        if (mapping == null || mapping.isEmpty()) {
            return Collections.singleton(itemId);
        }
        return mapping;
    }

    public static int mapFirst(int itemId) {
        Collection<Integer> mapping = MAPPINGS.get(itemId);
        if (mapping == null || mapping.isEmpty()) {
            return itemId;
        }
        return mapping.iterator().next();
    }

    static {
        MAPPINGS = HashMultimap.create();
        for (ItemMapping item : ItemMapping.values()) {
            for (int itemId : item.untradableItems) {
                MAPPINGS.put(itemId, item.tradeableItem);
            }
        }
    }
}

