/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.game;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.LoadingCache;
import java.io.IOException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.game.HiscoreLoader;
import net.runelite.http.api.hiscore.HiscoreClient;
import net.runelite.http.api.hiscore.HiscoreEndpoint;
import net.runelite.http.api.hiscore.HiscoreResult;

@Singleton
public class HiscoreManager {
    static final HiscoreResult EMPTY = new HiscoreResult();
    static final HiscoreResult NONE = new HiscoreResult();
    private final HiscoreClient hiscoreClient = new HiscoreClient();
    private final LoadingCache<HiscoreKey, HiscoreResult> hiscoreCache;

    @Inject
    public HiscoreManager(Client client2, ScheduledExecutorService executor, ClientThread clientThread) {
        this.hiscoreCache = CacheBuilder.newBuilder().maximumSize(128L).expireAfterWrite(1L, TimeUnit.HOURS).build(new HiscoreLoader(executor, this.hiscoreClient));
    }

    public HiscoreResult lookup(String username, HiscoreEndpoint endpoint) throws IOException {
        HiscoreKey hiscoreKey = new HiscoreKey(username, endpoint);
        HiscoreResult hiscoreResult = (HiscoreResult)this.hiscoreCache.getIfPresent(hiscoreKey);
        if (hiscoreResult != null && hiscoreResult != EMPTY) {
            return hiscoreResult == NONE ? null : hiscoreResult;
        }
        hiscoreResult = this.hiscoreClient.lookup(username, endpoint);
        if (hiscoreResult == null) {
            this.hiscoreCache.put(hiscoreKey, NONE);
            return null;
        }
        this.hiscoreCache.put(hiscoreKey, hiscoreResult);
        return hiscoreResult;
    }

    public HiscoreResult lookupAsync(String username, HiscoreEndpoint endpoint) {
        HiscoreKey hiscoreKey = new HiscoreKey(username, endpoint);
        HiscoreResult hiscoreResult = (HiscoreResult)this.hiscoreCache.getIfPresent(hiscoreKey);
        if (hiscoreResult != null && hiscoreResult != EMPTY) {
            return hiscoreResult == NONE ? null : hiscoreResult;
        }
        this.hiscoreCache.refresh(hiscoreKey);
        return null;
    }

    static class HiscoreKey {
        String username;
        HiscoreEndpoint type;

        public HiscoreKey(String username, HiscoreEndpoint type) {
            this.username = username;
            this.type = type;
        }

        public String getUsername() {
            return this.username;
        }

        public HiscoreEndpoint getType() {
            return this.type;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public void setType(HiscoreEndpoint type) {
            this.type = type;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof HiscoreKey)) {
                return false;
            }
            HiscoreKey other = (HiscoreKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            HiscoreEndpoint this$type = this.getType();
            HiscoreEndpoint other$type = other.getType();
            return !(this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type));
        }

        protected boolean canEqual(Object other) {
            return other instanceof HiscoreKey;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            HiscoreEndpoint $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            return result;
        }

        public String toString() {
            return "HiscoreManager.HiscoreKey(username=" + this.getUsername() + ", type=" + this.getType() + ")";
        }
    }
}

