/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.game;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.ClanMember;
import net.runelite.api.ClanMemberRank;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.IndexedSprite;
import net.runelite.api.events.ClanChanged;
import net.runelite.api.events.GameStateChanged;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.SpriteManager;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.Text;

@Singleton
public class ClanManager {
    private static final int[] CLANCHAT_IMAGES = new int[]{1004, 1012, 1011, 1010, 1009, 1008, 1007, 1006, 1005};
    private static final Dimension CLANCHAT_IMAGE_DIMENSION = new Dimension(11, 11);
    private static final Color CLANCHAT_IMAGE_OUTLINE_COLOR = new Color(33, 33, 33);
    private final Client client;
    private final SpriteManager spriteManager;
    private final BufferedImage[] clanChatImages = new BufferedImage[CLANCHAT_IMAGES.length];
    private final LoadingCache<String, ClanMemberRank> clanRanksCache = CacheBuilder.newBuilder().maximumSize(100L).expireAfterWrite(1L, TimeUnit.MINUTES).build(new CacheLoader<String, ClanMemberRank>(){

        @Override
        public ClanMemberRank load(@Nonnull String key) {
            ClanMember[] clanMembersArr = ClanManager.this.client.getClanMembers();
            if (clanMembersArr == null || clanMembersArr.length == 0) {
                return ClanMemberRank.UNRANKED;
            }
            return Arrays.stream(clanMembersArr).filter(Objects::nonNull).filter(clanMember -> ClanManager.sanitize(clanMember.getUsername()).equals(ClanManager.sanitize(key))).map(ClanMember::getRank).findAny().orElse(ClanMemberRank.UNRANKED);
        }
    });
    private int modIconsLength;

    @Inject
    private ClanManager(Client client2, SpriteManager spriteManager) {
        this.client = client2;
        this.spriteManager = spriteManager;
    }

    public ClanMemberRank getRank(String playerName) {
        return this.clanRanksCache.getUnchecked(playerName);
    }

    public BufferedImage getClanImage(ClanMemberRank clanMemberRank) {
        if (clanMemberRank == ClanMemberRank.UNRANKED) {
            return null;
        }
        return this.clanChatImages[clanMemberRank.ordinal() - 1];
    }

    public int getIconNumber(ClanMemberRank clanMemberRank) {
        return this.modIconsLength - CLANCHAT_IMAGES.length + clanMemberRank.ordinal() - 1;
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (gameStateChanged.getGameState() == GameState.LOGGED_IN && this.modIconsLength == 0) {
            this.loadClanChatIcons();
        }
    }

    @Subscribe
    public void onClanChanged(ClanChanged clanChanged) {
        this.clanRanksCache.invalidateAll();
    }

    private void loadClanChatIcons() {
        IndexedSprite[] modIcons = this.client.getModIcons();
        IndexedSprite[] newModIcons = Arrays.copyOf(modIcons, modIcons.length + CLANCHAT_IMAGES.length);
        int curPosition = newModIcons.length - CLANCHAT_IMAGES.length;
        int i = 0;
        while (i < CLANCHAT_IMAGES.length) {
            int resource = CLANCHAT_IMAGES[i];
            BufferedImage sprite = this.spriteManager.getSprite(resource, 0);
            if (sprite != null) {
                BufferedImage bufferedImage = ClanManager.clanChatImageFromSprite(sprite);
                this.clanChatImages[i] = ClanManager.rgbaToIndexedBufferedImage(bufferedImage);
                newModIcons[curPosition] = ClanManager.createIndexedSprite(this.client, this.clanChatImages[i]);
            }
            ++i;
            ++curPosition;
        }
        this.client.setModIcons(newModIcons);
        this.modIconsLength = newModIcons.length;
    }

    private static String sanitize(String lookup) {
        String cleaned = Text.removeTags(lookup);
        return cleaned.replace('\u00a0', ' ');
    }

    private static IndexedSprite createIndexedSprite(Client client2, BufferedImage bufferedImage) {
        IndexColorModel indexedCM = (IndexColorModel)bufferedImage.getColorModel();
        int width = bufferedImage.getWidth();
        int height = bufferedImage.getHeight();
        byte[] pixels = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
        int[] palette = new int[indexedCM.getMapSize()];
        indexedCM.getRGBs(palette);
        IndexedSprite newIndexedSprite = client2.createIndexedSprite();
        newIndexedSprite.setPixels(pixels);
        newIndexedSprite.setPalette(palette);
        newIndexedSprite.setWidth(width);
        newIndexedSprite.setHeight(height);
        newIndexedSprite.setOriginalWidth(width);
        newIndexedSprite.setOriginalHeight(height);
        newIndexedSprite.setOffsetX(0);
        newIndexedSprite.setOffsetY(0);
        return newIndexedSprite;
    }

    private static BufferedImage rgbaToIndexedBufferedImage(BufferedImage sourceBufferedImage) {
        BufferedImage indexedImage = new BufferedImage(sourceBufferedImage.getWidth(), sourceBufferedImage.getHeight(), 13);
        ColorModel cm = indexedImage.getColorModel();
        IndexColorModel icm = (IndexColorModel)cm;
        int size = icm.getMapSize();
        byte[] reds = new byte[size];
        byte[] greens = new byte[size];
        byte[] blues = new byte[size];
        icm.getReds(reds);
        icm.getGreens(greens);
        icm.getBlues(blues);
        WritableRaster raster = indexedImage.getRaster();
        int pixel = raster.getSample(0, 0, 0);
        IndexColorModel resultIcm = new IndexColorModel(8, size, reds, greens, blues, pixel);
        BufferedImage resultIndexedImage = new BufferedImage(resultIcm, raster, sourceBufferedImage.isAlphaPremultiplied(), null);
        resultIndexedImage.getGraphics().drawImage(sourceBufferedImage, 0, 0, null);
        return resultIndexedImage;
    }

    private static BufferedImage clanChatImageFromSprite(BufferedImage clanSprite) {
        BufferedImage clanChatCanvas = ImageUtil.resizeCanvas(clanSprite, ClanManager.CLANCHAT_IMAGE_DIMENSION.width, ClanManager.CLANCHAT_IMAGE_DIMENSION.height);
        return ImageUtil.outlineImage(clanChatCanvas, CLANCHAT_IMAGE_OUTLINE_COLOR);
    }
}

