/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.game;

import java.awt.image.BufferedImage;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class AsyncBufferedImage
extends BufferedImage {
    private final List<Runnable> listeners = new CopyOnWriteArrayList<Runnable>();

    public AsyncBufferedImage(int width, int height, int imageType) {
        super(width, height, imageType);
    }

    public void changed() {
        for (Runnable r : this.listeners) {
            r.run();
        }
    }

    public void onChanged(Runnable r) {
        this.listeners.add(r);
    }

    public void addTo(JButton c) {
        c.setIcon(this.makeIcon(c));
    }

    public void addTo(JLabel c) {
        c.setIcon(this.makeIcon(c));
    }

    private ImageIcon makeIcon(JComponent c) {
        this.listeners.add(c::repaint);
        return new ImageIcon(this);
    }
}

