/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.eventbus;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMultimap;
import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import net.runelite.client.eventbus.Subscribe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class EventBus {
    private static final Logger log = LoggerFactory.getLogger(EventBus.class);
    private final Consumer<Throwable> exceptionHandler;
    private ImmutableMultimap<Class, Subscriber> subscribers = ImmutableMultimap.of();

    public EventBus() {
        this(e -> log.warn("Uncaught exception in event subscriber", (Throwable)e));
    }

    public synchronized void register(@Nonnull Object object) {
        ImmutableMultimap.Builder<Class<?>, Subscriber> builder = ImmutableMultimap.builder();
        if (this.subscribers != null) {
            builder.putAll(this.subscribers);
        }
        for (Class<?> clazz = object.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            for (Method method : clazz.getDeclaredMethods()) {
                Subscribe sub = method.getAnnotation(Subscribe.class);
                if (sub == null) continue;
                Preconditions.checkArgument(method.getReturnType() == Void.TYPE, "@Subscribed method \"" + method + "\" cannot return a value");
                Preconditions.checkArgument(method.getParameterCount() == 1, "@Subscribed method \"" + method + "\" must take exactly 1 argument");
                Preconditions.checkArgument(!Modifier.isStatic(method.getModifiers()), "@Subscribed method \"" + method + "\" cannot be static");
                Class<?> parameterClazz = method.getParameterTypes()[0];
                Preconditions.checkArgument(!parameterClazz.isPrimitive(), "@Subscribed method \"" + method + "\" cannot subscribe to primitives");
                Preconditions.checkArgument((parameterClazz.getModifiers() & 0x600) == 0, "@Subscribed method \"" + method + "\" cannot subscribe to polymorphic classes");
                for (Class<?> psc = parameterClazz.getSuperclass(); psc != null; psc = psc.getSuperclass()) {
                    if (!this.subscribers.containsKey(psc)) continue;
                    throw new IllegalArgumentException("@Subscribed method \"" + method + "\" cannot subscribe to class which inherits from subscribed class \"" + psc + "\"");
                }
                String preferredName = "on" + parameterClazz.getSimpleName();
                Preconditions.checkArgument(method.getName().equals(preferredName), "Subscribed method " + method + " should be named " + preferredName);
                method.setAccessible(true);
                SubscriberMethod lambda = null;
                try {
                    MethodHandles.Lookup caller = EventBus.privateLookupIn(clazz);
                    MethodType subscription = MethodType.methodType(Void.TYPE, parameterClazz);
                    MethodHandle target = caller.findVirtual(clazz, method.getName(), subscription);
                    CallSite site = LambdaMetafactory.metafactory(caller, "invoke", MethodType.methodType(SubscriberMethod.class, clazz), subscription.changeParameterType(0, Object.class), target, subscription);
                    MethodHandle factory = site.getTarget();
                    lambda = factory.bindTo(object).invokeExact();
                }
                catch (Throwable e) {
                    log.warn("Unable to create lambda for method {}", (Object)method, (Object)e);
                }
                Subscriber subscriber = new Subscriber(object, method, lambda);
                builder.put(parameterClazz, subscriber);
                log.debug("Registering {} - {}", (Object)parameterClazz, (Object)subscriber);
            }
        }
        this.subscribers = builder.build();
    }

    public synchronized void unregister(@Nonnull Object object) {
        if (this.subscribers == null) {
            return;
        }
        HashMultimap<Class, Subscriber> map = HashMultimap.create();
        map.putAll(this.subscribers);
        for (Class<?> clazz = object.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            for (Method method : clazz.getDeclaredMethods()) {
                Subscribe sub = method.getAnnotation(Subscribe.class);
                if (sub == null) continue;
                Class<?> parameterClazz = method.getParameterTypes()[0];
                map.remove(parameterClazz, new Subscriber(object, method, null));
            }
        }
        this.subscribers = ImmutableMultimap.copyOf(map);
    }

    public void post(@Nonnull Object event) {
        for (Subscriber subscriber : this.subscribers.get((Object)event.getClass())) {
            try {
                subscriber.invoke(event);
            }
            catch (Exception e) {
                this.exceptionHandler.accept(e);
            }
        }
    }

    private static MethodHandles.Lookup privateLookupIn(Class clazz) throws IllegalAccessException, NoSuchFieldException, InvocationTargetException {
        try {
            Method privateLookupIn = MethodHandles.class.getMethod("privateLookupIn", Class.class, MethodHandles.Lookup.class);
            return (MethodHandles.Lookup)privateLookupIn.invoke(null, clazz, MethodHandles.lookup());
        }
        catch (NoSuchMethodException e) {
            MethodHandles.Lookup lookupIn = MethodHandles.lookup().in(clazz);
            Field modes = MethodHandles.Lookup.class.getDeclaredField("allowedModes");
            modes.setAccessible(true);
            modes.setInt(lookupIn, -1);
            return lookupIn;
        }
    }

    public EventBus(Consumer<Throwable> exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    private static final class Subscriber {
        private final Object object;
        private final Method method;
        private final SubscriberMethod lamda;

        void invoke(Object arg) throws Exception {
            if (this.lamda != null) {
                this.lamda.invoke(arg);
            } else {
                this.method.invoke(this.object, arg);
            }
        }

        public Subscriber(Object object, Method method, SubscriberMethod lamda) {
            this.object = object;
            this.method = method;
            this.lamda = lamda;
        }

        public Object getObject() {
            return this.object;
        }

        public Method getMethod() {
            return this.method;
        }

        public SubscriberMethod getLamda() {
            return this.lamda;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Subscriber)) {
                return false;
            }
            Subscriber other = (Subscriber)o;
            Object this$object = this.getObject();
            Object other$object = other.getObject();
            if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
                return false;
            }
            Method this$method = this.getMethod();
            Method other$method = other.getMethod();
            return !(this$method == null ? other$method != null : !((Object)this$method).equals(other$method));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Object $object = this.getObject();
            result = result * 59 + ($object == null ? 43 : $object.hashCode());
            Method $method = this.getMethod();
            result = result * 59 + ($method == null ? 43 : ((Object)$method).hashCode());
            return result;
        }

        public String toString() {
            return "EventBus.Subscriber(object=" + this.getObject() + ", method=" + this.getMethod() + ", lamda=" + this.getLamda() + ")";
        }
    }

    @FunctionalInterface
    public static interface SubscriberMethod {
        public void invoke(Object var1);
    }
}

