/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.config;

import java.awt.Dimension;
import net.runelite.api.Constants;
import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigItem;
import net.runelite.client.config.ExpandResizeType;
import net.runelite.client.config.FontType;
import net.runelite.client.config.WarningOnExit;

@ConfigGroup(value="runelite")
public interface RuneLiteConfig
extends Config {
    @ConfigItem(keyName="gameSize", name="Game size", description="The game will resize to this resolution upon starting the client", position=10)
    default public Dimension gameSize() {
        return Constants.GAME_FIXED_SIZE;
    }

    @ConfigItem(keyName="automaticResizeType", name="Resize type", description="Choose how the window should resize when opening and closing panels", position=11)
    default public ExpandResizeType automaticResizeType() {
        return ExpandResizeType.KEEP_GAME_SIZE;
    }

    @ConfigItem(keyName="lockWindowSize", name="Lock window size", description="Determines if the window resizing is allowed or not", position=12)
    default public boolean lockWindowSize() {
        return false;
    }

    @ConfigItem(keyName="containInScreen", name="Contain in screen", description="Makes the client stay contained in the screen when attempted to move out of it.<br>Note: Only works if custom chrome is enabled.", position=13)
    default public boolean containInScreen() {
        return false;
    }

    @ConfigItem(keyName="rememberScreenBounds", name="Remember client position", description="Save the position and size of the client after exiting", position=14)
    default public boolean rememberScreenBounds() {
        return true;
    }

    @ConfigItem(keyName="uiEnableCustomChrome", name="Enable custom window chrome", description="Use Runelite's custom window title and borders.", warning="Please restart your client after changing this setting", position=15)
    default public boolean enableCustomChrome() {
        return true;
    }

    @ConfigItem(keyName="gameAlwaysOnTop", name="Enable client always on top", description="The game will always be on the top of the screen", position=16)
    default public boolean gameAlwaysOnTop() {
        return false;
    }

    @ConfigItem(keyName="warningOnExit", name="Display warning on exit", description="Toggles a warning popup when trying to exit the client", position=17)
    default public WarningOnExit warningOnExit() {
        return WarningOnExit.LOGGED_IN;
    }

    @ConfigItem(keyName="usernameInTitle", name="Show display name in title", description="Toggles displaying of local player's display name in client title", position=18)
    default public boolean usernameInTitle() {
        return true;
    }

    @ConfigItem(keyName="notificationTray", name="Enable tray notifications", description="Enables tray notifications", position=20)
    default public boolean enableTrayNotifications() {
        return true;
    }

    @ConfigItem(keyName="notificationRequestFocus", name="Request focus on notification", description="Toggles window focus request", position=21)
    default public boolean requestFocusOnNotification() {
        return true;
    }

    @ConfigItem(keyName="notificationSound", name="Enable sound on notifications", description="Enables the playing of a beep sound when notifications are displayed", position=22)
    default public boolean enableNotificationSound() {
        return true;
    }

    @ConfigItem(keyName="notificationGameMessage", name="Enable game message notifications", description="Puts a notification message in the chatbox", position=23)
    default public boolean enableGameMessageNotification() {
        return false;
    }

    @ConfigItem(keyName="notificationFlash", name="Enable flash notification", description="Flashes the game frame as a notification", position=24)
    default public boolean enableFlashNotification() {
        return false;
    }

    @ConfigItem(keyName="notificationFocused", name="Send notifications when focused", description="Toggles all notifications for when the client is focused", position=25)
    default public boolean sendNotificationsWhenFocused() {
        return false;
    }

    @ConfigItem(keyName="fontType", name="Dynamic Overlay Font", description="Configures what font type is used for in-game overlays such as player name, ground items, etc.", position=30)
    default public FontType fontType() {
        return FontType.SMALL;
    }

    @ConfigItem(keyName="tooltipFontType", name="Tooltip Font", description="Configures what font type is used for in-game tooltips such as food stats, NPC names, etc.", position=31)
    default public FontType tooltipFontType() {
        return FontType.SMALL;
    }

    @ConfigItem(keyName="interfaceFontType", name="Interface Overlay Font", description="Configures what font type is used for in-game interface overlays such as panels, opponent info, clue scrolls etc.", position=32)
    default public FontType interfaceFontType() {
        return FontType.REGULAR;
    }

    @ConfigItem(keyName="menuEntryShift", name="Require Shift for overlay menu", description="Overlay right-click menu will require shift to be added", position=33)
    default public boolean menuEntryShift() {
        return true;
    }

    @ConfigItem(keyName="infoBoxVertical", name="Display infoboxes vertically", description="Toggles the infoboxes to display vertically", position=40)
    default public boolean infoBoxVertical() {
        return false;
    }

    @ConfigItem(keyName="infoBoxWrap", name="Infobox wrap count", description="Configures the amount of infoboxes shown before wrapping", position=41)
    default public int infoBoxWrap() {
        return 4;
    }

    @ConfigItem(keyName="infoBoxSize", name="Infobox size (px)", description="Configures the size of each infobox in pixels", position=42)
    default public int infoBoxSize() {
        return 35;
    }
}

