/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.config;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Objects;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigItem;
import net.runelite.client.config.ConfigManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConfigInvocationHandler
implements InvocationHandler {
    private static final Logger log = LoggerFactory.getLogger(ConfigInvocationHandler.class);
    private final ConfigManager manager;

    public ConfigInvocationHandler(ConfigManager manager) {
        this.manager = manager;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object defaultValue;
        Class<?> iface = proxy.getClass().getInterfaces()[0];
        ConfigGroup group = iface.getAnnotation(ConfigGroup.class);
        ConfigItem item = method.getAnnotation(ConfigItem.class);
        if (group == null) {
            log.warn("Configuration proxy class {} has no @ConfigGroup!", (Object)proxy.getClass());
            return null;
        }
        if (item == null) {
            log.warn("Configuration method {} has no @ConfigItem!", (Object)method);
            return null;
        }
        if (args == null) {
            String value = this.manager.getConfiguration(group.value(), item.keyName());
            if (value == null) {
                if (method.isDefault()) {
                    return ConfigInvocationHandler.callDefaultMethod(proxy, method, null);
                }
                return null;
            }
            Class<?> returnType = method.getReturnType();
            try {
                return ConfigManager.stringToObject(value, returnType);
            }
            catch (Exception e) {
                log.warn("Unable to unmarshal {}.{} ", group.value(), item.keyName(), e);
                if (method.isDefault()) {
                    return ConfigInvocationHandler.callDefaultMethod(proxy, method, null);
                }
                return null;
            }
        }
        if (args.length != 1) {
            throw new RuntimeException("Invalid number of arguents to configuration method");
        }
        Object newValue = args[0];
        Class<?> type = method.getParameterTypes()[0];
        Object oldValue = this.manager.getConfiguration(group.value(), item.keyName(), type);
        if (Objects.equals(oldValue, newValue)) {
            return null;
        }
        if (method.isDefault() && Objects.equals(newValue, defaultValue = ConfigInvocationHandler.callDefaultMethod(proxy, method, args))) {
            this.manager.unsetConfiguration(group.value(), item.keyName());
            return null;
        }
        if (newValue == null) {
            this.manager.unsetConfiguration(group.value(), item.keyName());
        } else {
            String newValueStr = ConfigManager.objectToString(newValue);
            this.manager.setConfiguration(group.value(), item.keyName(), newValueStr);
        }
        return null;
    }

    static Object callDefaultMethod(Object proxy, Method method, Object[] args) throws Throwable {
        Constructor constructor = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class, Integer.TYPE);
        constructor.setAccessible(true);
        Class<?> declaringClass = method.getDeclaringClass();
        return ((MethodHandles.Lookup)constructor.newInstance(declaringClass, 3)).unreflectSpecial(method, declaringClass).bindTo(proxy).invokeWithArguments(args);
    }
}

