/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.chat;

import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.awt.Color;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.ChatLineBuffer;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.MessageNode;
import net.runelite.api.Varbits;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.ConfigChanged;
import net.runelite.api.events.ResizeableChanged;
import net.runelite.api.events.ScriptCallbackEvent;
import net.runelite.api.events.VarbitChanged;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.chat.ChatColor;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.config.ChatColorConfig;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.ui.JagexColors;
import net.runelite.client.util.ColorUtil;

@Singleton
public class ChatMessageManager {
    private final Multimap<ChatMessageType, ChatColor> colorCache = HashMultimap.create();
    private final Client client;
    private final ChatColorConfig chatColorConfig;
    private final ClientThread clientThread;
    private int transparencyVarbit = -1;
    private final Queue<QueuedMessage> queuedMessages = new ConcurrentLinkedQueue<QueuedMessage>();

    @Inject
    private ChatMessageManager(Client client2, ChatColorConfig chatColorConfig, ClientThread clientThread) {
        this.client = client2;
        this.chatColorConfig = chatColorConfig;
        this.clientThread = clientThread;
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged event) {
        int setting = this.client.getVar(Varbits.TRANSPARENT_CHATBOX);
        if (this.transparencyVarbit != setting) {
            this.transparencyVarbit = setting;
            this.refreshAll();
        }
    }

    @Subscribe
    public void onResizeableChanged(ResizeableChanged event) {
        this.refreshAll();
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals("textrecolor")) {
            this.loadColors();
            this.clientThread.invokeLater(this::refreshAll);
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage chatMessage) {
        MessageNode messageNode = chatMessage.getMessageNode();
        ChatMessageType chatMessageType = chatMessage.getType();
        boolean isChatboxTransparent = this.client.isResized() && this.client.getVar(Varbits.TRANSPARENT_CHATBOX) == 1;
        Color usernameColor = null;
        Color senderColor = null;
        switch (chatMessageType) {
            case MODPRIVATECHAT: 
            case PRIVATECHAT: 
            case PRIVATECHATOUT: {
                usernameColor = isChatboxTransparent ? this.chatColorConfig.transparentPrivateUsernames() : this.chatColorConfig.opaquePrivateUsernames();
                break;
            }
            case TRADEREQ: 
            case AUTOTYPER: 
            case PUBLICCHAT: 
            case MODCHAT: {
                boolean isFriend;
                boolean bl = isFriend = this.client.isFriended(chatMessage.getName(), true) && !this.client.getLocalPlayer().getName().equals(chatMessage.getName());
                if (isFriend) {
                    Color color = usernameColor = isChatboxTransparent ? this.chatColorConfig.transparentPublicFriendUsernames() : this.chatColorConfig.opaquePublicFriendUsernames();
                }
                if (usernameColor != null) break;
                usernameColor = isChatboxTransparent ? this.chatColorConfig.transparentUsername() : this.chatColorConfig.opaqueUsername();
                break;
            }
            case FRIENDSCHAT: {
                usernameColor = isChatboxTransparent ? this.chatColorConfig.transparentClanUsernames() : this.chatColorConfig.opaqueClanUsernames();
            }
        }
        Color color = senderColor = isChatboxTransparent ? this.chatColorConfig.transparentClanChannelName() : this.chatColorConfig.opaqueClanChannelName();
        if (usernameColor != null) {
            messageNode.setName(ColorUtil.wrapWithColorTag(messageNode.getName(), usernameColor));
        }
        String sender = chatMessage.getSender();
        if (senderColor != null && !Strings.isNullOrEmpty(sender)) {
            messageNode.setSender(ColorUtil.wrapWithColorTag(sender, senderColor));
        }
        Collection<ChatColor> chatColors = this.colorCache.get(chatMessageType);
        for (ChatColor chatColor : chatColors) {
            if (chatColor.isTransparent() != isChatboxTransparent || chatColor.getType() != ChatColorType.NORMAL || chatColor.isDefault()) continue;
            messageNode.setValue(ColorUtil.wrapWithColorTag(messageNode.getValue(), chatColor.getColor()));
            break;
        }
    }

    @Subscribe
    public void onScriptCallbackEvent(ScriptCallbackEvent scriptCallbackEvent) {
        Color usernameColor;
        String eventName;
        switch (eventName = scriptCallbackEvent.getEventName()) {
            case "privateChatFrom": 
            case "privateChatTo": 
            case "privateChatSplitFrom": 
            case "privateChatSplitTo": {
                break;
            }
            default: {
                return;
            }
        }
        boolean isChatboxTransparent = this.client.isResized() && this.client.getVar(Varbits.TRANSPARENT_CHATBOX) == 1;
        Color color = usernameColor = isChatboxTransparent ? this.chatColorConfig.transparentPrivateUsernames() : this.chatColorConfig.opaquePrivateUsernames();
        if (usernameColor == null) {
            return;
        }
        String[] stringStack = this.client.getStringStack();
        int stringStackSize = this.client.getStringStackSize();
        String toFrom = stringStack[stringStackSize - 3];
        stringStack[stringStackSize - 3] = ColorUtil.prependColorTag(toFrom, usernameColor);
    }

    private static Color getDefaultColor(ChatMessageType type, boolean transparent) {
        if (!transparent) {
            switch (type) {
                case PUBLICCHAT: 
                case MODCHAT: {
                    return JagexColors.CHAT_PUBLIC_TEXT_OPAQUE_BACKGROUND;
                }
                case MODPRIVATECHAT: 
                case PRIVATECHAT: 
                case PRIVATECHATOUT: {
                    return JagexColors.CHAT_PRIVATE_MESSAGE_TEXT_OPAQUE_BACKGROUND;
                }
                case FRIENDSCHAT: {
                    return JagexColors.CHAT_CLAN_TEXT_OPAQUE_BACKGROUND;
                }
                case ITEM_EXAMINE: 
                case OBJECT_EXAMINE: 
                case NPC_EXAMINE: 
                case CONSOLE: {
                    return JagexColors.CHAT_GAME_EXAMINE_TEXT_OPAQUE_BACKGROUND;
                }
            }
        } else {
            switch (type) {
                case PUBLICCHAT: 
                case MODCHAT: {
                    return JagexColors.CHAT_PUBLIC_TEXT_TRANSPARENT_BACKGROUND;
                }
                case MODPRIVATECHAT: 
                case PRIVATECHAT: 
                case PRIVATECHATOUT: {
                    return JagexColors.CHAT_PRIVATE_MESSAGE_TEXT_TRANSPARENT_BACKGROUND;
                }
                case FRIENDSCHAT: {
                    return JagexColors.CHAT_CLAN_TEXT_TRANSPARENT_BACKGROUND;
                }
                case ITEM_EXAMINE: 
                case OBJECT_EXAMINE: 
                case NPC_EXAMINE: 
                case CONSOLE: {
                    return JagexColors.CHAT_GAME_EXAMINE_TEXT_TRANSPARENT_BACKGROUND;
                }
            }
        }
        return null;
    }

    public void loadColors() {
        this.colorCache.clear();
        for (ChatMessageType chatMessageType : ChatMessageType.values()) {
            Color defaultOpaque;
            Color defaultTransparent = ChatMessageManager.getDefaultColor(chatMessageType, true);
            if (defaultTransparent != null) {
                this.cacheColor(new ChatColor(ChatColorType.NORMAL, defaultTransparent, true, true), chatMessageType);
            }
            if ((defaultOpaque = ChatMessageManager.getDefaultColor(chatMessageType, false)) == null) continue;
            this.cacheColor(new ChatColor(ChatColorType.NORMAL, defaultOpaque, false, true), chatMessageType);
        }
        if (this.chatColorConfig.opaquePublicChat() != null) {
            this.cacheColor(new ChatColor(ChatColorType.NORMAL, this.chatColorConfig.opaquePublicChat(), false), ChatMessageType.PUBLICCHAT);
            this.cacheColor(new ChatColor(ChatColorType.NORMAL, this.chatColorConfig.opaquePublicChat(), false), ChatMessageType.MODCHAT);
        }
        if (this.chatColorConfig.opaquePublicChatHighlight() != null) {
            this.cacheColor(new ChatColor(ChatColorType.HIGHLIGHT, this.chatColorConfig.opaquePublicChatHighlight(), false), ChatMessageType.PUBLICCHAT);
            this.cacheColor(new ChatColor(ChatColorType.HIGHLIGHT, this.chatColorConfig.opaquePublicChatHighlight(), false), ChatMessageType.MODCHAT);
        }
        if (this.chatColorConfig.opaquePrivateMessageSent() != null) {
            this.cacheColor(new ChatColor(ChatColorType.NORMAL, this.chatColorConfig.opaquePrivateMessageSent(), false), ChatMessageType.PRIVATECHATOUT);
        }
        if (this.chatColorConfig.opaquePrivateMessageSentHighlight() != null) {
            this.cacheColor(new ChatColor(ChatColorType.HIGHLIGHT, this.chatColorConfig.opaquePrivateMessageSentHighlight(), false), ChatMessageType.PRIVATECHATOUT);
        }
        if (this.chatColorConfig.opaquePrivateMessageReceived() != null) {
            this.cacheColor(new ChatColor(ChatColorType.NORMAL, this.chatColorConfig.opaquePrivateMessageReceived(), false), ChatMessageType.PRIVATECHAT);
            this.cacheColor(new ChatColor(ChatColorType.NORMAL, this.chatColorConfig.opaquePrivateMessageReceived(), false), ChatMessageType.MODPRIVATECHAT);
        }
        if (this.chatColorConfig.opaquePrivateMessageReceivedHighlight() != null) {
            this.cacheColor(new ChatColor(ChatColorType.HIGHLIGHT, this.chatColorConfig.opaquePrivateMessageReceivedHighlight(), false), ChatMessageType.PRIVATECHAT);
            this.cacheColor(new ChatColor(ChatColorType.HIGHLIGHT, this.chatColorConfig.opaquePrivateMessageReceivedHighlight(), false), ChatMessageType.MODPRIVATECHAT);
        }
        if (this.chatColorConfig.opaqueClanChatInfo() != null) {
            this.cacheColor(new ChatColor(ChatColorType.NORMAL, this.chatColorConfig.opaqueClanChatInfo(), false), ChatMessageType.FRIENDSCHATNOTIFICATION);
        }
        if (this.chatColorConfig.opaqueClanChatInfoHighlight() != null) {
            this.cacheColor(new ChatColor(ChatColorType.HIGHLIGHT, this.chatColorConfig.opaqueClanChatInfoHighlight(), false), ChatMessageType.FRIENDSCHATNOTIFICATION);
        }
        if (this.chatColorConfig.opaqueClanChatMessage() != null) {
            this.cacheColor(new ChatColor(ChatColorType.NORMAL, this.chatColorConfig.opaqueClanChatMessage(), false), ChatMessageType.FRIENDSCHAT);
        }
        if (this.chatColorConfig.opaqueClanChatMessageHighlight() != null) {
            this.cacheColor(new ChatColor(ChatColorType.HIGHLIGHT, this.chatColorConfig.opaqueClanChatMessageHighlight(), false), ChatMessageType.FRIENDSCHAT);
        }
        if (this.chatColorConfig.opaqueAutochatMessage() != null) {
            this.cacheColor(new ChatColor(ChatColorType.NORMAL, this.chatColorConfig.opaqueAutochatMessage(), false), ChatMessageType.AUTOTYPER);
        }
        if (this.chatColorConfig.opaqueAutochatMessageHighlight() != null) {
            this.cacheColor(new ChatColor(ChatColorType.HIGHLIGHT, this.chatColorConfig.opaqueAutochatMessageHighlight(), false), ChatMessageType.AUTOTYPER);
        }
        if (this.chatColorConfig.opaqueTradeChatMessage() != null) {
            this.cacheColor(new ChatColor(ChatColorType.NORMAL, this.chatColorConfig.opaqueTradeChatMessage(), false), ChatMessageType.TRADEREQ);
        }
        if (this.chatColorConfig.opaqueTradeChatMessageHighlight() != null) {
            this.cacheColor(new ChatColor(ChatColorType.HIGHLIGHT, this.chatColorConfig.opaqueTradeChatMessageHighlight(), false), ChatMessageType.TRADEREQ);
        }
        if (this.chatColorConfig.opaqueServerMessage() != null) {
            this.cacheColor(new ChatColor(ChatColorType.NORMAL, this.chatColorConfig.opaqueServerMessage(), false), ChatMessageType.GAMEMESSAGE);
        }
        if (this.chatColorConfig.opaqueServerMessageHighlight() != null) {
            this.cacheColor(new ChatColor(ChatColorType.HIGHLIGHT, this.chatColorConfig.opaqueServerMessageHighlight(), false), ChatMessageType.GAMEMESSAGE);
        }
        if (this.chatColorConfig.opaqueGameMessage() != null) {
            this.cacheColor(new ChatColor(ChatColorType.NORMAL, this.chatColorConfig.opaqueGameMessage(), false), ChatMessageType.CONSOLE);
        }
        if (this.chatColorConfig.opaqueGameMessageHighlight() != null) {
            this.cacheColor(new ChatColor(ChatColorType.HIGHLIGHT, this.chatColorConfig.opaqueGameMessageHighlight(), false), ChatMessageType.CONSOLE);
        }
        if (this.chatColorConfig.opaqueExamine() != null) {
            this.cacheColor(new ChatColor(ChatColorType.NORMAL, this.chatColorConfig.opaqueExamine(), false), ChatMessageType.OBJECT_EXAMINE);
            this.cacheColor(new ChatColor(ChatColorType.NORMAL, this.chatColorConfig.opaqueExamine(), false), ChatMessageType.NPC_EXAMINE);
            this.cacheColor(new ChatColor(ChatColorType.NORMAL, this.chatColorConfig.opaqueExamine(), false), ChatMessageType.ITEM_EXAMINE);
        }
        if (this.chatColorConfig.opaqueExamineHighlight() != null) {
            this.cacheColor(new ChatColor(ChatColorType.HIGHLIGHT, this.chatColorConfig.opaqueExamineHighlight(), false), ChatMessageType.OBJECT_EXAMINE);
            this.cacheColor(new ChatColor(ChatColorType.HIGHLIGHT, this.chatColorConfig.opaqueExamineHighlight(), false), ChatMessageType.NPC_EXAMINE);
            this.cacheColor(new ChatColor(ChatColorType.HIGHLIGHT, this.chatColorConfig.opaqueExamineHighlight(), false), ChatMessageType.ITEM_EXAMINE);
        }
        if (this.chatColorConfig.opaqueFiltered() != null) {
            this.cacheColor(new ChatColor(ChatColorType.NORMAL, this.chatColorConfig.opaqueFiltered(), false), ChatMessageType.SPAM);
        }
        if (this.chatColorConfig.opaqueFilteredHighlight() != null) {
            this.cacheColor(new ChatColor(ChatColorType.HIGHLIGHT, this.chatColorConfig.opaqueFilteredHighlight(), false), ChatMessageType.SPAM);
        }
        if (this.chatColorConfig.transparentPublicChat() != null) {
            this.cacheColor(new ChatColor(ChatColorType.NORMAL, this.chatColorConfig.transparentPublicChat(), true), ChatMessageType.PUBLICCHAT);
            this.cacheColor(new ChatColor(ChatColorType.NORMAL, this.chatColorConfig.transparentPublicChat(), true), ChatMessageType.MODCHAT);
        }
        if (this.chatColorConfig.transparentPublicChatHighlight() != null) {
            this.cacheColor(new ChatColor(ChatColorType.HIGHLIGHT, this.chatColorConfig.transparentPublicChatHighlight(), true), ChatMessageType.PUBLICCHAT);
            this.cacheColor(new ChatColor(ChatColorType.HIGHLIGHT, this.chatColorConfig.transparentPublicChatHighlight(), true), ChatMessageType.MODCHAT);
        }
        if (this.chatColorConfig.transparentPrivateMessageSent() != null) {
            this.cacheColor(new ChatColor(ChatColorType.NORMAL, this.chatColorConfig.transparentPrivateMessageSent(), true), ChatMessageType.PRIVATECHATOUT);
        }
        if (this.chatColorConfig.transparentPrivateMessageSentHighlight() != null) {
            this.cacheColor(new ChatColor(ChatColorType.HIGHLIGHT, this.chatColorConfig.transparentPrivateMessageSentHighlight(), true), ChatMessageType.PRIVATECHATOUT);
        }
        if (this.chatColorConfig.transparentPrivateMessageReceived() != null) {
            this.cacheColor(new ChatColor(ChatColorType.NORMAL, this.chatColorConfig.transparentPrivateMessageReceived(), true), ChatMessageType.PRIVATECHAT);
            this.cacheColor(new ChatColor(ChatColorType.NORMAL, this.chatColorConfig.transparentPrivateMessageReceived(), true), ChatMessageType.MODPRIVATECHAT);
        }
        if (this.chatColorConfig.transparentPrivateMessageReceivedHighlight() != null) {
            this.cacheColor(new ChatColor(ChatColorType.HIGHLIGHT, this.chatColorConfig.transparentPrivateMessageReceivedHighlight(), true), ChatMessageType.PRIVATECHAT);
            this.cacheColor(new ChatColor(ChatColorType.HIGHLIGHT, this.chatColorConfig.transparentPrivateMessageReceivedHighlight(), true), ChatMessageType.MODPRIVATECHAT);
        }
        if (this.chatColorConfig.transparentClanChatInfo() != null) {
            this.cacheColor(new ChatColor(ChatColorType.NORMAL, this.chatColorConfig.transparentClanChatInfo(), true), ChatMessageType.FRIENDSCHATNOTIFICATION);
        }
        if (this.chatColorConfig.transparentClanChatInfoHighlight() != null) {
            this.cacheColor(new ChatColor(ChatColorType.HIGHLIGHT, this.chatColorConfig.transparentClanChatInfoHighlight(), true), ChatMessageType.FRIENDSCHATNOTIFICATION);
        }
        if (this.chatColorConfig.transparentClanChatMessage() != null) {
            this.cacheColor(new ChatColor(ChatColorType.NORMAL, this.chatColorConfig.transparentClanChatMessage(), true), ChatMessageType.FRIENDSCHAT);
        }
        if (this.chatColorConfig.transparentClanChatMessageHighlight() != null) {
            this.cacheColor(new ChatColor(ChatColorType.HIGHLIGHT, this.chatColorConfig.transparentClanChatMessageHighlight(), true), ChatMessageType.FRIENDSCHAT);
        }
        if (this.chatColorConfig.transparentAutochatMessage() != null) {
            this.cacheColor(new ChatColor(ChatColorType.NORMAL, this.chatColorConfig.transparentAutochatMessage(), true), ChatMessageType.AUTOTYPER);
        }
        if (this.chatColorConfig.transparentAutochatMessageHighlight() != null) {
            this.cacheColor(new ChatColor(ChatColorType.HIGHLIGHT, this.chatColorConfig.transparentAutochatMessageHighlight(), true), ChatMessageType.AUTOTYPER);
        }
        if (this.chatColorConfig.transparentTradeChatMessage() != null) {
            this.cacheColor(new ChatColor(ChatColorType.NORMAL, this.chatColorConfig.transparentTradeChatMessage(), true), ChatMessageType.TRADEREQ);
        }
        if (this.chatColorConfig.transparentTradeChatMessageHighlight() != null) {
            this.cacheColor(new ChatColor(ChatColorType.HIGHLIGHT, this.chatColorConfig.transparentTradeChatMessageHighlight(), true), ChatMessageType.TRADEREQ);
        }
        if (this.chatColorConfig.transparentServerMessage() != null) {
            this.cacheColor(new ChatColor(ChatColorType.NORMAL, this.chatColorConfig.transparentServerMessage(), true), ChatMessageType.GAMEMESSAGE);
        }
        if (this.chatColorConfig.transparentServerMessageHighlight() != null) {
            this.cacheColor(new ChatColor(ChatColorType.HIGHLIGHT, this.chatColorConfig.transparentServerMessageHighlight(), true), ChatMessageType.GAMEMESSAGE);
        }
        if (this.chatColorConfig.transparentGameMessage() != null) {
            this.cacheColor(new ChatColor(ChatColorType.NORMAL, this.chatColorConfig.transparentGameMessage(), true), ChatMessageType.CONSOLE);
        }
        if (this.chatColorConfig.transparentGameMessageHighlight() != null) {
            this.cacheColor(new ChatColor(ChatColorType.HIGHLIGHT, this.chatColorConfig.transparentGameMessageHighlight(), true), ChatMessageType.CONSOLE);
        }
        if (this.chatColorConfig.transparentExamine() != null) {
            this.cacheColor(new ChatColor(ChatColorType.NORMAL, this.chatColorConfig.transparentExamine(), true), ChatMessageType.OBJECT_EXAMINE);
            this.cacheColor(new ChatColor(ChatColorType.NORMAL, this.chatColorConfig.transparentExamine(), true), ChatMessageType.NPC_EXAMINE);
            this.cacheColor(new ChatColor(ChatColorType.NORMAL, this.chatColorConfig.transparentExamine(), true), ChatMessageType.ITEM_EXAMINE);
        }
        if (this.chatColorConfig.transparentExamineHighlight() != null) {
            this.cacheColor(new ChatColor(ChatColorType.HIGHLIGHT, this.chatColorConfig.transparentExamineHighlight(), true), ChatMessageType.OBJECT_EXAMINE);
            this.cacheColor(new ChatColor(ChatColorType.HIGHLIGHT, this.chatColorConfig.transparentExamineHighlight(), true), ChatMessageType.NPC_EXAMINE);
            this.cacheColor(new ChatColor(ChatColorType.HIGHLIGHT, this.chatColorConfig.transparentExamineHighlight(), true), ChatMessageType.ITEM_EXAMINE);
        }
        if (this.chatColorConfig.transparentFiltered() != null) {
            this.cacheColor(new ChatColor(ChatColorType.NORMAL, this.chatColorConfig.transparentFiltered(), true), ChatMessageType.SPAM);
        }
        if (this.chatColorConfig.transparentFilteredHighlight() != null) {
            this.cacheColor(new ChatColor(ChatColorType.HIGHLIGHT, this.chatColorConfig.transparentFilteredHighlight(), true), ChatMessageType.SPAM);
        }
    }

    private void cacheColor(ChatColor chatColor, ChatMessageType ... types) {
        for (ChatMessageType chatMessageType : types) {
            this.colorCache.remove((Object)chatMessageType, chatColor);
            this.colorCache.put(chatMessageType, chatColor);
        }
    }

    public void queue(QueuedMessage message) {
        this.queuedMessages.add(message);
    }

    public void process() {
        if (!this.queuedMessages.isEmpty()) {
            this.queuedMessages.forEach(this::add);
            this.queuedMessages.clear();
        }
    }

    private void add(QueuedMessage message) {
        this.client.addChatMessage(message.getType(), MoreObjects.firstNonNull(message.getName(), ""), MoreObjects.firstNonNull(message.getValue(), message.getRuneLiteFormattedMessage()), message.getSender());
        ChatLineBuffer chatLineBuffer = this.client.getChatLineMap().get(message.getType().getType());
        MessageNode[] lines = chatLineBuffer.getLines();
        MessageNode line = lines[0];
        line.setRuneLiteFormatMessage(message.getRuneLiteFormattedMessage());
        line.setTimestamp(message.getTimestamp());
        this.update(line);
    }

    public void update(MessageNode target) {
        if (Strings.isNullOrEmpty(target.getRuneLiteFormatMessage())) {
            return;
        }
        boolean transparent = this.client.isResized() && this.transparencyVarbit != 0;
        Collection<ChatColor> chatColors = this.colorCache.get(target.getType());
        if (chatColors == null || chatColors.isEmpty()) {
            target.setValue(target.getRuneLiteFormatMessage());
            return;
        }
        target.setValue(this.recolorMessage(transparent, target.getRuneLiteFormatMessage(), target.getType()));
    }

    private String recolorMessage(boolean transparent, String message, ChatMessageType messageType) {
        Collection<ChatColor> chatColors = this.colorCache.get(messageType);
        AtomicReference<String> resultMessage = new AtomicReference<String>(message);
        chatColors.stream().filter(chatColor -> chatColor.isTransparent() == transparent).forEach(chatColor -> resultMessage.getAndUpdate(oldMessage -> oldMessage.replaceAll("<col" + chatColor.getType().name() + ">", ColorUtil.colorTag(chatColor.getColor()))));
        return resultMessage.get();
    }

    private void refreshAll() {
        this.client.getChatLineMap().values().stream().filter(Objects::nonNull).flatMap(clb -> Arrays.stream(clb.getLines())).filter(Objects::nonNull).forEach(this::update);
        this.client.refreshChat();
    }
}

