/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.chat;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.events.ChatMessage;
import net.runelite.client.chat.ChatCommand;
import net.runelite.client.chat.ChatboxInputListener;
import net.runelite.client.chat.CommandManager;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ChatInput;
import net.runelite.client.events.ChatboxInput;
import net.runelite.client.events.PrivateMessageInput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ChatCommandManager
implements ChatboxInputListener {
    private static final Logger log = LoggerFactory.getLogger(ChatCommandManager.class);
    private final Map<String, ChatCommand> commands = new HashMap<String, ChatCommand>();
    private final Client client;
    private final ScheduledExecutorService scheduledExecutorService;

    @Inject
    private ChatCommandManager(EventBus eventBus, CommandManager commandManager, Client client2, ScheduledExecutorService scheduledExecutorService) {
        this.client = client2;
        this.scheduledExecutorService = scheduledExecutorService;
        eventBus.register(this);
        commandManager.register(this);
    }

    public void registerCommand(String command, BiConsumer<ChatMessage, String> execute) {
        this.registerCommand(command, execute, null);
    }

    public void registerCommand(String command, BiConsumer<ChatMessage, String> execute, BiPredicate<ChatInput, String> input) {
        this.commands.put(command.toLowerCase(), new ChatCommand(command, false, execute, input));
    }

    public void registerCommandAsync(String command, BiConsumer<ChatMessage, String> execute) {
        this.registerCommandAsync(command, execute, null);
    }

    public void registerCommandAsync(String command, BiConsumer<ChatMessage, String> execute, BiPredicate<ChatInput, String> input) {
        this.commands.put(command.toLowerCase(), new ChatCommand(command, true, execute, input));
    }

    public void unregisterCommand(String command) {
        this.commands.remove(command.toLowerCase());
    }

    @Subscribe
    public void onChatMessage(ChatMessage chatMessage) {
        if (this.client.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        switch (chatMessage.getType()) {
            case PUBLICCHAT: 
            case MODCHAT: 
            case FRIENDSCHAT: 
            case PRIVATECHAT: 
            case PRIVATECHATOUT: {
                break;
            }
            default: {
                return;
            }
        }
        String message = chatMessage.getMessage();
        String command = ChatCommandManager.extractCommand(message);
        if (command == null) {
            return;
        }
        ChatCommand chatCommand = this.commands.get(command.toLowerCase());
        if (chatCommand == null) {
            return;
        }
        if (chatCommand.isAsync()) {
            this.scheduledExecutorService.execute(() -> chatCommand.getExecute().accept(chatMessage, message));
        } else {
            chatCommand.getExecute().accept(chatMessage, message);
        }
    }

    @Override
    public boolean onChatboxInput(ChatboxInput chatboxInput) {
        String command;
        String message = chatboxInput.getValue();
        if (message.startsWith("/")) {
            message = message.substring(1);
        }
        if ((command = ChatCommandManager.extractCommand(message)) == null) {
            return false;
        }
        ChatCommand chatCommand = this.commands.get(command.toLowerCase());
        if (chatCommand == null) {
            return false;
        }
        BiPredicate<ChatInput, String> input = chatCommand.getInput();
        if (input == null) {
            return false;
        }
        return input.test(chatboxInput, message);
    }

    @Override
    public boolean onPrivateMessageInput(PrivateMessageInput privateMessageInput) {
        String message = privateMessageInput.getMessage();
        String command = ChatCommandManager.extractCommand(message);
        if (command == null) {
            return false;
        }
        ChatCommand chatCommand = this.commands.get(command.toLowerCase());
        if (chatCommand == null) {
            return false;
        }
        BiPredicate<ChatInput, String> input = chatCommand.getInput();
        if (input == null) {
            return false;
        }
        return input.test(privateMessageInput, message);
    }

    private static String extractCommand(String message) {
        int idx = message.indexOf(32);
        if (idx == -1) {
            return message;
        }
        return message.substring(0, idx);
    }
}

