/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.callback;

import com.google.inject.Injector;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.image.BufferedImage;
import java.awt.image.VolatileImage;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.BufferProvider;
import net.runelite.api.Client;
import net.runelite.api.MainBufferProvider;
import net.runelite.api.RenderOverview;
import net.runelite.api.Renderable;
import net.runelite.api.WorldMapManager;
import net.runelite.api.events.BeforeMenuRender;
import net.runelite.api.events.BeforeRender;
import net.runelite.api.events.GameTick;
import net.runelite.api.hooks.Callbacks;
import net.runelite.api.hooks.DrawCallbacks;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.api.widgets.WidgetItem;
import net.runelite.client.Notifier;
import net.runelite.client.RuneLite;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.input.KeyManager;
import net.runelite.client.input.MouseManager;
import net.runelite.client.task.Scheduler;
import net.runelite.client.ui.ClientUI;
import net.runelite.client.ui.DrawManager;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.ui.overlay.OverlayRenderer;
import net.runelite.client.ui.overlay.infobox.InfoBoxManager;
import net.runelite.client.util.DeferredEventBus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class Hooks
implements Callbacks {
    private static final Logger log = LoggerFactory.getLogger(Hooks.class);
    private static final long CHECK = 600L;
    private static final Injector injector = RuneLite.getInjector();
    private static final Client client = injector.getInstance(Client.class);
    private static final OverlayRenderer renderer = injector.getInstance(OverlayRenderer.class);
    private static final OverlayManager overlayManager = injector.getInstance(OverlayManager.class);
    private static final GameTick GAME_TICK = new GameTick();
    private static final BeforeRender BEFORE_RENDER = new BeforeRender();
    @Inject
    private EventBus eventBus;
    @Inject
    private DeferredEventBus deferredEventBus;
    @Inject
    private Scheduler scheduler;
    @Inject
    private InfoBoxManager infoBoxManager;
    @Inject
    private ChatMessageManager chatMessageManager;
    @Inject
    private MouseManager mouseManager;
    @Inject
    private KeyManager keyManager;
    @Inject
    private ClientThread clientThread;
    @Inject
    private DrawManager drawManager;
    @Inject
    private Notifier notifier;
    @Inject
    private ClientUI clientUi;
    private Dimension lastStretchedDimensions;
    private VolatileImage stretchedImage;
    private Graphics2D stretchedGraphics;
    private long lastCheck;
    private boolean shouldProcessGameTick;

    @Override
    public void post(Object event) {
        this.eventBus.post(event);
    }

    @Override
    public void postDeferred(Object event) {
        this.deferredEventBus.post(event);
    }

    @Override
    public void clientMainLoop() {
        if (this.shouldProcessGameTick) {
            this.shouldProcessGameTick = false;
            this.deferredEventBus.replay();
            this.eventBus.post(GAME_TICK);
            int tick = client.getTickCount();
            client.setTickCount(tick + 1);
        }
        this.eventBus.post(BEFORE_RENDER);
        this.clientThread.invoke();
        long now = System.currentTimeMillis();
        if (now - this.lastCheck < 600L) {
            return;
        }
        this.lastCheck = now;
        try {
            this.scheduler.tick();
            this.infoBoxManager.cull();
            this.chatMessageManager.process();
            this.checkWorldMap();
        }
        catch (Exception ex) {
            log.warn("error during main loop tasks", ex);
        }
    }

    private void checkWorldMap() {
        Widget widget = client.getWidget(WidgetInfo.WORLD_MAP_VIEW);
        if (widget != null) {
            return;
        }
        RenderOverview renderOverview = client.getRenderOverview();
        if (renderOverview == null) {
            return;
        }
        WorldMapManager manager = renderOverview.getWorldMapManager();
        if (manager != null && manager.isLoaded()) {
            log.debug("World map was closed, reinitializing");
            renderOverview.initializeWorldMap(renderOverview.getWorldMapData());
        }
    }

    @Override
    public MouseEvent mousePressed(MouseEvent mouseEvent) {
        return this.mouseManager.processMousePressed(mouseEvent);
    }

    @Override
    public MouseEvent mouseReleased(MouseEvent mouseEvent) {
        return this.mouseManager.processMouseReleased(mouseEvent);
    }

    @Override
    public MouseEvent mouseClicked(MouseEvent mouseEvent) {
        return this.mouseManager.processMouseClicked(mouseEvent);
    }

    @Override
    public MouseEvent mouseEntered(MouseEvent mouseEvent) {
        return this.mouseManager.processMouseEntered(mouseEvent);
    }

    @Override
    public MouseEvent mouseExited(MouseEvent mouseEvent) {
        return this.mouseManager.processMouseExited(mouseEvent);
    }

    @Override
    public MouseEvent mouseDragged(MouseEvent mouseEvent) {
        return this.mouseManager.processMouseDragged(mouseEvent);
    }

    @Override
    public MouseEvent mouseMoved(MouseEvent mouseEvent) {
        return this.mouseManager.processMouseMoved(mouseEvent);
    }

    @Override
    public MouseWheelEvent mouseWheelMoved(MouseWheelEvent event) {
        return this.mouseManager.processMouseWheelMoved(event);
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        this.keyManager.processKeyPressed(keyEvent);
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        this.keyManager.processKeyReleased(keyEvent);
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        this.keyManager.processKeyTyped(keyEvent);
    }

    @Override
    public void draw(MainBufferProvider mainBufferProvider, Graphics graphics, int x, int y) {
        Image finalImage;
        if (graphics == null) {
            return;
        }
        Image image = mainBufferProvider.getImage();
        Graphics2D graphics2d = (Graphics2D)image.getGraphics();
        try {
            renderer.render(graphics2d, OverlayLayer.ALWAYS_ON_TOP);
        }
        catch (Exception ex) {
            log.warn("Error during overlay rendering", ex);
        }
        this.notifier.processFlash(graphics2d);
        this.clientUi.paintOverlays(graphics2d);
        graphics2d.dispose();
        if (client.isGpu()) {
            return;
        }
        if (client.isStretchedEnabled()) {
            GraphicsConfiguration gc = this.clientUi.getGraphicsConfiguration();
            Dimension stretchedDimensions = client.getStretchedDimensions();
            if (this.lastStretchedDimensions == null || !this.lastStretchedDimensions.equals(stretchedDimensions) || this.stretchedImage != null && this.stretchedImage.validate(gc) == 2) {
                this.stretchedImage = gc.createCompatibleVolatileImage(stretchedDimensions.width, stretchedDimensions.height);
                if (this.stretchedGraphics != null) {
                    this.stretchedGraphics.dispose();
                }
                this.stretchedGraphics = (Graphics2D)this.stretchedImage.getGraphics();
                this.lastStretchedDimensions = stretchedDimensions;
                graphics.setColor(Color.BLACK);
                graphics.fillRect(0, 0, client.getCanvas().getWidth(), client.getCanvas().getHeight());
            }
            this.stretchedGraphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, client.isStretchedFast() ? RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR : RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            this.stretchedGraphics.drawImage(image, 0, 0, stretchedDimensions.width, stretchedDimensions.height, null);
            finalImage = this.stretchedImage;
        } else {
            finalImage = image;
        }
        graphics.drawImage(finalImage, 0, 0, client.getCanvas());
        this.drawManager.processDrawComplete(() -> Hooks.copy(finalImage));
    }

    private static Image copy(Image src) {
        int width = src.getWidth(null);
        int height = src.getHeight(null);
        BufferedImage image = new BufferedImage(width, height, 1);
        Graphics graphics = image.getGraphics();
        graphics.drawImage(src, 0, 0, width, height, null);
        graphics.dispose();
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drawScene() {
        MainBufferProvider bufferProvider = (MainBufferProvider)((Object)client.getBufferProvider());
        BufferedImage image = (BufferedImage)bufferProvider.getImage();
        Graphics2D graphics2d = image.createGraphics();
        try {
            renderer.render(graphics2d, OverlayLayer.ABOVE_SCENE);
        }
        catch (Exception ex) {
            log.warn("Error during overlay rendering", ex);
        }
        finally {
            graphics2d.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drawAboveOverheads() {
        MainBufferProvider bufferProvider = (MainBufferProvider)((Object)client.getBufferProvider());
        BufferedImage image = (BufferedImage)bufferProvider.getImage();
        Graphics2D graphics2d = image.createGraphics();
        try {
            renderer.render(graphics2d, OverlayLayer.UNDER_WIDGETS);
        }
        catch (Exception ex) {
            log.warn("Error during overlay rendering", ex);
        }
        finally {
            graphics2d.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawAfterWidgets() {
        MainBufferProvider bufferProvider = (MainBufferProvider)((Object)client.getBufferProvider());
        BufferedImage image = (BufferedImage)bufferProvider.getImage();
        Graphics2D graphics2d = image.createGraphics();
        try {
            renderer.render(graphics2d, OverlayLayer.ABOVE_WIDGETS);
            renderer.render(graphics2d, OverlayLayer.ABOVE_MAP);
        }
        catch (Exception ex) {
            log.warn("Error during overlay rendering", ex);
        }
        finally {
            graphics2d.dispose();
        }
        overlayManager.getItemWidgets().clear();
    }

    @Override
    public void updateNpcs() {
        this.shouldProcessGameTick = true;
        this.deferredEventBus.replay();
    }

    public static void renderDraw(Renderable renderable, int orientation, int pitchSin, int pitchCos, int yawSin, int yawCos, int x, int y, int z, long hash) {
        DrawCallbacks drawCallbacks = client.getDrawCallbacks();
        if (drawCallbacks != null) {
            drawCallbacks.draw(renderable, orientation, pitchSin, pitchCos, yawSin, yawCos, x, y, z, hash);
        } else {
            renderable.draw(orientation, pitchSin, pitchCos, yawSin, yawCos, x, y, z, hash);
        }
    }

    public static void clearColorBuffer(int x, int y, int width, int height, int color) {
        BufferProvider bp = client.getBufferProvider();
        int canvasWidth = bp.getWidth();
        int[] pixels = bp.getPixels();
        int pixelPos = y * canvasWidth + x;
        int pixelJump = canvasWidth - width;
        for (int cy = y; cy < y + height; ++cy) {
            for (int cx = x; cx < x + width; ++cx) {
                pixels[pixelPos++] = 0;
            }
            pixelPos += pixelJump;
        }
    }

    @Override
    public void drawItem(int itemId, WidgetItem widgetItem) {
        if (widgetItem.getId() != 6512) {
            overlayManager.getItemWidgets().add(widgetItem);
        }
    }

    public static boolean drawMenu() {
        BeforeMenuRender event = new BeforeMenuRender();
        client.getCallbacks().post(event);
        return event.isConsumed();
    }
}

