/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.account;

import com.google.gson.Gson;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.time.Instant;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.client.RuneLite;
import net.runelite.client.account.AccountSession;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.SessionClose;
import net.runelite.client.events.SessionOpen;
import net.runelite.client.util.LinkBrowser;
import net.runelite.client.ws.WSClient;
import net.runelite.http.api.account.AccountClient;
import net.runelite.http.api.account.OAuthResponse;
import net.runelite.http.api.ws.messages.LoginResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SessionManager {
    private static final Logger log = LoggerFactory.getLogger(SessionManager.class);
    private static final File SESSION_FILE = new File(RuneLite.RUNELITE_DIR, "session");
    private AccountSession accountSession;
    private final EventBus eventBus;
    private final ConfigManager configManager;
    private final WSClient wsClient;

    @Inject
    private SessionManager(ConfigManager configManager, EventBus eventBus, WSClient wsClient) {
        this.configManager = configManager;
        this.eventBus = eventBus;
        this.wsClient = wsClient;
        eventBus.register(this);
    }

    public void loadSession() {
        AccountSession session;
        if (!SESSION_FILE.exists()) {
            log.info("No session file exists");
            return;
        }
        try (FileInputStream in = new FileInputStream(SESSION_FILE);){
            session = new Gson().fromJson((Reader)new InputStreamReader(in), AccountSession.class);
            log.debug("Loaded session for {}", (Object)session.getUsername());
        }
        catch (Exception ex) {
            log.warn("Unable to load session file", ex);
            return;
        }
        AccountClient accountClient = new AccountClient(session.getUuid());
        if (!accountClient.sesssionCheck()) {
            log.debug("Loaded session {} is invalid", (Object)session.getUuid());
            return;
        }
        this.openSession(session, false);
    }

    private void saveSession() {
        if (this.accountSession == null) {
            return;
        }
        try (FileWriter fw = new FileWriter(SESSION_FILE);){
            new Gson().toJson((Object)this.accountSession, (Appendable)fw);
            log.debug("Saved session to {}", (Object)SESSION_FILE);
        }
        catch (IOException ex) {
            log.warn("Unable to save session file", ex);
        }
    }

    private void deleteSession() {
        SESSION_FILE.delete();
    }

    private void openSession(AccountSession session, boolean openSocket) {
        if (openSocket) {
            this.wsClient.changeSession(session.getUuid());
        }
        this.accountSession = session;
        if (session.getUsername() != null) {
            this.configManager.switchSession(session);
        }
        this.eventBus.post(new SessionOpen());
    }

    private void closeSession() {
        this.wsClient.changeSession(null);
        if (this.accountSession == null) {
            return;
        }
        log.debug("Logging out of account {}", (Object)this.accountSession.getUsername());
        AccountClient client2 = new AccountClient(this.accountSession.getUuid());
        try {
            client2.logout();
        }
        catch (IOException ex) {
            log.warn("Unable to logout of session", ex);
        }
        this.accountSession = null;
        this.configManager.switchSession(null);
        this.eventBus.post(new SessionClose());
    }

    public void login() {
        OAuthResponse login;
        UUID uuid = this.wsClient.getSessionId() != null ? this.wsClient.getSessionId() : UUID.randomUUID();
        AccountClient loginClient = new AccountClient(uuid);
        try {
            login = loginClient.login();
        }
        catch (IOException ex) {
            log.warn("Unable to get oauth url", ex);
            return;
        }
        this.openSession(new AccountSession(login.getUid(), Instant.now()), true);
        LinkBrowser.browse(login.getOauthUrl());
    }

    @Subscribe
    public void onLoginResponse(LoginResponse loginResponse) {
        log.debug("Now logged in as {}", (Object)loginResponse.getUsername());
        AccountSession session = this.getAccountSession();
        session.setUsername(loginResponse.getUsername());
        this.openSession(session, true);
        this.saveSession();
    }

    public void logout() {
        this.closeSession();
        this.deleteSession();
    }

    public AccountSession getAccountSession() {
        return this.accountSession;
    }
}

