/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client;

import com.google.gson.JsonParseException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.UUID;
import net.runelite.http.api.RuneLiteAPI;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;

class SessionClient {
    SessionClient() {
    }

    UUID open() throws IOException {
        HttpUrl url = RuneLiteAPI.getApiRoot().newBuilder().addPathSegment("session").build();
        Request request = new Request.Builder().url(url).build();
        Response response = RuneLiteAPI.CLIENT.newCall(request).execute();
        try {
            ResponseBody body = response.body();
            InputStream in = body.byteStream();
            UUID uUID = RuneLiteAPI.GSON.fromJson((Reader)new InputStreamReader(in), UUID.class);
            if (response != null) {
                response.close();
            }
            return uUID;
        }
        catch (Throwable throwable) {
            try {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (JsonParseException | IllegalArgumentException ex) {
                throw new IOException(ex);
            }
        }
    }

    void ping(UUID uuid) throws IOException {
        HttpUrl url = RuneLiteAPI.getApiRoot().newBuilder().addPathSegment("session").addPathSegment("ping").addQueryParameter("session", uuid.toString()).build();
        Request request = new Request.Builder().url(url).build();
        try (Response response = RuneLiteAPI.CLIENT.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new IOException("Unsuccessful ping");
            }
        }
    }

    void delete(UUID uuid) throws IOException {
        HttpUrl url = RuneLiteAPI.getApiRoot().newBuilder().addPathSegment("session").addQueryParameter("session", uuid.toString()).build();
        Request request = new Request.Builder().delete().url(url).build();
        RuneLiteAPI.CLIENT.newCall(request).execute().close();
    }
}

