/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class RuneLiteProperties {
    private static final Logger log = LoggerFactory.getLogger(RuneLiteProperties.class);
    private static final String RUNELITE_TITLE = "runelite.title";
    private static final String RUNELITE_VERSION = "runelite.version";
    private static final String RUNESCAPE_VERSION = "runescape.version";
    private static final String DISCORD_APP_ID = "runelite.discord.appid";
    private static final String DISCORD_INVITE = "runelite.discord.invite";
    private static final String GITHUB_LINK = "runelite.github.link";
    private static final String WIKI_LINK = "runelite.wiki.link";
    private static final String PATREON_LINK = "runelite.patreon.link";
    private static final String LAUNCHER_VERSION_PROPERTY = "runelite.launcher.version";
    private final Properties properties = new Properties();

    @Inject
    public RuneLiteProperties() {
        try (InputStream in = this.getClass().getResourceAsStream("runelite.properties");){
            this.properties.load(in);
        }
        catch (IOException ex) {
            log.warn("unable to load propertries", ex);
        }
    }

    public String getTitle() {
        return this.properties.getProperty(RUNELITE_TITLE);
    }

    public String getVersion() {
        return this.properties.getProperty(RUNELITE_VERSION);
    }

    public String getRunescapeVersion() {
        return this.properties.getProperty(RUNESCAPE_VERSION);
    }

    public String getDiscordAppId() {
        return this.properties.getProperty(DISCORD_APP_ID);
    }

    public String getDiscordInvite() {
        return this.properties.getProperty(DISCORD_INVITE);
    }

    public String getGithubLink() {
        return this.properties.getProperty(GITHUB_LINK);
    }

    public String getWikiLink() {
        return this.properties.getProperty(WIKI_LINK);
    }

    public String getPatreonLink() {
        return this.properties.getProperty(PATREON_LINK);
    }

    @Nullable
    public static String getLauncherVersion() {
        return System.getProperty(LAUNCHER_VERSION_PROPERTY);
    }
}

