/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client;

import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.name.Names;
import java.applet.Applet;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.Nullable;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.hooks.Callbacks;
import net.runelite.client.RuneLite;
import net.runelite.client.RuneLiteProperties;
import net.runelite.client.account.SessionManager;
import net.runelite.client.callback.Hooks;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.config.ChatColorConfig;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.config.RuneLiteConfig;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.game.ItemManager;
import net.runelite.client.menus.MenuManager;
import net.runelite.client.plugins.PluginManager;
import net.runelite.client.rs.ClientLoader;
import net.runelite.client.rs.ClientUpdateCheckMode;
import net.runelite.client.task.Scheduler;
import net.runelite.client.util.DeferredEventBus;
import net.runelite.client.util.ExecutorServiceExceptionLogger;
import net.runelite.http.api.RuneLiteAPI;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuneLiteModule
extends AbstractModule {
    private static final Logger log = LoggerFactory.getLogger(RuneLiteModule.class);
    private final ClientUpdateCheckMode updateCheckMode;
    private final boolean developerMode;

    public RuneLiteModule(ClientUpdateCheckMode updateCheckMode, boolean developerMode) {
        this.updateCheckMode = updateCheckMode;
        this.developerMode = developerMode;
    }

    @Override
    protected void configure() {
        this.bindConstant().annotatedWith(Names.named("updateCheckMode")).to(this.updateCheckMode);
        this.bindConstant().annotatedWith(Names.named("developerMode")).to(this.developerMode);
        this.bind(ScheduledExecutorService.class).toInstance(new ExecutorServiceExceptionLogger(Executors.newSingleThreadScheduledExecutor()));
        this.bind(OkHttpClient.class).toInstance(RuneLiteAPI.CLIENT);
        this.bind(MenuManager.class);
        this.bind(ChatMessageManager.class);
        this.bind(ItemManager.class);
        this.bind(Scheduler.class);
        this.bind(PluginManager.class);
        this.bind(RuneLiteProperties.class);
        this.bind(SessionManager.class);
        this.bind(Callbacks.class).to(Hooks.class);
        this.bind(EventBus.class).toInstance(new EventBus());
        this.bind(EventBus.class).annotatedWith(Names.named("Deferred EventBus")).to(DeferredEventBus.class);
        this.bind(Logger.class).annotatedWith(Names.named("Core Logger")).toInstance(LoggerFactory.getLogger(RuneLite.class));
    }

    @Provides
    @Singleton
    Applet provideApplet(ClientLoader clientLoader) {
        return clientLoader.load();
    }

    @Provides
    @Singleton
    Client provideClient(@Nullable Applet applet) {
        return applet instanceof Client ? (Client)((Object)applet) : null;
    }

    @Provides
    @Singleton
    RuneLiteConfig provideConfig(ConfigManager configManager) {
        return configManager.getConfig(RuneLiteConfig.class);
    }

    @Provides
    @Singleton
    ChatColorConfig provideChatColorConfig(ConfigManager configManager) {
        return configManager.getConfig(ChatColorConfig.class);
    }
}

