/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client;

import ch.qos.logback.classic.Level;
import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.Locale;
import javax.annotation.Nullable;
import javax.inject.Provider;
import javax.inject.Singleton;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.util.EnumConverter;
import net.runelite.api.Client;
import net.runelite.client.ClientSessionManager;
import net.runelite.client.RuneLiteModule;
import net.runelite.client.RuneLiteProperties;
import net.runelite.client.account.SessionManager;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.CommandManager;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.discord.DiscordService;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.game.ClanManager;
import net.runelite.client.game.ItemManager;
import net.runelite.client.game.LootManager;
import net.runelite.client.game.chatbox.ChatboxPanelManager;
import net.runelite.client.menus.MenuManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginInstantiationException;
import net.runelite.client.plugins.PluginManager;
import net.runelite.client.rs.ClientUpdateCheckMode;
import net.runelite.client.ui.ClientUI;
import net.runelite.client.ui.DrawManager;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.ui.overlay.OverlayRenderer;
import net.runelite.client.ui.overlay.WidgetOverlay;
import net.runelite.client.ui.overlay.infobox.InfoBoxManager;
import net.runelite.client.ui.overlay.infobox.InfoBoxOverlay;
import net.runelite.client.ui.overlay.tooltip.TooltipOverlay;
import net.runelite.client.ui.overlay.worldmap.WorldMapOverlay;
import net.runelite.client.ws.PartyService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class RuneLite {
    private static final Logger log = LoggerFactory.getLogger(RuneLite.class);
    public static final String SERVER_NAME = "Zenyte";
    public static final File RUNELITE_DIR = new File(System.getProperty("user.home"), ".zenyte");
    public static final File PROFILES_DIR = new File(RUNELITE_DIR, "profiles");
    public static final File SCREENSHOT_DIR = new File(RUNELITE_DIR, "screenshots");
    private static Injector injector;
    @Inject
    private PluginManager pluginManager;
    @Inject
    private EventBus eventBus;
    @Inject
    private ConfigManager configManager;
    @Inject
    private DrawManager drawManager;
    @Inject
    private SessionManager sessionManager;
    @Inject
    private DiscordService discordService;
    @Inject
    private ClientSessionManager clientSessionManager;
    @Inject
    private ClientUI clientUI;
    @Inject
    private InfoBoxManager infoBoxManager;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private PartyService partyService;
    @Inject
    private Provider<ItemManager> itemManager;
    @Inject
    private Provider<OverlayRenderer> overlayRenderer;
    @Inject
    private Provider<ClanManager> clanManager;
    @Inject
    private Provider<ChatMessageManager> chatMessageManager;
    @Inject
    private Provider<MenuManager> menuManager;
    @Inject
    private Provider<CommandManager> commandManager;
    @Inject
    private Provider<InfoBoxOverlay> infoBoxOverlay;
    @Inject
    private Provider<TooltipOverlay> tooltipOverlay;
    @Inject
    private Provider<WorldMapOverlay> worldMapOverlay;
    @Inject
    private Provider<LootManager> lootManager;
    @Inject
    private Provider<ChatboxPanelManager> chatboxPanelManager;
    @Inject
    @Nullable
    private Client client;

    public static void main(String[] args) throws Exception {
        boolean developerMode;
        Locale.setDefault(Locale.ENGLISH);
        OptionParser parser = new OptionParser();
        parser.accepts("developer-mode", "Enable developer tools");
        parser.accepts("debug", "Show extra debugging output");
        ArgumentAcceptingOptionSpec<ClientUpdateCheckMode> updateMode = parser.accepts("rs", "Select client type").withRequiredArg().ofType(ClientUpdateCheckMode.class).defaultsTo(ClientUpdateCheckMode.AUTO, (ClientUpdateCheckMode[])new ClientUpdateCheckMode[0]).withValuesConvertedBy(new EnumConverter<ClientUpdateCheckMode>(ClientUpdateCheckMode.class){

            @Override
            public ClientUpdateCheckMode convert(String v) {
                return (ClientUpdateCheckMode)((Object)super.convert(v.toUpperCase()));
            }
        });
        parser.accepts("help", "Show this text").forHelp();
        OptionSet options = parser.parse(args);
        if (options.has("help")) {
            parser.printHelpOn(System.out);
            System.exit(0);
        }
        boolean bl = developerMode = options.has("developer-mode") && RuneLiteProperties.getLauncherVersion() == null;
        if (developerMode) {
            boolean assertions = false;
            if (!$assertionsDisabled) {
                assertions = true;
                if (!true) {
                    throw new AssertionError();
                }
            }
            if (!assertions) {
                throw new RuntimeException("Developers should enable assertions; Add `-ea` to your JVM arguments`");
            }
        }
        PROFILES_DIR.mkdirs();
        if (options.has("debug")) {
            ch.qos.logback.classic.Logger logger = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger("ROOT");
            logger.setLevel(Level.DEBUG);
        }
        Thread.setDefaultUncaughtExceptionHandler((thread, throwable) -> {
            log.error("Uncaught exception:", throwable);
            if (throwable instanceof AbstractMethodError) {
                log.error("Classes are out of date; Build with maven again.");
            }
        });
        long start = System.currentTimeMillis();
        injector = Guice.createInjector(new RuneLiteModule(options.valueOf(updateMode), developerMode));
        injector.getInstance(RuneLite.class).start();
        long end = System.currentTimeMillis();
        RuntimeMXBean rb = ManagementFactory.getRuntimeMXBean();
        long uptime = rb.getUptime();
        log.info("Client initialization took {}ms. Uptime: {}ms", (Object)(end - start), (Object)uptime);
    }

    public void start() throws Exception {
        boolean isOutdated;
        boolean bl = isOutdated = this.client == null;
        if (!isOutdated) {
            injector.injectMembers(this.client);
        }
        this.configManager.load();
        this.sessionManager.loadSession();
        this.pluginManager.setOutdated(isOutdated);
        this.pluginManager.loadCorePlugins();
        this.pluginManager.loadDefaultPluginConfiguration();
        this.clientSessionManager.start();
        this.clientUI.open(this);
        this.discordService.init();
        this.eventBus.register(this.clientUI);
        this.eventBus.register(this.pluginManager);
        this.eventBus.register(this.overlayManager);
        this.eventBus.register(this.drawManager);
        this.eventBus.register(this.infoBoxManager);
        this.eventBus.register(this.partyService);
        if (!isOutdated) {
            this.chatMessageManager.get().loadColors();
            this.eventBus.register(this.overlayRenderer.get());
            this.eventBus.register(this.clanManager.get());
            this.eventBus.register(this.itemManager.get());
            this.eventBus.register(this.menuManager.get());
            this.eventBus.register(this.chatMessageManager.get());
            this.eventBus.register(this.commandManager.get());
            this.eventBus.register(this.lootManager.get());
            this.eventBus.register(this.chatboxPanelManager.get());
            WidgetOverlay.createOverlays(this.client).forEach(this.overlayManager::add);
            this.overlayManager.add(this.infoBoxOverlay.get());
            this.overlayManager.add(this.worldMapOverlay.get());
            this.overlayManager.add(this.tooltipOverlay.get());
        }
        this.pluginManager.startCorePlugins();
    }

    public void shutdown() {
        this.configManager.sendConfig();
        this.clientSessionManager.shutdown();
        this.discordService.close();
        for (Plugin plugin : this.pluginManager.getPlugins()) {
            try {
                this.pluginManager.stopPlugin(plugin);
            }
            catch (PluginInstantiationException e) {
                log.warn("Failed to gracefully close plugin", e);
            }
        }
    }

    @VisibleForTesting
    public static void setInjector(Injector injector) {
        RuneLite.injector = injector;
    }

    public static Injector getInjector() {
        return injector;
    }
}

