/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client;

import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.client.SessionClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ClientSessionManager {
    private static final Logger log = LoggerFactory.getLogger(ClientSessionManager.class);
    private final SessionClient sessionClient = new SessionClient();
    private final ScheduledExecutorService executorService;
    private ScheduledFuture<?> scheduledFuture;
    private UUID sessionId;

    @Inject
    ClientSessionManager(ScheduledExecutorService executorService) {
        this.executorService = executorService;
    }

    public void start() {
        try {
            this.sessionId = this.sessionClient.open();
            log.debug("Opened session {}", (Object)this.sessionId);
        }
        catch (IOException ex) {
            log.warn("error opening session", ex);
        }
        this.scheduledFuture = this.executorService.scheduleWithFixedDelay(this::ping, 1L, 10L, TimeUnit.MINUTES);
    }

    public void shutdown() {
        if (this.sessionId != null) {
            try {
                this.sessionClient.delete(this.sessionId);
            }
            catch (IOException ex) {
                log.warn(null, ex);
            }
            this.sessionId = null;
        }
        this.scheduledFuture.cancel(true);
    }

    private void ping() {
        try {
            if (this.sessionId == null) {
                this.sessionId = this.sessionClient.open();
                log.debug("Opened session {}", (Object)this.sessionId);
                return;
            }
        }
        catch (IOException ex) {
            log.warn(null, ex);
        }
        try {
            this.sessionClient.ping(this.sessionId);
        }
        catch (IOException ex) {
            log.warn("Resetting session", ex);
            this.sessionId = null;
        }
    }
}

