/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.api.model;

import java.util.ArrayList;
import java.util.List;
import net.runelite.api.Point;

public class Jarvis {
    public static List<Point> convexHull(List<Point> points) {
        Point next;
        Point left;
        if (points.size() < 3) {
            return null;
        }
        ArrayList<Point> ch = new ArrayList<Point>();
        Point current = left = Jarvis.findLeftMost(points);
        do {
            ch.add(current);
            assert (ch.size() <= points.size()) : "hull has more points than graph";
            if (ch.size() > points.size()) {
                return null;
            }
            next = null;
            for (Point p : points) {
                if (next == null) {
                    next = p;
                    continue;
                }
                long cp = Jarvis.crossProduct(current, p, next);
                if (cp <= 0L && (cp != 0L || current.distanceTo(p) <= current.distanceTo(next))) continue;
                next = p;
            }
            if (next != null) continue;
            return null;
        } while ((current = next) != left);
        return ch;
    }

    private static Point findLeftMost(List<Point> points) {
        Point left = null;
        for (Point p : points) {
            if (left == null || p.getX() < left.getX()) {
                left = p;
                continue;
            }
            if (p.getX() != left.getX() || p.getY() >= left.getY()) continue;
            left = p;
        }
        return left;
    }

    private static long crossProduct(Point p, Point q, Point r) {
        long val = (long)(q.getY() - p.getY()) * (long)(r.getX() - q.getX()) - (long)(q.getX() - p.getX()) * (long)(r.getY() - q.getY());
        return val;
    }
}

