/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.api;

import java.util.Collection;
import java.util.EnumSet;

public enum WorldType {
    MEMBERS(1),
    PVP(4),
    BOUNTY(32),
    SKILL_TOTAL(128),
    HIGH_RISK(1024),
    LAST_MAN_STANDING(16384),
    TOURNAMENT(0x2000000),
    DEADMAN_TOURNAMENT(0x4000000),
    DEADMAN(0x20000000),
    SEASONAL_DEADMAN(0x40000000);

    private final int mask;
    private static final EnumSet<WorldType> PVP_WORLD_TYPES;

    private WorldType(int mask) {
        this.mask = mask;
    }

    public static EnumSet<WorldType> fromMask(int mask) {
        EnumSet<WorldType> types = EnumSet.noneOf(WorldType.class);
        for (WorldType type : WorldType.values()) {
            if ((mask & type.mask) == 0) continue;
            types.add(type);
        }
        return types;
    }

    public static int toMask(EnumSet<WorldType> types) {
        int mask = 0;
        for (WorldType type : types) {
            mask |= type.mask;
        }
        return mask;
    }

    public static boolean isPvpWorld(Collection<WorldType> worldTypes) {
        return worldTypes.stream().anyMatch(PVP_WORLD_TYPES::contains);
    }

    static {
        PVP_WORLD_TYPES = EnumSet.of(DEADMAN, DEADMAN_TOURNAMENT, PVP, SEASONAL_DEADMAN);
    }
}

